/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.beanmapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mapstruct.ap.internal.model.beanmapping.MappingReference;
import org.mapstruct.ap.internal.model.beanmapping.SourceReference;
import org.mapstruct.ap.internal.model.beanmapping.TargetReference;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.util.FormattingMessager;

public class MappingReferences {
    private static final MappingReferences EMPTY = new MappingReferences(Collections.emptySet(), false);
    private final Set<MappingReference> mappingReferences;
    private final List<MappingReference> targetThisReferences;
    private final boolean restrictToDefinedMappings;
    private final boolean forForgedMethods;

    public static MappingReferences empty() {
        return EMPTY;
    }

    public static MappingReferences forSourceMethod(SourceMethod sourceMethod, Type targetType, Set<String> targetProperties, FormattingMessager messager, TypeFactory typeFactory) {
        LinkedHashSet<MappingReference> references = new LinkedHashSet<MappingReference>();
        ArrayList<MappingReference> targetThisReferences = new ArrayList<MappingReference>();
        for (MappingOptions mapping : sourceMethod.getOptions().getMappings()) {
            SourceReference sourceReference = new SourceReference.BuilderFromMapping().mapping(mapping).method(sourceMethod).messager(messager).typeFactory(typeFactory).build();
            TargetReference targetReference = new TargetReference.Builder().mapping(mapping).method(sourceMethod).messager(messager).typeFactory(typeFactory).targetProperties(targetProperties).targetType(targetType).build();
            MappingReference mappingReference = new MappingReference(mapping, targetReference, sourceReference);
            if (!MappingReferences.isValidWhenInversed(mappingReference)) continue;
            if (".".equals(mapping.getTargetName())) {
                targetThisReferences.add(mappingReference);
                continue;
            }
            references.add(mappingReference);
        }
        return new MappingReferences(references, targetThisReferences, false);
    }

    public MappingReferences(Set<MappingReference> mappingReferences, List<MappingReference> targetThisReferences, boolean restrictToDefinedMappings) {
        this.mappingReferences = mappingReferences;
        this.restrictToDefinedMappings = restrictToDefinedMappings;
        this.forForgedMethods = restrictToDefinedMappings;
        this.targetThisReferences = targetThisReferences;
    }

    public MappingReferences(Set<MappingReference> mappingReferences, boolean restrictToDefinedMappings) {
        this.mappingReferences = mappingReferences;
        this.restrictToDefinedMappings = restrictToDefinedMappings;
        this.forForgedMethods = restrictToDefinedMappings;
        this.targetThisReferences = Collections.emptyList();
    }

    public MappingReferences(Set<MappingReference> mappingReferences, boolean restrictToDefinedMappings, boolean forForgedMethods) {
        this.mappingReferences = mappingReferences;
        this.restrictToDefinedMappings = restrictToDefinedMappings;
        this.forForgedMethods = forForgedMethods;
        this.targetThisReferences = Collections.emptyList();
    }

    public Set<MappingReference> getMappingReferences() {
        return this.mappingReferences;
    }

    public boolean isRestrictToDefinedMappings() {
        return this.restrictToDefinedMappings;
    }

    public boolean isForForgedMethods() {
        return this.forForgedMethods;
    }

    public Set<String> collectNestedDependsOn() {
        LinkedHashSet<String> nestedDependsOn = new LinkedHashSet<String>();
        for (MappingReference mapping : this.getMappingReferences()) {
            nestedDependsOn.addAll(mapping.getMapping().getDependsOn());
        }
        return nestedDependsOn;
    }

    public boolean hasNestedTargetReferences() {
        for (MappingReference mappingRef : this.mappingReferences) {
            TargetReference targetReference = mappingRef.getTargetReference();
            if (!targetReference.isNested()) continue;
            return true;
        }
        return false;
    }

    public List<MappingReference> getTargetThisReferences() {
        return this.targetThisReferences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MappingReferences)) {
            return false;
        }
        MappingReferences that = (MappingReferences)o;
        if (this.restrictToDefinedMappings != that.restrictToDefinedMappings) {
            return false;
        }
        if (this.forForgedMethods != that.forForgedMethods) {
            return false;
        }
        if (!Objects.equals(this.mappingReferences, that.mappingReferences)) {
            return false;
        }
        return !Objects.equals(this.targetThisReferences, that.targetThisReferences);
    }

    public int hashCode() {
        return this.mappingReferences != null ? this.mappingReferences.hashCode() : 0;
    }

    private static boolean isValidWhenInversed(MappingReference mappingRef) {
        MappingOptions mapping = mappingRef.getMapping();
        if (mapping.getInheritContext() != null && mapping.getInheritContext().isReversed()) {
            return mappingRef.getSourceReference() == null || mappingRef.getSourceReference().isValid();
        }
        return true;
    }
}

