/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.internal.gem.MappingGem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class MappingsGem
implements Gem {
    private final GemValue<List<MappingGem>> value;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private MappingsGem(BuilderImpl builder) {
        this.value = builder.value;
        this.isValid = this.value != null ? this.value.isValid() : false;
        this.mirror = builder.mirror;
    }

    public GemValue<List<MappingGem>> value() {
        return this.value;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static MappingsGem instanceOn(Element element) {
        return MappingsGem.build(element, new BuilderImpl());
    }

    public static MappingsGem instanceOn(AnnotationMirror mirror) {
        return MappingsGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "org.mapstruct.Mappings".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return MappingsGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if (!"value".equals(methodName)) continue;
            builder.setValue(GemValue.createArray((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), MappingGem::instanceOn));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<MappingsGem> {
        private GemValue<List<MappingGem>> value;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setValue(GemValue<List<MappingGem>> value) {
            this.value = value;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public MappingsGem build() {
            return new MappingsGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setValue(GemValue<List<MappingGem>> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

