/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.Writer;
import java.time.Clock;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import org.mapstruct.extensions.spring.converter.DelegatingConverterDescriptor;
import org.mapstruct.extensions.spring.converter.Generator;

public class DelegatingConverterGenerator
extends Generator {
    public DelegatingConverterGenerator(Clock clock) {
        super(clock);
    }

    public void writeGeneratedCodeToOutput(DelegatingConverterDescriptor descriptor, Writer outputWriter) {
        this.writeGeneratedCodeToOutput(() -> descriptor.getOriginalMapperClassName().packageName(), () -> this.createDelegatingConverterTypeSpec(descriptor), outputWriter);
    }

    private TypeSpec createDelegatingConverterTypeSpec(DelegatingConverterDescriptor descriptor) {
        TypeSpec.Builder converterTypeSpecBuilder = TypeSpec.classBuilder((ClassName)descriptor.getConverterClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)CONVERTER_CLASSNAME, (TypeName[])new TypeName[]{descriptor.getFromToMapping().getSource(), descriptor.getFromToMapping().getTarget()}));
        Optional.ofNullable(this.buildGeneratedAnnotationSpec()).ifPresent(arg_0 -> ((TypeSpec.Builder)converterTypeSpecBuilder).addAnnotation(arg_0));
        FieldSpec injectedMapperField = DelegatingConverterGenerator.buildMapperField(descriptor);
        return converterTypeSpecBuilder.addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0])).addField(injectedMapperField).addMethod(DelegatingConverterGenerator.buildConstructor(injectedMapperField)).addMethod(DelegatingConverterGenerator.buildConvertMethod(descriptor, injectedMapperField)).build();
    }

    private static MethodSpec buildConstructor(FieldSpec injectedMapperField) {
        ParameterSpec constructorParameter = DelegatingConverterGenerator.buildConstructorParameter(injectedMapperField);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(constructorParameter).addStatement("this.$N = $N", new Object[]{injectedMapperField, constructorParameter}).build();
    }

    private static ParameterSpec buildConstructorParameter(FieldSpec injectedMapperField) {
        return ParameterSpec.builder((TypeName)injectedMapperField.type, (String)injectedMapperField.name, (Modifier[])new Modifier[]{Modifier.FINAL}).addAnnotation(ClassName.get((String)"org.springframework.beans.factory.annotation", (String)"Autowired", (String[])new String[0])).build();
    }

    private static MethodSpec buildConvertMethod(DelegatingConverterDescriptor descriptor, FieldSpec injectedMapperField) {
        ParameterSpec sourceParameterSpec = DelegatingConverterGenerator.buildConvertSourceParameterSpec(descriptor);
        return MethodSpec.methodBuilder((String)"convert").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(sourceParameterSpec).returns(descriptor.getFromToMapping().getTarget()).addStatement("return $N.$L($N)", new Object[]{injectedMapperField, descriptor.getOriginalMapperMethodName(), sourceParameterSpec}).build();
    }

    private static ParameterSpec buildConvertSourceParameterSpec(DelegatingConverterDescriptor descriptor) {
        return ParameterSpec.builder((TypeName)descriptor.getFromToMapping().getSource(), (String)"source", (Modifier[])new Modifier[]{Modifier.FINAL}).build();
    }

    private static FieldSpec buildMapperField(DelegatingConverterDescriptor descriptor) {
        return FieldSpec.builder((TypeName)descriptor.getOriginalMapperClassName(), (String)"delegateMapper", (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }
}

