/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.mapstruct.extensions.spring.AdapterMethodName;
import org.mapstruct.extensions.spring.SpringMapperConfig;
import org.mapstruct.extensions.spring.converter.AdapterRelatedGenerator;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterGenerator;
import org.mapstruct.extensions.spring.converter.ConverterRegistrationConfigurationGenerator;
import org.mapstruct.extensions.spring.converter.ConverterScanGenerator;
import org.mapstruct.extensions.spring.converter.ConverterScansGenerator;
import org.mapstruct.extensions.spring.converter.DelegatingConverterDescriptor;
import org.mapstruct.extensions.spring.converter.DelegatingConverterGenerator;
import org.mapstruct.extensions.spring.converter.FromToMapping;
import org.mapstruct.extensions.spring.converter.GeneratorInitializingProcessor;
import org.mapstruct.extensions.spring.converter.ModelElementUtils;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper", "org.mapstruct.extensions.spring.SpringMapperConfig", "org.mapstruct.extensions.spring.DelegatingConverter"})
public class ConverterMapperProcessor
extends GeneratorInitializingProcessor {
    protected static final String DELEGATING_CONVERTER = "org.mapstruct.extensions.spring.DelegatingConverter";
    protected static final String MAPPER = "org.mapstruct.Mapper";
    protected static final String SPRING_MAPPER_CONFIG = "org.mapstruct.extensions.spring.SpringMapperConfig";
    protected static final String SPRING_CONVERTER_FULL_NAME = "org.springframework.core.convert.converter.Converter";
    private final ConversionServiceAdapterGenerator adapterGenerator;
    private final ConverterScanGenerator converterScanGenerator;
    private final ConverterScansGenerator converterScansGenerator;
    private final ConverterRegistrationConfigurationGenerator converterRegistrationConfigurationGenerator;
    private final DelegatingConverterGenerator delegatingConverterGenerator;

    public ConverterMapperProcessor() {
        this(Clock.systemUTC());
    }

    ConverterMapperProcessor(Clock clock) {
        this(new ConversionServiceAdapterGenerator(clock), new ConverterScanGenerator(clock), new ConverterScansGenerator(clock), new ConverterRegistrationConfigurationGenerator(clock), new DelegatingConverterGenerator(clock));
    }

    ConverterMapperProcessor(ConversionServiceAdapterGenerator adapterGenerator, ConverterScanGenerator converterScanGenerator, ConverterScansGenerator converterScansGenerator, ConverterRegistrationConfigurationGenerator converterRegistrationConfigurationGenerator, DelegatingConverterGenerator delegatingConverterGenerator) {
        super(adapterGenerator, converterScanGenerator, converterScansGenerator, converterRegistrationConfigurationGenerator, delegatingConverterGenerator);
        this.adapterGenerator = adapterGenerator;
        this.converterScanGenerator = converterScanGenerator;
        this.converterScansGenerator = converterScansGenerator;
        this.converterRegistrationConfigurationGenerator = converterRegistrationConfigurationGenerator;
        this.delegatingConverterGenerator = delegatingConverterGenerator;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        List<DelegatingConverterDescriptor> delegatingConverterDescriptors = annotations.stream().filter(ConverterMapperProcessor::isDelegatingConverterAnnotation).map(roundEnv::getElementsAnnotatedWith).flatMap(Collection::stream).map(ExecutableElement.class::cast).map(annotatedMethod -> new DelegatingConverterDescriptor((ExecutableElement)annotatedMethod, this.processingEnv)).collect(Collectors.toList());
        delegatingConverterDescriptors.forEach(this::writeDelegatingConverterFile);
        ConversionServiceAdapterDescriptor adapterDescriptor = this.buildAdapterDescriptor(annotations, roundEnv);
        annotations.stream().filter(ConverterMapperProcessor::isMapperAnnotation).forEach(annotation -> this.processMapperAnnotation(roundEnv, adapterDescriptor, delegatingConverterDescriptors, (TypeElement)annotation));
        return false;
    }

    private void writeDelegatingConverterFile(DelegatingConverterDescriptor descriptor) {
        try (Writer outputWriter = this.openSourceFile(descriptor::getConverterClassName);){
            this.delegatingConverterGenerator.writeGeneratedCodeToOutput(descriptor, outputWriter);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Error while opening %s output file: %s", descriptor.getConverterClassName().simpleName(), e.getMessage()));
        }
    }

    private static boolean isDelegatingConverterAnnotation(TypeElement annotation) {
        return DELEGATING_CONVERTER.contentEquals(annotation.getQualifiedName());
    }

    private ConversionServiceAdapterDescriptor buildAdapterDescriptor(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return new ConversionServiceAdapterDescriptor().adapterClassName(this.getAdapterClassName(annotations, roundEnv)).conversionServiceBeanName(ConverterMapperProcessor.getConversionServiceBeanName(annotations, roundEnv)).generateConverterScan(ConverterMapperProcessor.getGenerateConverterScan(annotations, roundEnv)).lazyAnnotatedConversionServiceBean(ConverterMapperProcessor.getLazyAnnotatedConversionServiceBean(annotations, roundEnv)).configurationClassName(ConverterMapperProcessor.getConfigurationClassName(annotations, roundEnv)).fromToMappings(this.getExternalConversionMappings(annotations, roundEnv));
    }

    private List<FromToMapping> getExternalConversionMappings(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).flatMap(this::toSpringMapperConfigMirror).map(AnnotationMirror::getElementValues).flatMap(this::extractExternalConversions).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(List.class::cast).map(this::toFromToMappings).orElse(Collections.emptyList());
    }

    private List<FromToMapping> toFromToMappings(List<? extends AnnotationMirror> list) {
        return list.stream().map(AnnotationMirror::getElementValues).map(this::toFromToMapping).collect(Collectors.toList());
    }

    private FromToMapping toFromToMapping(Map<? extends ExecutableElement, ? extends AnnotationValue> elementMap) {
        return new FromToMapping().source(TypeName.get((TypeMirror)ConverterMapperProcessor.findSourceType(elementMap))).target(TypeName.get((TypeMirror)ConverterMapperProcessor.findTargetType(elementMap))).adapterMethodName(ConverterMapperProcessor.findAdapterMethodName(elementMap));
    }

    private Optional<? extends Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> extractExternalConversions(Map<? extends ExecutableElement, ? extends AnnotationValue> map) {
        return map.entrySet().stream().filter(this::hasNameExternalConversions).findFirst();
    }

    private boolean hasNameExternalConversions(Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry) {
        return ModelElementUtils.hasName(entry.getKey().getSimpleName(), "externalConversions");
    }

    private static String findAdapterMethodName(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return (String)StringUtils.defaultIfBlank((CharSequence)ConverterMapperProcessor.findAttribute(externalConversionElementMap, "adapterMethodName", String.class), null);
    }

    private static TypeMirror findTargetType(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return ConverterMapperProcessor.findTypeMirrorAttribute(externalConversionElementMap, "targetType");
    }

    private static TypeMirror findSourceType(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap) {
        return ConverterMapperProcessor.findTypeMirrorAttribute(externalConversionElementMap, "sourceType");
    }

    private static TypeMirror findTypeMirrorAttribute(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap, String attributeName) {
        return ConverterMapperProcessor.findAttribute(externalConversionElementMap, attributeName, TypeMirror.class);
    }

    private static <T> T findAttribute(Map<? extends ExecutableElement, ? extends AnnotationValue> externalConversionElementMap, String attributeName, Class<T> attributeClass) {
        return externalConversionElementMap.entrySet().stream().filter(entry -> ModelElementUtils.hasName(((ExecutableElement)entry.getKey()).getSimpleName(), attributeName)).map(Map.Entry::getValue).map(AnnotationValue::getValue).map(attributeClass::cast).findFirst().orElse(null);
    }

    private static boolean isMapperAnnotation(TypeElement annotation) {
        return MAPPER.contentEquals(annotation.getQualifiedName());
    }

    private void processMapperAnnotation(RoundEnvironment roundEnv, ConversionServiceAdapterDescriptor adapterDescriptor, List<DelegatingConverterDescriptor> delegatingConverterDescriptors, TypeElement annotation) {
        List fromToMappings = roundEnv.getElementsAnnotatedWith(annotation).stream().filter(ConverterMapperProcessor::isKindDeclared).filter(this::hasConverterSupertype).map(this::toFromToMapping).collect(Collectors.toCollection(ArrayList::new));
        fromToMappings.addAll(adapterDescriptor.getFromToMappings());
        fromToMappings.addAll(delegatingConverterDescriptors.stream().map(DelegatingConverterDescriptor::getFromToMapping).collect(Collectors.toList()));
        adapterDescriptor.fromToMappings(fromToMappings);
        this.writeAdapterClassFile(adapterDescriptor);
        if (adapterDescriptor.isGenerateConverterScan()) {
            this.writeConverterScanFiles(adapterDescriptor);
        }
    }

    private boolean hasConverterSupertype(Element mapper) {
        return this.getConverterSupertype(mapper).isPresent();
    }

    private static boolean isKindDeclared(Element mapper) {
        return mapper.asType().getKind() == TypeKind.DECLARED;
    }

    private FromToMapping toFromToMapping(Element mapper) {
        List<? extends TypeMirror> sourceTypeTargetType = this.toTypeArguments(mapper);
        return new FromToMapping().source(TypeName.get((TypeMirror)sourceTypeTargetType.get(0))).target(TypeName.get((TypeMirror)sourceTypeTargetType.get(1))).adapterMethodName(Optional.ofNullable(mapper.getAnnotation(AdapterMethodName.class)).map(AdapterMethodName::value).orElse(null));
    }

    private List<? extends TypeMirror> toTypeArguments(Element mapper) {
        return ((DeclaredType)this.getConverterSupertype(mapper).orElseThrow()).getTypeArguments();
    }

    private void writeAdapterClassFile(ConversionServiceAdapterDescriptor descriptor) {
        this.writeOutputFile(descriptor, this::openAdapterFile, this.adapterGenerator, descriptor::getAdapterClassName);
    }

    private void writeConverterScanFiles(ConversionServiceAdapterDescriptor descriptor) {
        this.writeOutputFile(descriptor, this::openConverterScanFile, this.converterScanGenerator, descriptor::getConverterScanClassName);
        this.writeOutputFile(descriptor, this::openConverterScansFile, this.converterScansGenerator, descriptor::getConverterScansClassName);
        this.writeOutputFile(descriptor, this::openConverterRegistrationConfigurationFile, this.converterRegistrationConfigurationGenerator, descriptor::getConverterRegistrationConfigurationClassName);
    }

    private void writeOutputFile(ConversionServiceAdapterDescriptor descriptor, OpenFileFunction openFileFunction, AdapterRelatedGenerator generator, Supplier<ClassName> outputFileClassNameSupplier) {
        try (Writer outputWriter = openFileFunction.open(descriptor);){
            generator.writeGeneratedCodeToOutput(descriptor, outputWriter);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Error while opening %s output file: %s", outputFileClassNameSupplier.get().simpleName(), e.getMessage()));
        }
    }

    private Writer openConverterRegistrationConfigurationFile(ConversionServiceAdapterDescriptor descriptor) throws IOException {
        return this.openSourceFile(descriptor::getConverterRegistrationConfigurationClassName);
    }

    private Writer openConverterScanFile(ConversionServiceAdapterDescriptor descriptor) throws IOException {
        return this.openSourceFile(descriptor::getConverterScanClassName);
    }

    private Writer openConverterScansFile(ConversionServiceAdapterDescriptor descriptor) throws IOException {
        return this.openSourceFile(descriptor::getConverterScansClassName);
    }

    private Writer openAdapterFile(ConversionServiceAdapterDescriptor descriptor) throws IOException {
        return this.openSourceFile(descriptor::getAdapterClassName);
    }

    private ClassName getAdapterClassName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MutablePair<String, String> packageAndClass = ConverterMapperProcessor.defaultPackageAndClassName();
        this.updateFromConfigAnnotationIfFound(annotations, roundEnv, packageAndClass);
        return ClassName.get((String)((String)packageAndClass.getLeft()), (String)((String)packageAndClass.getRight()), (String[])new String[0]);
    }

    private static MutablePair<String, String> defaultPackageAndClassName() {
        return MutablePair.of((Object)ConverterMapperProcessor.class.getPackage().getName(), (Object)"ConversionServiceAdapter");
    }

    private void updateFromConfigAnnotationIfFound(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, MutablePair<String, String> packageAndClass) {
        annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).forEach(annotation -> this.updateFromSpringMapperConfig(packageAndClass, (TypeElement)annotation, roundEnv));
    }

    private void updateFromSpringMapperConfig(MutablePair<String, String> packageAndClass, TypeElement springMapperConfig, RoundEnvironment roundEnv) {
        roundEnv.getElementsAnnotatedWith(springMapperConfig).forEach(element -> this.updateFromDeclaration(packageAndClass, (Element)element));
    }

    private static boolean isSpringMapperConfigAnnotation(TypeElement annotation) {
        return SPRING_MAPPER_CONFIG.contentEquals(annotation.getQualifiedName());
    }

    private void updateFromDeclaration(MutablePair<String, String> adapterPackageAndClass, Element element) {
        SpringMapperConfig springMapperConfig = ConverterMapperProcessor.toSpringMapperConfig(element);
        adapterPackageAndClass.setLeft((Object)Optional.of(springMapperConfig.conversionServiceAdapterPackage()).filter(StringUtils::isNotBlank).orElseGet(() -> this.getPackageName(element)));
        adapterPackageAndClass.setRight((Object)springMapperConfig.conversionServiceAdapterClassName());
    }

    private String getPackageName(Element element) {
        return String.valueOf(this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName());
    }

    private static String getConversionServiceBeanName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return ConverterMapperProcessor.getConfigAnnotationAttribute(annotations, roundEnv, SpringMapperConfig::conversionServiceBeanName, "conversionService");
    }

    private static Optional<? extends Element> findFirstElementAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotation) {
        return roundEnv.getElementsAnnotatedWith(annotation).stream().findFirst();
    }

    private static SpringMapperConfig toSpringMapperConfig(Element element) {
        return element.getAnnotation(SpringMapperConfig.class);
    }

    private Optional<? extends AnnotationMirror> toSpringMapperConfigMirror(Element element) {
        return element.getAnnotationMirrors().stream().filter(this::isSpringMapperConfigMirror).findFirst();
    }

    private boolean isSpringMapperConfigMirror(AnnotationMirror annotationMirror) {
        return this.processingEnv.getElementUtils().getTypeElement(SpringMapperConfig.class.getName()).asType().equals(annotationMirror.getAnnotationType().asElement().asType());
    }

    private static boolean getLazyAnnotatedConversionServiceBean(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return ConverterMapperProcessor.getConfigAnnotationAttribute(annotations, roundEnv, SpringMapperConfig::lazyAnnotatedConversionServiceBean, Boolean.TRUE);
    }

    private static String getConfigurationClassName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return ConverterMapperProcessor.getConfigAnnotationAttribute(annotations, roundEnv, SpringMapperConfig::converterRegistrationConfigurationClassName, "ConverterRegistrationConfiguration");
    }

    private static boolean getGenerateConverterScan(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return ConverterMapperProcessor.getConfigAnnotationAttribute(annotations, roundEnv, SpringMapperConfig::generateConverterScan, Boolean.FALSE);
    }

    private static <T> T getConfigAnnotationAttribute(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv, Function<SpringMapperConfig, T> attributeGetter, T defaultValue) {
        return annotations.stream().filter(ConverterMapperProcessor::isSpringMapperConfigAnnotation).findFirst().flatMap(annotation -> ConverterMapperProcessor.findFirstElementAnnotatedWith(roundEnv, annotation)).map(ConverterMapperProcessor::toSpringMapperConfig).map(attributeGetter).orElse(defaultValue);
    }

    private Optional<? extends TypeMirror> getConverterSupertype(Element mapper) {
        return this.getDirectSupertypes(mapper).stream().filter(this::isSpringConverterType).findFirst();
    }

    private List<? extends TypeMirror> getDirectSupertypes(Element mapper) {
        return this.processingEnv.getTypeUtils().directSupertypes(mapper.asType());
    }

    private boolean isSpringConverterType(TypeMirror supertype) {
        return this.processingEnv.getTypeUtils().erasure(supertype).toString().equals(SPRING_CONVERTER_FULL_NAME);
    }

    private static interface OpenFileFunction {
        public Writer open(ConversionServiceAdapterDescriptor var1) throws IOException;
    }
}

