/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.littleshoot.proxy.ActivityTracker;
import org.littleshoot.proxy.FlowContext;
import org.littleshoot.proxy.FullFlowContext;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersAdapter;
import org.littleshoot.proxy.ProxyAuthenticator;
import org.littleshoot.proxy.SslEngineSource;
import org.littleshoot.proxy.impl.ConnectionFlowStep;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyToServerConnection;
import org.littleshoot.proxy.impl.ProxyUtils;

public class ClientToProxyConnection
extends ProxyConnection<HttpRequest> {
    private static final HttpResponseStatus CONNECTION_ESTABLISHED = new HttpResponseStatus(200, "HTTP/1.1 200 Connection established");
    private static final String LOWERCASE_TRANSFER_ENCODING_HEADER = "Transfer-Encoding".toLowerCase(Locale.US);
    private static final Pattern HTTP_SCHEME = Pattern.compile("^http://.*", 2);
    private final Map<String, ProxyToServerConnection> serverConnectionsByHostAndPort = new ConcurrentHashMap<String, ProxyToServerConnection>();
    private final AtomicInteger numberOfCurrentlyConnectingServers = new AtomicInteger(0);
    private final AtomicInteger numberOfCurrentlyConnectedServers = new AtomicInteger(0);
    private final AtomicInteger numberOfReusedServerConnections = new AtomicInteger(0);
    private volatile ProxyToServerConnection currentServerConnection;
    private volatile HttpFilters currentFilters = HttpFiltersAdapter.NOOP_FILTER;
    private volatile SSLSession clientSslSession;
    private volatile boolean mitming = false;
    private AtomicBoolean authenticated = new AtomicBoolean();
    private final GlobalTrafficShapingHandler globalTrafficShapingHandler;
    private volatile HttpRequest currentRequest;
    ConnectionFlowStep RespondCONNECTSuccessful = new ConnectionFlowStep(this, ConnectionState.NEGOTIATING_CONNECT){

        @Override
        boolean shouldSuppressInitialRequest() {
            return true;
        }

        protected Future<?> execute() {
            ClientToProxyConnection.this.LOG.debug("Responding with CONNECT successful", new Object[0]);
            DefaultFullHttpResponse response = ClientToProxyConnection.this.responseFor(HttpVersion.HTTP_1_1, CONNECTION_ESTABLISHED);
            response.headers().set("Connection", (Object)"keep-alive");
            response.headers().set("Proxy-Connection", (Object)"keep-alive");
            ProxyUtils.addVia((HttpMessage)response, ClientToProxyConnection.this.proxyServer.getProxyAlias());
            return ClientToProxyConnection.this.writeToChannel(response);
        }
    };
    private final ProxyConnection.BytesReadMonitor bytesReadMonitor = new ProxyConnection.BytesReadMonitor(){

        @Override
        protected void bytesRead(int numberOfBytes) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesReceivedFromClient(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.RequestReadMonitor requestReadMonitor = new ProxyConnection.RequestReadMonitor(){

        @Override
        protected void requestRead(HttpRequest httpRequest) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.requestReceivedFromClient(flowContext, httpRequest);
            }
        }
    };
    private ProxyConnection.BytesWrittenMonitor bytesWrittenMonitor = new ProxyConnection.BytesWrittenMonitor(){

        @Override
        protected void bytesWritten(int numberOfBytes) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.bytesSentToClient(flowContext, numberOfBytes);
            }
        }
    };
    private ProxyConnection.ResponseWrittenMonitor responseWrittenMonitor = new ProxyConnection.ResponseWrittenMonitor(){

        @Override
        protected void responseWritten(HttpResponse httpResponse) {
            FlowContext flowContext = ClientToProxyConnection.this.flowContext();
            for (ActivityTracker tracker : ClientToProxyConnection.this.proxyServer.getActivityTrackers()) {
                tracker.responseSentToClient(flowContext, httpResponse);
            }
        }
    };

    ClientToProxyConnection(DefaultHttpProxyServer proxyServer, SslEngineSource sslEngineSource, boolean authenticateClients, ChannelPipeline pipeline, GlobalTrafficShapingHandler globalTrafficShapingHandler) {
        super(ConnectionState.AWAITING_INITIAL, proxyServer, false);
        this.initChannelPipeline(pipeline);
        if (sslEngineSource != null) {
            this.LOG.debug("Enabling encryption of traffic from client to proxy", new Object[0]);
            this.encrypt(pipeline, sslEngineSource.newSslEngine(), authenticateClients).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                public void operationComplete(Future<? super Channel> future) throws Exception {
                    if (future.isSuccess()) {
                        ClientToProxyConnection.this.clientSslSession = ClientToProxyConnection.this.sslEngine.getSession();
                        ClientToProxyConnection.this.recordClientSSLHandshakeSucceeded();
                    }
                }
            });
        }
        this.globalTrafficShapingHandler = globalTrafficShapingHandler;
        this.LOG.debug("Created ClientToProxyConnection", new Object[0]);
    }

    @Override
    protected ConnectionState readHTTPInitial(HttpRequest httpRequest) {
        this.LOG.debug("Got request: {}", httpRequest);
        boolean authenticationRequired = this.authenticationRequired(httpRequest);
        if (authenticationRequired) {
            this.LOG.debug("Not authenticated!!", new Object[0]);
            return ConnectionState.AWAITING_PROXY_AUTHENTICATION;
        }
        return this.doReadHTTPInitial(httpRequest);
    }

    private ConnectionState doReadHTTPInitial(HttpRequest httpRequest) {
        this.currentRequest = this.copy(httpRequest);
        HttpFilters filterInstance = this.proxyServer.getFiltersSource().filterRequest(this.currentRequest, this.ctx);
        this.currentFilters = filterInstance != null ? filterInstance : HttpFiltersAdapter.NOOP_FILTER;
        HttpResponse clientToProxyFilterResponse = this.currentFilters.clientToProxyRequest((HttpObject)httpRequest);
        if (clientToProxyFilterResponse != null) {
            this.LOG.debug("Responding to client with short-circuit response from filter: {}", clientToProxyFilterResponse);
            boolean keepAlive = this.respondWithShortCircuitResponse(clientToProxyFilterResponse);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        if (this.isRequestToOriginServer(httpRequest)) {
            boolean keepAlive = this.writeBadRequest(httpRequest);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        String serverHostAndPort = this.identifyHostAndPort(httpRequest);
        this.LOG.debug("Ensuring that hostAndPort are available in {}", httpRequest.getUri());
        if (serverHostAndPort == null || StringUtils.isBlank((CharSequence)serverHostAndPort)) {
            this.LOG.warn("No host and port found in {}", httpRequest.getUri());
            boolean keepAlive = this.writeBadGateway(httpRequest);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        this.LOG.debug("Finding ProxyToServerConnection for: {}", serverHostAndPort);
        this.currentServerConnection = this.isMitming() || this.isTunneling() ? this.currentServerConnection : this.serverConnectionsByHostAndPort.get(serverHostAndPort);
        boolean newConnectionRequired = false;
        if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
            this.LOG.debug("Not reusing existing ProxyToServerConnection because request is a CONNECT for: {}", serverHostAndPort);
            newConnectionRequired = true;
        } else if (this.currentServerConnection == null) {
            this.LOG.debug("Didn't find existing ProxyToServerConnection for: {}", serverHostAndPort);
            newConnectionRequired = true;
        }
        if (newConnectionRequired) {
            try {
                this.currentServerConnection = ProxyToServerConnection.create(this.proxyServer, this, serverHostAndPort, this.currentFilters, httpRequest, this.globalTrafficShapingHandler);
                if (this.currentServerConnection == null) {
                    this.LOG.debug("Unable to create server connection, probably no chained proxies available", new Object[0]);
                    boolean keepAlive = this.writeBadGateway(httpRequest);
                    this.resumeReading();
                    if (keepAlive) {
                        return ConnectionState.AWAITING_INITIAL;
                    }
                    return ConnectionState.DISCONNECT_REQUESTED;
                }
                this.serverConnectionsByHostAndPort.put(serverHostAndPort, this.currentServerConnection);
            }
            catch (UnknownHostException uhe) {
                this.LOG.info("Bad Host {}", httpRequest.getUri());
                boolean keepAlive = this.writeBadGateway(httpRequest);
                this.resumeReading();
                if (keepAlive) {
                    return ConnectionState.AWAITING_INITIAL;
                }
                return ConnectionState.DISCONNECT_REQUESTED;
            }
        } else {
            this.LOG.debug("Reusing existing server connection: {}", new Object[]{this.currentServerConnection});
            this.numberOfReusedServerConnections.incrementAndGet();
        }
        this.modifyRequestHeadersToReflectProxying(httpRequest);
        HttpResponse proxyToServerFilterResponse = this.currentFilters.proxyToServerRequest((HttpObject)httpRequest);
        if (proxyToServerFilterResponse != null) {
            this.LOG.debug("Responding to client with short-circuit response from filter: {}", proxyToServerFilterResponse);
            boolean keepAlive = this.respondWithShortCircuitResponse(proxyToServerFilterResponse);
            if (keepAlive) {
                return ConnectionState.AWAITING_INITIAL;
            }
            return ConnectionState.DISCONNECT_REQUESTED;
        }
        this.LOG.debug("Writing request to ProxyToServerConnection", new Object[0]);
        this.currentServerConnection.write(httpRequest, this.currentFilters);
        if (ProxyUtils.isCONNECT((HttpObject)httpRequest)) {
            return ConnectionState.NEGOTIATING_CONNECT;
        }
        if (ProxyUtils.isChunked((HttpObject)httpRequest)) {
            return ConnectionState.AWAITING_CHUNK;
        }
        return ConnectionState.AWAITING_INITIAL;
    }

    private boolean isRequestToOriginServer(HttpRequest httpRequest) {
        if (httpRequest.getMethod() == HttpMethod.CONNECT || this.isMitming()) {
            return false;
        }
        String uri = httpRequest.getUri();
        return !HTTP_SCHEME.matcher(uri).matches();
    }

    @Override
    protected void readHTTPChunk(HttpContent chunk) {
        this.currentFilters.clientToProxyRequest((HttpObject)chunk);
        this.currentFilters.proxyToServerRequest((HttpObject)chunk);
        this.currentServerConnection.write(chunk);
    }

    @Override
    protected void readRaw(ByteBuf buf) {
        this.currentServerConnection.write(buf);
    }

    void respond(ProxyToServerConnection serverConnection, HttpFilters filters, HttpRequest currentHttpRequest, HttpResponse currentHttpResponse, HttpObject httpObject) {
        this.currentRequest = null;
        if ((httpObject = filters.serverToProxyResponse(httpObject)) == null) {
            this.forceDisconnect(serverConnection);
            return;
        }
        if (httpObject instanceof HttpResponse) {
            HttpResponse httpResponse = (HttpResponse)httpObject;
            if (!ProxyUtils.isHead(currentHttpRequest) && !ProxyUtils.isResponseSelfTerminating(httpResponse)) {
                if (!(httpResponse instanceof FullHttpResponse)) {
                    HttpResponse duplicateResponse;
                    httpResponse = duplicateResponse = ProxyUtils.duplicateHttpResponse(httpResponse);
                    httpObject = httpResponse;
                }
                HttpHeaders.setTransferEncodingChunked((HttpMessage)httpResponse);
            }
            this.fixHttpVersionHeaderIfNecessary(httpResponse);
            this.modifyResponseHeadersToReflectProxying(httpResponse);
        }
        if ((httpObject = filters.proxyToClientResponse(httpObject)) == null) {
            this.forceDisconnect(serverConnection);
            return;
        }
        this.write(httpObject);
        if (ProxyUtils.isLastChunk(httpObject)) {
            this.writeEmptyBuffer();
        }
        this.closeConnectionsAfterWriteIfNecessary(serverConnection, currentHttpRequest, currentHttpResponse, httpObject);
    }

    @Override
    protected void connected() {
        super.connected();
        this.become(ConnectionState.AWAITING_INITIAL);
        this.recordClientConnected();
    }

    @Override
    protected void timedOut() {
        boolean clientReadMoreRecentlyThanServer;
        boolean bl = clientReadMoreRecentlyThanServer = this.currentServerConnection == null || this.lastReadTime > this.currentServerConnection.lastReadTime;
        if (clientReadMoreRecentlyThanServer) {
            this.LOG.debug("Server timed out: {}", new Object[]{this.currentServerConnection});
            this.currentFilters.serverToProxyResponseTimedOut();
            this.writeGatewayTimeout(this.currentRequest);
        } else {
            super.timedOut();
        }
    }

    @Override
    protected void disconnected() {
        super.disconnected();
        for (ProxyToServerConnection serverConnection : this.serverConnectionsByHostAndPort.values()) {
            serverConnection.disconnect();
        }
        this.recordClientDisconnected();
    }

    protected void serverConnectionFlowStarted(ProxyToServerConnection serverConnection) {
        this.stopReading();
        this.numberOfCurrentlyConnectingServers.incrementAndGet();
    }

    protected void serverConnectionSucceeded(ProxyToServerConnection serverConnection, boolean shouldForwardInitialRequest) {
        this.LOG.debug("Connection to server succeeded: {}", serverConnection.getRemoteAddress());
        this.resumeReadingIfNecessary();
        this.become(shouldForwardInitialRequest ? this.getCurrentState() : ConnectionState.AWAITING_INITIAL);
        this.numberOfCurrentlyConnectedServers.incrementAndGet();
    }

    protected boolean serverConnectionFailed(ProxyToServerConnection serverConnection, ConnectionState lastStateBeforeFailure, Throwable cause) {
        this.resumeReadingIfNecessary();
        HttpRequest initialRequest = serverConnection.getInitialRequest();
        try {
            boolean retrying = serverConnection.connectionFailed(cause);
            if (retrying) {
                this.LOG.debug("Failed to connect to upstream server or chained proxy. Retrying connection. Last state before failure: {}", new Object[]{lastStateBeforeFailure, cause});
                return true;
            }
            this.LOG.debug("Connection to upstream server or chained proxy failed: {}.  Last state before failure: {}", new Object[]{serverConnection.getRemoteAddress(), lastStateBeforeFailure, cause});
            this.connectionFailedUnrecoverably(initialRequest, serverConnection);
            return false;
        }
        catch (UnknownHostException uhe) {
            this.connectionFailedUnrecoverably(initialRequest, serverConnection);
            return false;
        }
    }

    private void connectionFailedUnrecoverably(HttpRequest initialRequest, ProxyToServerConnection serverConnection) {
        serverConnection.disconnect();
        this.serverConnectionsByHostAndPort.remove(serverConnection.getServerHostAndPort());
        boolean keepAlive = this.writeBadGateway(initialRequest);
        if (keepAlive) {
            this.become(ConnectionState.AWAITING_INITIAL);
        } else {
            this.become(ConnectionState.DISCONNECT_REQUESTED);
        }
    }

    private void resumeReadingIfNecessary() {
        if (this.numberOfCurrentlyConnectingServers.decrementAndGet() == 0) {
            this.LOG.debug("All servers have finished attempting to connect, resuming reading from client.", new Object[0]);
            this.resumeReading();
        }
    }

    protected void serverDisconnected(ProxyToServerConnection serverConnection) {
        this.numberOfCurrentlyConnectedServers.decrementAndGet();
        if (this.isTunneling() || this.isMitming()) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void becameSaturated() {
        super.becameSaturated();
        Iterator<ProxyToServerConnection> iterator = this.serverConnectionsByHostAndPort.values().iterator();
        while (iterator.hasNext()) {
            ProxyToServerConnection serverConnection;
            ProxyToServerConnection proxyToServerConnection = serverConnection = iterator.next();
            synchronized (proxyToServerConnection) {
                if (this.isSaturated()) {
                    serverConnection.stopReading();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void becameWritable() {
        super.becameWritable();
        Iterator<ProxyToServerConnection> iterator = this.serverConnectionsByHostAndPort.values().iterator();
        while (iterator.hasNext()) {
            ProxyToServerConnection serverConnection;
            ProxyToServerConnection proxyToServerConnection = serverConnection = iterator.next();
            synchronized (proxyToServerConnection) {
                if (!this.isSaturated()) {
                    serverConnection.resumeReading();
                }
            }
        }
    }

    protected synchronized void serverBecameSaturated(ProxyToServerConnection serverConnection) {
        if (serverConnection.isSaturated()) {
            this.LOG.info("Connection to server became saturated, stopping reading", new Object[0]);
            this.stopReading();
        }
    }

    protected synchronized void serverBecameWriteable(ProxyToServerConnection serverConnection) {
        boolean anyServersSaturated = false;
        for (ProxyToServerConnection otherServerConnection : this.serverConnectionsByHostAndPort.values()) {
            if (!otherServerConnection.isSaturated()) continue;
            anyServersSaturated = true;
            break;
        }
        if (!anyServersSaturated) {
            this.LOG.info("All server connections writeable, resuming reading", new Object[0]);
            this.resumeReading();
        }
    }

    @Override
    protected void exceptionCaught(Throwable cause) {
        try {
            if (cause instanceof IOException) {
                this.LOG.info("An IOException occurred on ClientToProxyConnection: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("An IOException occurred on ClientToProxyConnection", cause);
            } else if (cause instanceof RejectedExecutionException) {
                this.LOG.info("An executor rejected a read or write operation on the ClientToProxyConnection (this is normal if the proxy is shutting down). Message: " + cause.getMessage(), new Object[0]);
                this.LOG.debug("A RejectedExecutionException occurred on ClientToProxyConnection", cause);
            } else {
                this.LOG.error("Caught an exception on ClientToProxyConnection", cause);
            }
        }
        finally {
            this.disconnect();
        }
    }

    private void initChannelPipeline(ChannelPipeline pipeline) {
        this.LOG.debug("Configuring ChannelPipeline", new Object[0]);
        pipeline.addLast("bytesReadMonitor", (ChannelHandler)this.bytesReadMonitor);
        pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder(8192, 16384, 16384));
        pipeline.addLast("requestReadMonitor", (ChannelHandler)this.requestReadMonitor);
        int numberOfBytesToBuffer = this.proxyServer.getFiltersSource().getMaximumRequestBufferSizeInBytes();
        if (numberOfBytesToBuffer > 0) {
            this.aggregateContentForFiltering(pipeline, numberOfBytesToBuffer);
        }
        pipeline.addLast("bytesWrittenMonitor", (ChannelHandler)this.bytesWrittenMonitor);
        pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
        pipeline.addLast("responseWrittenMonitor", (ChannelHandler)this.responseWrittenMonitor);
        pipeline.addLast("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.proxyServer.getIdleConnectionTimeout()));
        pipeline.addLast("handler", (ChannelHandler)this);
    }

    private void closeConnectionsAfterWriteIfNecessary(ProxyToServerConnection serverConnection, HttpRequest currentHttpRequest, HttpResponse currentHttpResponse, HttpObject httpObject) {
        boolean closeServerConnection = this.shouldCloseServerConnection(currentHttpRequest, currentHttpResponse, httpObject);
        boolean closeClientConnection = this.shouldCloseClientConnection(currentHttpRequest, currentHttpResponse, httpObject);
        if (closeServerConnection) {
            this.LOG.debug("Closing remote connection after writing to client", new Object[0]);
            serverConnection.disconnect();
        }
        if (closeClientConnection) {
            this.LOG.debug("Closing connection to client after writes", new Object[0]);
            this.disconnect();
        }
    }

    private void forceDisconnect(ProxyToServerConnection serverConnection) {
        this.LOG.debug("Forcing disconnect", new Object[0]);
        serverConnection.disconnect();
        this.disconnect();
    }

    private boolean shouldCloseClientConnection(HttpRequest req, HttpResponse res, HttpObject httpObject) {
        if (ProxyUtils.isChunked((HttpObject)res) && httpObject != null) {
            if (!ProxyUtils.isLastChunk(httpObject)) {
                String uri = null;
                if (req != null) {
                    uri = req.getUri();
                }
                this.LOG.debug("Not closing client connection on middle chunk for {}", uri);
                return false;
            }
            this.LOG.debug("Handling last chunk. Using normal client connection closing rules.", new Object[0]);
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)req)) {
            this.LOG.debug("Closing client connection since request is not keep alive: {}", req);
            return true;
        }
        this.LOG.debug("Not closing client connection for request: {}", req);
        return false;
    }

    private boolean shouldCloseServerConnection(HttpRequest req, HttpResponse res, HttpObject msg) {
        if (ProxyUtils.isChunked((HttpObject)res) && msg != null) {
            if (!ProxyUtils.isLastChunk(msg)) {
                String uri = null;
                if (req != null) {
                    uri = req.getUri();
                }
                this.LOG.debug("Not closing server connection on middle chunk for {}", uri);
                return false;
            }
            this.LOG.debug("Handling last chunk. Using normal server connection closing rules.", new Object[0]);
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)res)) {
            this.LOG.debug("Closing server connection since response is not keep alive: {}", res);
            return true;
        }
        this.LOG.debug("Not closing server connection for response: {}", res);
        return false;
    }

    private boolean authenticationRequired(HttpRequest request) {
        String password;
        if (this.authenticated.get()) {
            return false;
        }
        ProxyAuthenticator authenticator = this.proxyServer.getProxyAuthenticator();
        if (authenticator == null) {
            return false;
        }
        if (!request.headers().contains("Proxy-Authorization")) {
            this.writeAuthenticationRequired(authenticator.getRealm());
            return true;
        }
        List values = request.headers().getAll("Proxy-Authorization");
        String fullValue = (String)values.iterator().next();
        String value = StringUtils.substringAfter((String)fullValue, (String)"Basic ").trim();
        byte[] decodedValue = Base64.decodeBase64((byte[])value.getBytes(Charset.forName("UTF-8")));
        String decodedString = new String(decodedValue, Charset.forName("UTF-8"));
        String userName = StringUtils.substringBefore((String)decodedString, (String)":");
        if (!authenticator.authenticate(userName, password = StringUtils.substringAfter((String)decodedString, (String)":"))) {
            this.writeAuthenticationRequired(authenticator.getRealm());
            return true;
        }
        this.LOG.debug("Got proxy authorization!", new Object[0]);
        String authentication = request.headers().get("Proxy-Authorization");
        this.LOG.debug(authentication, new Object[0]);
        request.headers().remove("Proxy-Authorization");
        this.authenticated.set(true);
        return false;
    }

    private void writeAuthenticationRequired(String realm) {
        String body = "<!DOCTYPE HTML \"-//IETF//DTD HTML 2.0//EN\">\n<html><head>\n<title>407 Proxy Authentication Required</title>\n</head><body>\n<h1>Proxy Authentication Required</h1>\n<p>This server could not verify that you\nare authorized to access the document\nrequested.  Either you supplied the wrong\ncredentials (e.g., bad password), or your\nbrowser doesn't understand how to supply\nthe credentials required.</p>\n</body></html>\n";
        DefaultFullHttpResponse response = this.responseFor(HttpVersion.HTTP_1_1, HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED, body);
        HttpHeaders.setDate((HttpMessage)response, (Date)new Date());
        response.headers().set("Proxy-Authenticate", (Object)("Basic realm=\"" + (realm == null ? "Restricted Files" : realm) + "\""));
        this.write(response);
    }

    private HttpRequest copy(HttpRequest original) {
        if (original instanceof FullHttpRequest) {
            return ((FullHttpRequest)original).copy();
        }
        DefaultHttpRequest request = new DefaultHttpRequest(original.getProtocolVersion(), original.getMethod(), original.getUri());
        request.headers().set(original.headers());
        return request;
    }

    private void fixHttpVersionHeaderIfNecessary(HttpResponse httpResponse) {
        String te = httpResponse.headers().get("Transfer-Encoding");
        if (StringUtils.isNotBlank((CharSequence)te) && te.equalsIgnoreCase("chunked") && httpResponse.getProtocolVersion() != HttpVersion.HTTP_1_1) {
            this.LOG.debug("Fixing HTTP version.", new Object[0]);
            httpResponse.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
    }

    private void modifyRequestHeadersToReflectProxying(HttpRequest httpRequest) {
        if (!this.currentServerConnection.hasUpstreamChainedProxy()) {
            this.LOG.debug("Modifying request for proxy chaining", new Object[0]);
            String uri = httpRequest.getUri();
            String adjustedUri = ProxyUtils.stripHost(uri);
            this.LOG.debug("Stripped host from uri: {}    yielding: {}", uri, adjustedUri);
            httpRequest.setUri(adjustedUri);
        }
        if (!this.proxyServer.isTransparent()) {
            this.LOG.debug("Modifying request headers for proxying", new Object[0]);
            HttpHeaders headers = httpRequest.headers();
            this.removeSDCHEncoding(headers);
            this.switchProxyConnectionHeader(headers);
            this.stripConnectionTokens(headers);
            this.stripHopByHopHeaders(headers);
            ProxyUtils.addVia((HttpMessage)httpRequest, this.proxyServer.getProxyAlias());
        }
    }

    private void modifyResponseHeadersToReflectProxying(HttpResponse httpResponse) {
        if (!this.proxyServer.isTransparent()) {
            HttpHeaders headers = httpResponse.headers();
            this.stripConnectionTokens(headers);
            this.stripHopByHopHeaders(headers);
            ProxyUtils.addVia((HttpMessage)httpResponse, this.proxyServer.getProxyAlias());
            if (!headers.contains("Date")) {
                HttpHeaders.setDate((HttpMessage)httpResponse, (Date)new Date());
            }
        }
    }

    private void removeSDCHEncoding(HttpHeaders headers) {
        String ae = headers.get("Accept-Encoding");
        if (StringUtils.isNotBlank((CharSequence)ae)) {
            String noSdch = ae.replace(",sdch", "").replace("sdch", "");
            headers.set("Accept-Encoding", (Object)noSdch);
            this.LOG.debug("Removed sdch and inserted: {}", noSdch);
        }
    }

    private void switchProxyConnectionHeader(HttpHeaders headers) {
        String proxyConnectionKey = "Proxy-Connection";
        if (headers.contains(proxyConnectionKey)) {
            String header = headers.get(proxyConnectionKey);
            headers.remove(proxyConnectionKey);
            headers.set("Connection", (Object)header);
        }
    }

    private void stripConnectionTokens(HttpHeaders headers) {
        if (headers.contains("Connection")) {
            for (String headerValue : headers.getAll("Connection")) {
                for (String connectionToken : ProxyUtils.splitCommaSeparatedHeaderValues(headerValue)) {
                    if (LOWERCASE_TRANSFER_ENCODING_HEADER.equals(connectionToken.toLowerCase(Locale.US))) continue;
                    headers.remove(connectionToken);
                }
            }
        }
    }

    private void stripHopByHopHeaders(HttpHeaders headers) {
        Set headerNames = headers.names();
        for (String headerName : headerNames) {
            if (!ProxyUtils.shouldRemoveHopByHopHeader(headerName)) continue;
            headers.remove(headerName);
        }
    }

    private boolean writeBadGateway(HttpRequest httpRequest) {
        String body = "Bad Gateway: " + httpRequest.getUri();
        DefaultFullHttpResponse response = this.responseFor(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_GATEWAY, body);
        if (ProxyUtils.isHEAD(httpRequest)) {
            response.content().clear();
        }
        return this.respondWithShortCircuitResponse((HttpResponse)response);
    }

    private boolean writeBadRequest(HttpRequest httpRequest) {
        String body = "Bad Request to URI: " + httpRequest.getUri();
        DefaultFullHttpResponse response = this.responseFor(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, body);
        if (ProxyUtils.isHEAD(httpRequest)) {
            response.content().clear();
        }
        return this.respondWithShortCircuitResponse((HttpResponse)response);
    }

    private boolean writeGatewayTimeout(HttpRequest httpRequest) {
        String body = "Gateway Timeout";
        DefaultFullHttpResponse response = this.responseFor(HttpVersion.HTTP_1_1, HttpResponseStatus.GATEWAY_TIMEOUT, body);
        if (httpRequest != null && ProxyUtils.isHEAD(httpRequest)) {
            response.content().clear();
        }
        return this.respondWithShortCircuitResponse((HttpResponse)response);
    }

    private boolean respondWithShortCircuitResponse(HttpResponse httpResponse) {
        this.currentRequest = null;
        HttpResponse filteredResponse = (HttpResponse)this.currentFilters.proxyToClientResponse((HttpObject)httpResponse);
        if (filteredResponse == null) {
            this.disconnect();
            return false;
        }
        boolean isKeepAlive = HttpHeaders.isKeepAlive((HttpMessage)httpResponse);
        int statusCode = httpResponse.getStatus().code();
        if (statusCode != HttpResponseStatus.BAD_GATEWAY.code() && statusCode != HttpResponseStatus.GATEWAY_TIMEOUT.code()) {
            this.modifyResponseHeadersToReflectProxying(httpResponse);
        }
        HttpHeaders.setKeepAlive((HttpMessage)httpResponse, (boolean)isKeepAlive);
        this.write(httpResponse);
        if (ProxyUtils.isLastChunk((HttpObject)httpResponse)) {
            this.writeEmptyBuffer();
        }
        if (!HttpHeaders.isKeepAlive((HttpMessage)httpResponse)) {
            this.disconnect();
            return false;
        }
        return true;
    }

    private DefaultFullHttpResponse responseFor(HttpVersion httpVersion, HttpResponseStatus status, String body) {
        byte[] bytes = body.getBytes(Charset.forName("UTF-8"));
        ByteBuf content = Unpooled.copiedBuffer((byte[])bytes);
        return this.responseFor(httpVersion, status, content, bytes.length);
    }

    private DefaultFullHttpResponse responseFor(HttpVersion httpVersion, HttpResponseStatus status, ByteBuf body, int contentLength) {
        DefaultFullHttpResponse response;
        DefaultFullHttpResponse defaultFullHttpResponse = response = body != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, body) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        if (body != null) {
            response.headers().set("Content-Length", (Object)contentLength);
            response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        }
        return response;
    }

    private DefaultFullHttpResponse responseFor(HttpVersion httpVersion, HttpResponseStatus status) {
        return this.responseFor(httpVersion, status, null, 0);
    }

    private String identifyHostAndPort(HttpRequest httpRequest) {
        List hosts;
        String hostAndPort = ProxyUtils.parseHostAndPort(httpRequest);
        if (StringUtils.isBlank((CharSequence)hostAndPort) && (hosts = httpRequest.headers().getAll("Host")) != null && !hosts.isEmpty()) {
            hostAndPort = (String)hosts.get(0);
        }
        return hostAndPort;
    }

    private void writeEmptyBuffer() {
        this.write(Unpooled.EMPTY_BUFFER);
    }

    public boolean isMitming() {
        return this.mitming;
    }

    protected void setMitming(boolean isMitming) {
        this.mitming = isMitming;
    }

    private void recordClientConnected() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientConnected(clientAddress);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientConnected", e);
        }
    }

    private void recordClientSSLHandshakeSucceeded() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientSSLHandshakeSucceeded(clientAddress, this.clientSslSession);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recorClientSSLHandshakeSucceeded", e);
        }
    }

    private void recordClientDisconnected() {
        try {
            InetSocketAddress clientAddress = this.getClientAddress();
            for (ActivityTracker tracker : this.proxyServer.getActivityTrackers()) {
                tracker.clientDisconnected(clientAddress, this.clientSslSession);
            }
        }
        catch (Exception e) {
            this.LOG.error("Unable to recordClientDisconnected", e);
        }
    }

    public InetSocketAddress getClientAddress() {
        if (this.channel == null) {
            return null;
        }
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    private FlowContext flowContext() {
        if (this.currentServerConnection != null) {
            return new FullFlowContext(this, this.currentServerConnection);
        }
        return new FlowContext(this);
    }
}

