/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.CommandExecutionException;
import liquibase.logging.Logger;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

public class NativeToolFileCreator {
    public static final Pattern EXTENSION_PATTERN = Pattern.compile(".*(\\..*)$");
    private final ChangeSet changeSet;
    private final String tempFilenameOverride;
    private final String pathOverride;
    private final boolean overwriteFile;
    private final boolean keepFile;
    private final String integrationDisplayName;
    private final String keepTempOverwriteConfigKey;

    public NativeToolFileCreator(ChangeSet changeSet, String tempFilenameOverride, String pathOverride, boolean overwriteFile, boolean keepFile, String integrationDisplayName, String keepTempOverwriteConfigKey) {
        this.changeSet = changeSet;
        this.tempFilenameOverride = FilenameUtil.sanitizeFileName((String)tempFilenameOverride);
        this.pathOverride = pathOverride;
        this.overwriteFile = overwriteFile;
        this.keepFile = keepFile;
        this.integrationDisplayName = integrationDisplayName;
        this.keepTempOverwriteConfigKey = keepTempOverwriteConfigKey;
    }

    public File generateTemporaryFile(FileTypeEnum fileType) throws Exception {
        return this.generateTemporaryFile(fileType, true);
    }

    public File generateTemporaryFile(FileTypeEnum fileType, boolean allowAppendExtension) throws Exception {
        String extension;
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        String tempFileName = "liquibase-" + fileType.toString() + "-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-";
        if (StringUtil.isNotEmpty((String)this.tempFilenameOverride)) {
            tempFileName = this.tempFilenameOverride;
        }
        tempFileName = FilenameUtil.sanitizeFileName((String)tempFileName);
        log.info("Creating temporary " + (Object)((Object)fileType) + " file for '" + tempFileName + "'");
        String string = extension = allowAppendExtension ? fileType.extension : "";
        if (StringUtil.isEmpty((String)this.pathOverride)) {
            String tempDirectoryPath = System.getProperty("java.io.tmpdir");
            if (StringUtil.isEmpty((String)this.tempFilenameOverride)) {
                return this.deleteFileOnExitIfNeeded(File.createTempFile(tempFileName, fileType.extension), this.keepFile);
            }
            File f = new File(tempDirectoryPath, this.tempFilenameOverride + extension);
            return this.deleteFileOnExitIfNeeded(this.safelyCreateNewFile(f, this.overwriteFile, fileType), this.keepFile);
        }
        File parentDirectory = new File(this.pathOverride);
        boolean wasDirectoryCreated = parentDirectory.mkdirs();
        if (!this.keepFile && wasDirectoryCreated) {
            parentDirectory.deleteOnExit();
        }
        if (StringUtil.isEmpty((String)this.tempFilenameOverride)) {
            SecureRandom secureRandom = new SecureRandom();
            File f = new File(this.pathOverride, tempFileName + secureRandom.nextLong() + fileType.extension);
            return this.deleteFileOnExitIfNeeded(this.safelyCreateNewFile(f, this.overwriteFile, fileType), this.keepFile);
        }
        File f = new File(this.pathOverride, this.tempFilenameOverride + extension);
        return this.deleteFileOnExitIfNeeded(this.safelyCreateNewFile(f, this.overwriteFile, fileType), this.keepFile);
    }

    private File safelyCreateNewFile(File f, Boolean shouldOverwriteFile, FileTypeEnum fileType) throws CommandExecutionException, IOException {
        if (!f.exists()) {
            return this.createNewFile(f);
        }
        if (f.exists() && shouldOverwriteFile == null) {
            throw new CommandExecutionException("ERROR: Specified " + this.integrationDisplayName + " " + fileType.name() + " file " + f.getAbsolutePath() + " already exists, and " + this.keepTempOverwriteConfigKey + "=NULL. It is unclear whether the file should be overwritten. To run this job, either adjust file name or path, or set " + this.keepTempOverwriteConfigKey + "=TRUE.");
        }
        if (f.exists() && !shouldOverwriteFile.booleanValue()) {
            throw new CommandExecutionException("ERROR: Specified " + this.integrationDisplayName + " " + fileType.name() + " file " + f.getAbsolutePath() + " already exists, and " + this.keepTempOverwriteConfigKey + "=FALSE. To run this job, either adjust file name or path, or set " + this.keepTempOverwriteConfigKey + "=TRUE.");
        }
        Scope.getCurrentScope().getUI().sendMessage("WARNING: Specified " + this.integrationDisplayName + " " + fileType.name() + " file " + f.getAbsolutePath() + " already existed, and was overwritten.");
        boolean deletedSuccessfully = f.delete();
        if (deletedSuccessfully) {
            return this.createNewFile(f);
        }
        throw new CommandExecutionException("Failed to create file " + f.getAbsolutePath() + " after deleting existing file.");
    }

    private File createNewFile(File f) throws IOException, CommandExecutionException {
        boolean created = f.createNewFile();
        if (created) {
            return f;
        }
        throw new CommandExecutionException("Failed to create file " + f.getAbsolutePath() + ".");
    }

    private File deleteFileOnExitIfNeeded(File f, Boolean keepFile) {
        if (!keepFile.booleanValue()) {
            f.deleteOnExit();
        }
        return f;
    }

    public static enum FileTypeEnum {
        spool(".spool"),
        sql(".sql"),
        log(".log");

        public final String extension;

        private FileTypeEnum(String extension) {
            this.extension = extension;
        }
    }
}

