/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Table;

public class MissingCheckConstraintChangeGenerator
extends LicenseCheckingChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CheckConstraint.class.isAssignableFrom(objectType)) {
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[]{Table.class, Column.class};
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        CheckConstraint constraint = (CheckConstraint)missingObject;
        if (constraint.getTable() == null) {
            return null;
        }
        AddCheckConstraintChange change = new AddCheckConstraintChange();
        change.setTableName(constraint.getTable().getName());
        if (control.getIncludeCatalog()) {
            change.setCatalogName(constraint.getTable().getSchema().getCatalogName());
        }
        if (control.getIncludeSchema()) {
            change.setSchemaName(constraint.getTable().getSchema().getName());
        }
        change.setConstraintName(constraint.getName());
        change.setConstraintBody(constraint.getBody());
        change.setDisabled(constraint.isDisabled());
        if (!constraint.isValidate()) {
            change.setValidate(constraint.isValidate());
        }
        return new Change[]{change};
    }
}

