/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint;

import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.diff.compare.DatabaseObjectComparatorFactory;
import liquibase.diff.compare.core.DefaultDatabaseObjectComparator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class CheckConstraintComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CheckConstraint.class.isAssignableFrom(objectType)) {
            return 5;
        }
        return -1;
    }

    public String[] hash(DatabaseObject databaseObject, Database accordingTo, DatabaseObjectComparatorChain chain) {
        Table table;
        ArrayList<String> hashes = new ArrayList<String>();
        if (databaseObject.getName() != null) {
            hashes.add(databaseObject.getName().toLowerCase());
        }
        if ((table = ((CheckConstraint)databaseObject).getTable()) != null) {
            hashes.addAll(Arrays.asList(DatabaseObjectComparatorFactory.getInstance().hash((DatabaseObject)table, chain.getSchemaComparisons(), accordingTo)));
        }
        return hashes.toArray(new String[hashes.size()]);
    }

    public boolean isSameObject(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, DatabaseObjectComparatorChain chain) {
        if (!(databaseObject1 instanceof CheckConstraint) || !(databaseObject2 instanceof CheckConstraint)) {
            return false;
        }
        CheckConstraint thisCheckConstraint = (CheckConstraint)databaseObject1;
        CheckConstraint otherCheckConstraint = (CheckConstraint)databaseObject2;
        if (!DatabaseObjectComparatorFactory.getInstance().isSameObject((DatabaseObject)databaseObject1.getSchema(), (DatabaseObject)databaseObject2.getSchema(), chain.getSchemaComparisons(), accordingTo)) {
            return false;
        }
        if (thisCheckConstraint.getTable() != null && otherCheckConstraint.getTable() != null && !DefaultDatabaseObjectComparator.nameMatches((DatabaseObject)thisCheckConstraint.getTable(), (DatabaseObject)otherCheckConstraint.getTable(), (Database)accordingTo)) {
            return false;
        }
        if (databaseObject1.getName() != null && databaseObject2.getName() != null && !this.isGeneratedName(databaseObject1.getName(), accordingTo) && !this.isGeneratedName(databaseObject2.getName(), accordingTo)) {
            return databaseObject1.getName().equalsIgnoreCase(databaseObject2.getName());
        }
        return thisCheckConstraint.getBody().equals(otherCheckConstraint.getBody());
    }

    protected boolean isGeneratedName(String name, Database database) {
        if (name == null) {
            return false;
        }
        return database instanceof OracleDatabase && name.startsWith("SYS_C");
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject1, DatabaseObject databaseObject2, Database accordingTo, CompareControl compareControl, DatabaseObjectComparatorChain chain, Set<String> exclude) {
        exclude.add("name");
        return chain.findDifferences(databaseObject1, databaseObject2, accordingTo, compareControl, exclude);
    }
}

