/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.ChecksRunJsonOutputHelper;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractChainedChecksRule;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;

public class TriggeredCheck {
    private UUID id;
    private String checkName;
    private String checkSettingsFile;
    private Boolean info = false;
    private Boolean minor = false;
    private Boolean major = false;
    private Boolean critical = false;
    private Boolean blocker = false;
    private Boolean validChain = true;
    private String description;
    private String chainedCheckResults;
    private String expandedChainedCheck;
    private boolean checkTriggeredFromRollback;
    private List<DynamicRuleParameter> parameters = new ArrayList<DynamicRuleParameter>();
    private String message;

    public static Set<TriggeredCheck> buildTriggeredChecks(List<LiquibaseRuleResult> liquibaseRuleResults, List<Rule> executedRules, Integer sqlParserSeverity, String checkSettingsFile, List<String> checksInChain, CheckSettingsConfig checkSettingsConfig) {
        return liquibaseRuleResults.stream().filter(liquibaseRuleResult -> !liquibaseRuleResult.hasRuleSucceeded() && executedRules.contains(liquibaseRuleResult.getRule()) && !liquibaseRuleResult.hasInvalidChangelogFileTypeFailures() && !checksInChain.contains(liquibaseRuleResult.getRuleShortName(false))).flatMap(liquibaseRuleResult -> liquibaseRuleResult.getExecutions().stream().filter(execution -> !execution.isSuccess()).map(execution -> {
            TriggeredCheck triggeredCheck = new TriggeredCheck();
            triggeredCheck.setCheckName(liquibaseRuleResult.getRuleShortName(false));
            triggeredCheck.setDescription(liquibaseRuleResult.getRule().getDescription());
            triggeredCheck.setMessage(liquibaseRuleResult.getExecutions().stream().map(RuleIteration::getMessages).flatMap(Collection::stream).collect(Collectors.joining("\n")));
            triggeredCheck.setCheckSettingsFile(checkSettingsFile);
            triggeredCheck.setCheckTriggeredFromRollback(execution.isRollback());
            SeverityEnum severity = liquibaseRuleResult.getRuleSeverity(sqlParserSeverity);
            switch (severity) {
                case INFO: {
                    triggeredCheck.setInfo(true);
                    break;
                }
                case MINOR: {
                    triggeredCheck.setMinor(true);
                    break;
                }
                case MAJOR: {
                    triggeredCheck.setMajor(true);
                    break;
                }
                case CRITICAL: {
                    triggeredCheck.setCritical(true);
                    break;
                }
                case BLOCKER: {
                    triggeredCheck.setBlocker(true);
                }
            }
            AbstractConfigurableRule rule = liquibaseRuleResult.getConfigurableRule();
            if (rule instanceof DynamicRule) {
                String unexpandedChainedCheckLogical;
                DynamicRule dynamicRule = (DynamicRule)rule;
                if (dynamicRule.getParameters() != null) {
                    triggeredCheck.getParameters().addAll(dynamicRule.getParameters());
                }
                if ((unexpandedChainedCheckLogical = ChecksRunJsonOutputHelper.getLogicConditional(liquibaseRuleResult)) != null && !unexpandedChainedCheckLogical.isEmpty()) {
                    boolean validChain = liquibaseRuleResult.getExecutions().stream().allMatch(RuleIteration::isValidChain);
                    triggeredCheck.setValidChain(validChain);
                    String expandedLogical = AbstractChainedChecksRule.expandChainedChecks(unexpandedChainedCheckLogical, dynamicRule, checkSettingsConfig);
                    triggeredCheck.setExpandedChainedCheck(expandedLogical);
                    String logicalResults = TriggeredCheck.getExpandedLogicalResults(expandedLogical, execution, validChain);
                    triggeredCheck.setChainedCheckResults(logicalResults);
                }
            }
            return triggeredCheck;
        })).sorted(Comparator.comparing(TriggeredCheck::getCheckName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static String getExpandedLogicalResults(String expandedLogical, RuleIteration execution, boolean validChain) {
        String expanded = expandedLogical;
        Map<String, String> chainedChecks = execution.getCheckRuleResults();
        if (!validChain) {
            return String.join((CharSequence)"\n", chainedChecks.values());
        }
        for (Map.Entry<String, String> chainedCheck : chainedChecks.entrySet()) {
            String checkName = chainedCheck.getKey();
            String result = chainedCheck.getValue();
            if (!expanded.contains(checkName)) continue;
            expanded = expanded.replace(checkName, String.format("%s::%s", checkName, result));
        }
        return expanded;
    }

    @Generated
    public TriggeredCheck() {
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getCheckName() {
        return this.checkName;
    }

    @Generated
    public String getCheckSettingsFile() {
        return this.checkSettingsFile;
    }

    @Generated
    public Boolean getInfo() {
        return this.info;
    }

    @Generated
    public Boolean getMinor() {
        return this.minor;
    }

    @Generated
    public Boolean getMajor() {
        return this.major;
    }

    @Generated
    public Boolean getCritical() {
        return this.critical;
    }

    @Generated
    public Boolean getBlocker() {
        return this.blocker;
    }

    @Generated
    public Boolean getValidChain() {
        return this.validChain;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getChainedCheckResults() {
        return this.chainedCheckResults;
    }

    @Generated
    public String getExpandedChainedCheck() {
        return this.expandedChainedCheck;
    }

    @Generated
    public boolean isCheckTriggeredFromRollback() {
        return this.checkTriggeredFromRollback;
    }

    @Generated
    public List<DynamicRuleParameter> getParameters() {
        return this.parameters;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    @Generated
    public void setCheckSettingsFile(String checkSettingsFile) {
        this.checkSettingsFile = checkSettingsFile;
    }

    @Generated
    public void setInfo(Boolean info) {
        this.info = info;
    }

    @Generated
    public void setMinor(Boolean minor) {
        this.minor = minor;
    }

    @Generated
    public void setMajor(Boolean major) {
        this.major = major;
    }

    @Generated
    public void setCritical(Boolean critical) {
        this.critical = critical;
    }

    @Generated
    public void setBlocker(Boolean blocker) {
        this.blocker = blocker;
    }

    @Generated
    public void setValidChain(Boolean validChain) {
        this.validChain = validChain;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setChainedCheckResults(String chainedCheckResults) {
        this.chainedCheckResults = chainedCheckResults;
    }

    @Generated
    public void setExpandedChainedCheck(String expandedChainedCheck) {
        this.expandedChainedCheck = expandedChainedCheck;
    }

    @Generated
    public void setCheckTriggeredFromRollback(boolean checkTriggeredFromRollback) {
        this.checkTriggeredFromRollback = checkTriggeredFromRollback;
    }

    @Generated
    public void setParameters(List<DynamicRuleParameter> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TriggeredCheck)) {
            return false;
        }
        TriggeredCheck other = (TriggeredCheck)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckTriggeredFromRollback() != other.isCheckTriggeredFromRollback()) {
            return false;
        }
        Boolean this$info = this.getInfo();
        Boolean other$info = other.getInfo();
        if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
            return false;
        }
        Boolean this$minor = this.getMinor();
        Boolean other$minor = other.getMinor();
        if (this$minor == null ? other$minor != null : !((Object)this$minor).equals(other$minor)) {
            return false;
        }
        Boolean this$major = this.getMajor();
        Boolean other$major = other.getMajor();
        if (this$major == null ? other$major != null : !((Object)this$major).equals(other$major)) {
            return false;
        }
        Boolean this$critical = this.getCritical();
        Boolean other$critical = other.getCritical();
        if (this$critical == null ? other$critical != null : !((Object)this$critical).equals(other$critical)) {
            return false;
        }
        Boolean this$blocker = this.getBlocker();
        Boolean other$blocker = other.getBlocker();
        if (this$blocker == null ? other$blocker != null : !((Object)this$blocker).equals(other$blocker)) {
            return false;
        }
        Boolean this$validChain = this.getValidChain();
        Boolean other$validChain = other.getValidChain();
        if (this$validChain == null ? other$validChain != null : !((Object)this$validChain).equals(other$validChain)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$checkName = this.getCheckName();
        String other$checkName = other.getCheckName();
        if (this$checkName == null ? other$checkName != null : !this$checkName.equals(other$checkName)) {
            return false;
        }
        String this$checkSettingsFile = this.getCheckSettingsFile();
        String other$checkSettingsFile = other.getCheckSettingsFile();
        if (this$checkSettingsFile == null ? other$checkSettingsFile != null : !this$checkSettingsFile.equals(other$checkSettingsFile)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$chainedCheckResults = this.getChainedCheckResults();
        String other$chainedCheckResults = other.getChainedCheckResults();
        if (this$chainedCheckResults == null ? other$chainedCheckResults != null : !this$chainedCheckResults.equals(other$chainedCheckResults)) {
            return false;
        }
        String this$expandedChainedCheck = this.getExpandedChainedCheck();
        String other$expandedChainedCheck = other.getExpandedChainedCheck();
        if (this$expandedChainedCheck == null ? other$expandedChainedCheck != null : !this$expandedChainedCheck.equals(other$expandedChainedCheck)) {
            return false;
        }
        List<DynamicRuleParameter> this$parameters = this.getParameters();
        List<DynamicRuleParameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TriggeredCheck;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckTriggeredFromRollback() ? 79 : 97);
        Boolean $info = this.getInfo();
        result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
        Boolean $minor = this.getMinor();
        result = result * 59 + ($minor == null ? 43 : ((Object)$minor).hashCode());
        Boolean $major = this.getMajor();
        result = result * 59 + ($major == null ? 43 : ((Object)$major).hashCode());
        Boolean $critical = this.getCritical();
        result = result * 59 + ($critical == null ? 43 : ((Object)$critical).hashCode());
        Boolean $blocker = this.getBlocker();
        result = result * 59 + ($blocker == null ? 43 : ((Object)$blocker).hashCode());
        Boolean $validChain = this.getValidChain();
        result = result * 59 + ($validChain == null ? 43 : ((Object)$validChain).hashCode());
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $checkName = this.getCheckName();
        result = result * 59 + ($checkName == null ? 43 : $checkName.hashCode());
        String $checkSettingsFile = this.getCheckSettingsFile();
        result = result * 59 + ($checkSettingsFile == null ? 43 : $checkSettingsFile.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $chainedCheckResults = this.getChainedCheckResults();
        result = result * 59 + ($chainedCheckResults == null ? 43 : $chainedCheckResults.hashCode());
        String $expandedChainedCheck = this.getExpandedChainedCheck();
        result = result * 59 + ($expandedChainedCheck == null ? 43 : $expandedChainedCheck.hashCode());
        List<DynamicRuleParameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TriggeredCheck(id=" + this.getId() + ", checkName=" + this.getCheckName() + ", checkSettingsFile=" + this.getCheckSettingsFile() + ", info=" + this.getInfo() + ", minor=" + this.getMinor() + ", major=" + this.getMajor() + ", critical=" + this.getCritical() + ", blocker=" + this.getBlocker() + ", validChain=" + this.getValidChain() + ", description=" + this.getDescription() + ", chainedCheckResults=" + this.getChainedCheckResults() + ", expandedChainedCheck=" + this.getExpandedChainedCheck() + ", checkTriggeredFromRollback=" + this.isCheckTriggeredFromRollback() + ", parameters=" + this.getParameters() + ", message=" + this.getMessage() + ")";
    }
}

