/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.license;

import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.pro.LicenseTier;

public abstract class LicenseValidationChange
extends AbstractChange {
    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        return super.validate(database);
    }

    public static ValidationErrors checkForValidLicense(LicenseTier licenseType, Change change) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        if (licenseService == null) {
            return new ValidationErrors();
        }
        if (licenseService.licenseIsValid(licenseType.getSubject())) {
            String message = String.format("Found valid license with subject '%s' for '%s'", licenseType.getSubject(), change.getDescription());
            Scope.getCurrentScope().getLog(LicenseService.class).fine(message);
            return new ValidationErrors();
        }
        ChangeSet changeSet = change.getChangeSet();
        String changeType = ((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(change).getName();
        ValidationErrors validationErrors = new ValidationErrors();
        String message = "Changeset ID: " + changeSet.getId() + " Changeset Author: " + changeSet.getAuthor() + "\n";
        message = message + "Change Type 'pro:" + changeType + "' is not allowed without a valid Liquibase Pro License.\n";
        message = message + "To purchase or renew a Liquibase Pro license key, please contact sales@liquibase.com or\ngo to https://www.liquibase.com/pricing";
        validationErrors.addError(message);
        return validationErrors;
    }
}

