/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.init;

import com.datical.liquibase.ext.checks.config.ChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.cli.FilenameGetter;
import com.datical.liquibase.ext.command.init.InitProjectCommandStep;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class InitProjectUtil {
    public static final String SQL = "sql";
    public static final String JSON = "json";
    public static final String YML = "yml";
    public static final String YAML = "yaml";
    public static final String XML = "xml";
    public static final String MODIFIED_DEFAULTS_FILE_CONTENTS = "modifiedDefaultsFileContents";

    public static void createProjectDirectory(File projectDirFile) throws CommandExecutionException {
        boolean b;
        if (!(projectDirFile.exists() || (b = projectDirFile.mkdirs()) || projectDirFile.exists())) {
            String message = "Unable to create specified project directory '" + projectDirFile.getAbsolutePath() + "'.\nPlease check permission and try 'liquibase init project' again";
            throw new CommandExecutionException(message);
        }
    }

    public static void validateChangelogFilePath(String changelogFilePath) {
        new FilenameGetter().validate(changelogFilePath);
    }

    public static void validateProjectDirectory(File projectDirFile) throws CommandExecutionException {
        if (projectDirFile.exists() && projectDirFile.isFile()) {
            String message = System.lineSeparator() + System.lineSeparator() + "The specified project directory '" + projectDirFile.getAbsolutePath() + "' cannot be a file" + System.lineSeparator() + System.lineSeparator();
            throw new CommandExecutionException(message);
        }
    }

    public static void updateDefaultsFile(File defaultsFile, boolean newDefaultsFile, String format, ConfiguredValue<String> changelogConfig, ConfiguredValue<String> urlConfig, ConfiguredValue<String> usernameConfig, ConfiguredValue<String> passwordConfig, FileCreationResultEnum changelogFileCreationResult, Boolean shouldBackupDefaultsFile, CommandResultsBuilder resultsBuilder) throws IOException {
        String contents = FileUtil.getContents((File)defaultsFile);
        if (contents == null) {
            return;
        }
        String newContents = contents;
        if (changelogFileCreationResult == FileCreationResultEnum.already_existed || changelogFileCreationResult == FileCreationResultEnum.created) {
            if (!changelogConfig.wasDefaultValueUsed()) {
                String changelogPath = (String)changelogConfig.getValue();
                if (!changelogPath.contains("." + format)) {
                    changelogPath = changelogPath + "." + format;
                }
                newContents = InitProjectUtil.replaceProperty("changeLogFile", changelogPath, newContents, newDefaultsFile);
            } else if (format.equalsIgnoreCase(YML)) {
                newContents = InitProjectUtil.replaceProperty("changeLogFile", "example-changelog.yml", newContents, newDefaultsFile);
            }
        } else {
            newContents = InitProjectUtil.replaceProperty("changeLogFile", "", newContents, true, true, false, newDefaultsFile, true);
        }
        if (!urlConfig.wasDefaultValueUsed()) {
            newContents = InitProjectUtil.replaceProperty("url", urlConfig, newContents, newDefaultsFile);
        }
        if (!usernameConfig.wasDefaultValueUsed()) {
            newContents = InitProjectUtil.replaceProperty("username", usernameConfig, newContents, newDefaultsFile);
        }
        if (!passwordConfig.wasDefaultValueUsed()) {
            newContents = InitProjectUtil.replaceProperty("password", passwordConfig, newContents, newDefaultsFile);
        }
        if (newDefaultsFile || contents.equals(newContents)) {
            FileUtil.write((String)newContents, (File)defaultsFile, (boolean)false);
            return;
        }
        if (Boolean.FALSE.equals(shouldBackupDefaultsFile)) {
            resultsBuilder.addResult(MODIFIED_DEFAULTS_FILE_CONTENTS, (Object)newContents);
        } else {
            File backupFile = InitProjectUtil.calcBackupFile(defaultsFile);
            Resource resource = ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(defaultsFile.getAbsolutePath());
            Resource backupResource = ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(backupFile.getAbsolutePath());
            ChecksFileAccessor.makeBackup(resource, backupResource, contents, null, false);
            FileUtil.write((String)newContents, (File)defaultsFile, (boolean)false);
            InitProjectUtil.outputBackedUpDefaultsFileMessage(defaultsFile.getAbsolutePath());
        }
    }

    public static void outputBackedUpDefaultsFileMessage(String absolutePath) {
        String message = String.format("%sThe defaults file '%s' was backed up and then updated with your supplied values.%s", System.lineSeparator(), InitProjectUtil.removeDotsFromPath(absolutePath), System.lineSeparator());
        Scope.getCurrentScope().getUI().sendMessage(message);
        Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
    }

    public static String replaceProperty(String key, ConfiguredValue<String> config, String contents, boolean newDefaultsFile) {
        return InitProjectUtil.replaceProperty(key, (String)config.getValue(), contents, newDefaultsFile);
    }

    public static String replaceProperty(String key, String configValue, String contents, boolean newDefaultsFile) {
        return InitProjectUtil.replaceProperty(key, configValue, contents, false, true, true, newDefaultsFile, false);
    }

    public static String replaceProperty(String key, String configValue, String contents, boolean commented, boolean includeKeyPrefix, boolean addPropertyIfMissing, boolean newDefaultsFile, boolean useExistingValueIfExists) {
        String newContents = contents;
        String regex = "^[\\s]*liquibase\\.command\\." + key + "[\\s]*[=:][\\s]*(.*?)$";
        String keyWithPrefix = (includeKeyPrefix ? "liquibase.command." : "") + key;
        Pattern p = Pattern.compile(regex, 42);
        Matcher m = p.matcher(contents.toLowerCase());
        if (m.find()) {
            String obfuscatedValue = InitProjectUtil.obfuscateValue(configValue, key);
            String existingValue = m.group(1).trim();
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Replacing value for 'liquibase.command." + key + "' with '" + obfuscatedValue + "'");
            if (useExistingValueIfExists && !newDefaultsFile && StringUtil.isNotEmpty((String)existingValue)) {
                return newContents;
            }
            newContents = newContents.replaceAll("liquibase\\.command\\.(?i)" + key + "[\\s]*([=:])[\\s]*(.*)", (InitProjectUtil.shouldCommentProperty(commented, newDefaultsFile, StringUtil.isEmpty((String)existingValue)) ? "#" : "") + keyWithPrefix + "$1" + (configValue == null ? configValue : Matcher.quoteReplacement(configValue)));
            newContents = newContents.replace(keyWithPrefix + ":" + configValue, "liquibase.command." + key + ": " + configValue);
        } else {
            regex = "^[\\s]*(?i)" + key + "[\\s]*[=:][\\s]*(.*?)$";
            p = Pattern.compile(regex, 42);
            m = p.matcher(contents.toLowerCase());
            if (m.find()) {
                String obfuscatedValue = InitProjectUtil.obfuscateValue(configValue, key);
                String existingValue = m.group(1).trim();
                if (useExistingValueIfExists && !newDefaultsFile && StringUtil.isNotEmpty((String)existingValue)) {
                    return newContents;
                }
                newContents = newContents.replaceAll("(?i)" + key + "[\\s]*([=:])[\\s]*(.*)", (InitProjectUtil.shouldCommentProperty(commented, newDefaultsFile, StringUtil.isEmpty((String)existingValue)) ? "#" : "") + key + "$1" + (configValue == null ? configValue : Matcher.quoteReplacement(configValue)));
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Replacing value for '" + key + "' with '" + obfuscatedValue + "'");
                newContents = newContents.replace(key + ":" + configValue, key + ": " + configValue);
            } else if (addPropertyIfMissing) {
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Adding property 'liquibase.command." + key + "' with value '" + configValue + "'");
                newContents = newContents + "\n" + keyWithPrefix + "=" + configValue;
            }
        }
        return newContents;
    }

    private static String obfuscateValue(String configValue, String key) {
        String obfuscatedValue = configValue;
        if (key.toLowerCase().contains("username") || key.toLowerCase().contains("password")) {
            obfuscatedValue = "*****";
        }
        if (obfuscatedValue != null) {
            obfuscatedValue = obfuscatedValue.trim();
        }
        return obfuscatedValue;
    }

    private static boolean shouldCommentProperty(boolean commented, boolean newDefaultsFile, boolean isChangelogPropertyValueEmpty) {
        return commented && (newDefaultsFile || isChangelogPropertyValueEmpty);
    }

    public static File copyExampleProperties(String format, String projectDirFile, String targetDefaultsFilename) throws CommandExecutionException {
        try {
            String contents;
            String examplePropertiesPath;
            if (format == null || format.equalsIgnoreCase(SQL)) {
                examplePropertiesPath = "liquibase/examples/sql/liquibase.properties";
            } else if (format.equalsIgnoreCase(XML)) {
                examplePropertiesPath = "liquibase/examples/xml/liquibase.properties";
            } else if (format.equalsIgnoreCase(JSON)) {
                examplePropertiesPath = "liquibase/examples/json/liquibase.properties";
            } else if (format.equalsIgnoreCase(YAML) || format.equalsIgnoreCase(YML)) {
                examplePropertiesPath = "liquibase/examples/yaml/liquibase.properties";
            } else {
                throw new CommandExecutionException("Unknown format '" + format + "'");
            }
            try (InputStream resourceAsStream = InitProjectUtil.class.getClassLoader().getResourceAsStream(examplePropertiesPath);){
                contents = StreamUtil.readStreamAsString((InputStream)resourceAsStream);
            }
            if (StringUtil.isEmpty((String)contents)) {
                throw new CommandExecutionException("Unable to read the example changelog file resource.");
            }
            File targetFile = new File(projectDirFile, targetDefaultsFilename);
            FileUtil.write((String)contents, (File)targetFile, (boolean)false);
            String displayPath = InitProjectUtil.removeDotsFromPath(targetFile.getAbsolutePath());
            String message = "Created example defaults file '" + displayPath + "'";
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
            Scope.getCurrentScope().getUI().sendMessage(message);
            return targetFile;
        }
        catch (IOException ioe) {
            throw new CommandExecutionException("Unable to create the example properties file", (Throwable)ioe);
        }
    }

    public static FileCreationResultEnum copyExampleChangelog(String format, File projectDirFile, String changelogFilePath, ConfiguredValue<String> changelogFileConfig) throws CommandExecutionException {
        try {
            String contents;
            String exampleChangelogPath;
            File[] listOfChangelogs = InitProjectUtil.findChangeLogsInProjectDir(projectDirFile);
            if (changelogFilePath != null && listOfChangelogs != null && listOfChangelogs.length > 0) {
                File changelogFile = new File(projectDirFile, changelogFilePath);
                boolean foundMatch = Arrays.stream(listOfChangelogs).anyMatch(f -> f.getAbsolutePath().equalsIgnoreCase(changelogFile.getAbsolutePath()));
                if (foundMatch) {
                    return FileCreationResultEnum.already_existed;
                }
            }
            if (format.equalsIgnoreCase(SQL)) {
                exampleChangelogPath = "liquibase/examples/sql/example-changelog.sql";
            } else if (format.equalsIgnoreCase(XML)) {
                exampleChangelogPath = "liquibase/examples/xml/example-changelog.xml";
            } else if (format.equalsIgnoreCase(JSON)) {
                exampleChangelogPath = "liquibase/examples/json/example-changelog.json";
            } else if (format.equalsIgnoreCase(YAML) || format.equalsIgnoreCase(YML)) {
                exampleChangelogPath = "liquibase/examples/yaml/example-changelog.yaml";
            } else {
                throw new CommandExecutionException("Unknown format '" + format + "'");
            }
            try (InputStream resourceAsStream = InitProjectUtil.class.getClassLoader().getResourceAsStream(exampleChangelogPath);){
                contents = StreamUtil.readStreamAsString((InputStream)resourceAsStream);
            }
            if (StringUtil.isEmpty((String)contents)) {
                throw new CommandExecutionException("Unable to read the example changelog file resource.");
            }
            File targetFile = changelogFilePath != null && !changelogFileConfig.wasDefaultValueUsed() ? (changelogFilePath.contains("." + format) ? new File(projectDirFile, changelogFilePath) : new File(projectDirFile, changelogFilePath + "." + format)) : new File(projectDirFile, "example-changelog." + format);
            FileUtil.write((String)contents, (File)targetFile, (boolean)false);
            String displayPath = InitProjectUtil.removeDotsFromPath(targetFile.getAbsolutePath());
            String message = System.lineSeparator() + "Created example changelog file '" + displayPath + "'";
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
        catch (IOException ioe) {
            throw new CommandExecutionException("Unable to create the example changelog", (Throwable)ioe);
        }
        return FileCreationResultEnum.created;
    }

    public static void copyExampleFlowFiles(String format, File projectDirFile) throws CommandExecutionException {
        try {
            String exampleFormat = format == null ? SQL : format;
            Map<String, String> exampleFlowFilePaths = InitProjectUtil.buildFlowFilePaths(exampleFormat);
            for (Map.Entry<String, String> entry : exampleFlowFilePaths.entrySet()) {
                String contents;
                String fileName = entry.getKey();
                String pathToExample = entry.getValue();
                if (Files.exists(Paths.get(projectDirFile.getPath() + "/" + fileName, new String[0]), new LinkOption[0])) {
                    String message = "Flow file '" + fileName + "' already exists! Skipping example generation.";
                    Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
                    continue;
                }
                try (InputStream resourceAsStream = InitProjectUtil.class.getClassLoader().getResourceAsStream(pathToExample);){
                    contents = StreamUtil.readStreamAsString((InputStream)resourceAsStream);
                }
                if (StringUtil.isEmpty((String)contents)) {
                    throw new CommandExecutionException("Unable to read the example flow file resource.");
                }
                File targetFile = new File(projectDirFile, fileName);
                FileUtil.write((String)contents, (File)targetFile, (boolean)false);
                String displayPath = InitProjectUtil.removeDotsFromPath(targetFile.getAbsolutePath());
                String message = "Created example flow file '" + displayPath + "'";
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
                Scope.getCurrentScope().getUI().sendMessage(message);
            }
        }
        catch (IOException ioe) {
            throw new CommandExecutionException("Unable to create the example flow files", (Throwable)ioe);
        }
    }

    public static void copyChecksPackageFile(String format, File projectDirFile) throws CommandExecutionException {
        try {
            String contents;
            format = format == null ? SQL : format;
            String fileName = "liquibase.checks-package.yaml";
            if (Files.exists(Paths.get(projectDirFile.getPath() + "/" + fileName, new String[0]), new LinkOption[0])) {
                String message = "File '" + fileName + "' already exists! Skipping example generation.";
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
                return;
            }
            try (InputStream resourceAsStream = InitProjectUtil.class.getClassLoader().getResourceAsStream(InitProjectUtil.buildChecksPackagePath(format));){
                contents = StreamUtil.readStreamAsString((InputStream)resourceAsStream);
            }
            if (StringUtil.isEmpty((String)contents)) {
                throw new CommandExecutionException("Unable to read the example checks package resource.");
            }
            File targetFile = new File(projectDirFile, fileName);
            FileUtil.write((String)contents, (File)targetFile, (boolean)false);
            String displayPath = InitProjectUtil.removeDotsFromPath(targetFile.getAbsolutePath());
            String message = "Created example checks package '" + displayPath + "'";
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info(message);
            Scope.getCurrentScope().getUI().sendMessage(message);
        }
        catch (IOException ioe) {
            throw new CommandExecutionException("Unable to create the example checks package", (Throwable)ioe);
        }
    }

    private static Map<String, String> buildFlowFilePaths(String format) throws CommandExecutionException {
        List<String> flowFiles = Arrays.asList("liquibase.flowfile.yaml", "liquibase.advanced.flowfile.yaml", "liquibase.endstage.flow", "liquibase.flowvariables.yaml");
        String filePathPlaceholder = "liquibase/examples/%s/%s";
        if (Arrays.asList(SQL, JSON, YAML, YML, XML).contains(format.toLowerCase())) {
            String actualFormat = format.equalsIgnoreCase(YML) ? YAML : format;
            return flowFiles.stream().collect(Collectors.toMap(fileName -> fileName, fileName -> String.format(filePathPlaceholder, actualFormat, fileName)));
        }
        throw new CommandExecutionException("Unknown format '" + format + "'");
    }

    private static String buildChecksPackagePath(String format) throws CommandExecutionException {
        String checksPackageFilename = "liquibase.checks-package.yaml";
        String filePathPlaceholder = "liquibase/examples/%s/%s";
        if (Arrays.asList(SQL, JSON, YAML, YML, XML).contains(format.toLowerCase())) {
            String actualFormat = format.equalsIgnoreCase(YML) ? YAML : format;
            return String.format(filePathPlaceholder, actualFormat, checksPackageFilename);
        }
        throw new CommandExecutionException("Unknown format '" + format + "'");
    }

    public static boolean wasH2Used(ConfiguredValue<String> urlConfig, ConfiguredValue<String> usernameConfig, ConfiguredValue<String> passwordConfig) {
        return urlConfig.wasDefaultValueUsed() && usernameConfig.wasDefaultValueUsed() && passwordConfig.wasDefaultValueUsed() || ((String)urlConfig.getValue()).equals(InitProjectCommandStep.URL_ARG.getDefaultValue()) && ((String)usernameConfig.getValue()).equals(InitProjectCommandStep.USERNAME_ARG.getDefaultValue()) && ((String)passwordConfig.getValue()).equals(InitProjectCommandStep.PASSWORD_ARG.getDefaultValue());
    }

    public static String removeDotsFromPath(String path) {
        return path.replaceAll("(?<!\\.)\\./", "").replaceAll("(?<!\\.)\\.\\\\", "");
    }

    public static String determineFormatType(String changelogFilePath, String defaultFormat) {
        String extension = InitProjectUtil.getExtension(changelogFilePath);
        if (extension == null) {
            if (defaultFormat != null) {
                return defaultFormat;
            }
            return null;
        }
        switch (extension) {
            case "sql": 
            case "json": 
            case "yml": 
            case "yaml": 
            case "xml": {
                return extension;
            }
        }
        return null;
    }

    public static String getExtension(String changelogFilePath) {
        if (changelogFilePath.isEmpty()) {
            return null;
        }
        String[] parts = changelogFilePath.split("\\.");
        if (parts.length == 1) {
            return null;
        }
        return parts[parts.length - 1].toLowerCase();
    }

    public static File[] findChangeLogsInProjectDir(File projectDirFile) {
        FileFilter fileFilter = file -> !file.isDirectory() && file.getName().toLowerCase().contains("changelog") && InitProjectUtil.hasRecognizedExtension(file);
        return projectDirFile.listFiles(fileFilter);
    }

    public static boolean hasRecognizedExtension(File file) {
        return InitProjectUtil.determineFormatType(file.getName(), null) != null;
    }

    public static File calcBackupFile(File defaultsFile) {
        int version = 1;
        File backupFile = new File(defaultsFile.getParentFile(), defaultsFile.getName() + ".backup." + InitProjectUtil.newVersion(version));
        boolean looking = true;
        while (looking) {
            looking = backupFile.exists();
            if (!looking) {
                looking = false;
                continue;
            }
            backupFile = new File(defaultsFile.getParentFile(), defaultsFile.getName() + ".backup." + InitProjectUtil.newVersion(++version));
        }
        return backupFile;
    }

    private static String newVersion(int version) {
        if (version < 10) {
            return "0" + Integer.toString(version);
        }
        return Integer.toString(version);
    }

    public static enum FileCreationResultEnum {
        created,
        already_existed,
        skipped_changelog_step;

    }
}

