/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.diff;

import liquibase.diff.Difference;
import liquibase.serializer.AbstractLiquibaseSerializable;
import liquibase.serializer.LiquibaseSerializable;

public class FormattedDifference
extends AbstractLiquibaseSerializable
implements Comparable,
LiquibaseSerializable {
    private String message;
    private String field;
    private Object referenceValue;
    private Object comparedValue;

    public FormattedDifference() {
    }

    public FormattedDifference(String field, Object referenceValue, Object comparedValue) {
        this(null, field, referenceValue, comparedValue);
    }

    public FormattedDifference(String message, String field, Object referenceValue, Object comparedValue) {
        if (message == null) {
            message = field + " changed from '" + referenceValue + "' to '" + comparedValue + "'";
        }
        this.message = message;
        this.field = field;
        this.referenceValue = referenceValue;
        this.comparedValue = comparedValue;
    }

    public String getSerializedObjectName() {
        return "difference";
    }

    public String getSerializedObjectNamespace() {
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public String getField() {
        return this.field;
    }

    public Object getReferenceValue() {
        return this.referenceValue;
    }

    public Object getComparedValue() {
        return this.comparedValue;
    }

    public String toString() {
        return this.message;
    }

    public int compareTo(Object o) {
        return this.getField().compareTo(((Difference)o).getField());
    }

    public static FormattedDifference fromDifference(Difference difference) {
        return new FormattedDifference(difference.getMessage(), difference.getField(), difference.getReferenceValue(), difference.getComparedValue());
    }
}

