/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.database;

import com.datical.liquibase.ext.config.DatabaseChangelogHistoryConfiguration;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.LiquibaseTableNames;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.ChangelogJdbcMdcListener;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;

public class ProLiquibaseTableNames
implements LiquibaseTableNames {
    public static final String SHOULD_DROP_HISTORY_TABLE_SCOPE_KEY = "shouldDropHistoryTable";

    public List<String> getLiquibaseGeneratedTableNames(Database database) {
        return Collections.singletonList(DatabaseChangelogHistoryConfiguration.getTableName(database));
    }

    public void destroy(Database database) throws DatabaseException {
        Boolean shouldDropHistoryTable = (Boolean)Scope.getCurrentScope().get(SHOULD_DROP_HISTORY_TABLE_SCOPE_KEY, (Object)true);
        if (Boolean.FALSE.equals(shouldDropHistoryTable)) {
            return;
        }
        try {
            Relation example = new Table().setName(DatabaseChangelogHistoryConfiguration.getTableName(database)).setSchema(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName());
            if (SnapshotGeneratorFactory.getInstance().has((DatabaseObject)example, database)) {
                DatabaseObject table = SnapshotGeneratorFactory.getInstance().createSnapshot((DatabaseObject)example, database);
                DiffOutputControl diffOutputControl = new DiffOutputControl(true, true, false, null);
                Change[] change = ChangeGeneratorFactory.getInstance().fixUnexpected(table, diffOutputControl, database, database);
                SqlStatement[] sqlStatement = change[0].generateStatements(database);
                ChangelogJdbcMdcListener.execute((Database)database, executor -> executor.execute(sqlStatement[0]));
            }
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
    }

    public int getOrder() {
        return 0;
    }
}

