/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.helpers.ReportCommandArguments;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import com.datical.liquibase.ext.reports.ReportArguments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.UpdateTestingRollbackCommandStep;

@CommandOverride(override=UpdateTestingRollbackCommandStep.class)
public class ProUpdateTestingRollbackCommandStep
extends UpdateTestingRollbackCommandStep {
    private static final String DEFAULT_REPORT_NAME = String.format("Update-testing-rollback-report-%s", "dd-MMM-yyyy-HHmmss");
    private ReportArguments reportArguments;

    public List<Class<?>> requiredDependencies() {
        ArrayList deps = new ArrayList(super.requiredDependencies());
        deps.add(RollbackOnErrorArgument.class);
        deps.add(ReportCommandArguments.class);
        return deps;
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        this.reportArguments = (ReportArguments)commandScope.getDependency(ReportCommandArguments.class);
        super.run(resultsBuilder);
    }

    protected void initialUpdate(Liquibase liquibase, String tag, Contexts contexts, LabelExpression labelExpression) throws Exception {
        String finalName = this.getFinalName(true, "1of3");
        Scope.child(this.getUpdateScope(this.reportArguments.getEnabled(), finalName, this.reportArguments.getPath()), () -> super.initialUpdate(liquibase, tag, contexts, labelExpression));
    }

    protected void rollbackUpdate(Liquibase liquibase, int changesetsToRollback, Contexts contexts, LabelExpression labelExpression) throws Exception {
        String finalName = this.getFinalName(false, "2of3");
        Scope.child(this.getRollbackScope(this.reportArguments.getEnabled(), finalName, this.reportArguments.getPath()), () -> super.rollbackUpdate(liquibase, changesetsToRollback, contexts, labelExpression));
    }

    protected void finalUpdate(Liquibase liquibase, String tag, Contexts contexts, LabelExpression labelExpression) throws Exception {
        String finalName = this.getFinalName(true, "3of3");
        Scope.child(this.getUpdateScope(this.reportArguments.getEnabled(), finalName, this.reportArguments.getPath()), () -> super.finalUpdate(liquibase, tag, contexts, labelExpression));
    }

    private Map<String, Object> getUpdateScope(Boolean enabled, String name, String path) {
        HashMap<String, Object> scope = new HashMap<String, Object>();
        scope.put("liquibase.command.update.reportName", name);
        scope.put("liquibase.command.update.reportEnabled", enabled);
        scope.put("liquibase.command.update.reportPath", path);
        scope.put("liquibase.command.updateToTag.reportName", name);
        scope.put("liquibase.command.updateToTag.reportEnabled", enabled);
        scope.put("liquibase.command.updateToTag.reportPath", path);
        return scope;
    }

    private Map<String, Object> getRollbackScope(Boolean enabled, String name, String path) {
        HashMap<String, Object> scope = new HashMap<String, Object>();
        scope.put("liquibase.command.rollbackCount.reportName", name);
        scope.put("liquibase.command.rollbackCount.reportEnabled", enabled);
        scope.put("liquibase.command.rollbackCount.reportPath", path);
        return scope;
    }

    private String getFinalName(boolean isUpdate, String currentNumberAppend) {
        String finalName = this.reportArguments.getName();
        if (finalName.equals(DEFAULT_REPORT_NAME)) {
            finalName = isUpdate ? this.reportArguments.getName().replace("Update-testing-rollback", "Update") : this.reportArguments.getName().replace("Update-testing-rollback", "Rollback");
            return finalName.replace("report", String.format("report-%s", currentNumberAppend));
        }
        if (finalName.toLowerCase().endsWith(".html")) {
            return finalName.replace(".html", String.format("-%s.html", currentNumberAppend));
        }
        return String.format("%s-%s", finalName, currentNumberAppend);
    }
}

