/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.ForecastDMLCommandStep;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changeset.ChangeSetService;
import liquibase.changeset.ChangeSetServiceFactory;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.DbUrlConnectionArgumentsCommandStep;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.util.SqlUtil;
import liquibase.util.StringUtil;

public abstract class AbstractMaxAffectedRows
extends AbstractLiquibaseDynamicForecastRule {
    protected Database database;

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return false;
    }

    protected boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, String dmlPrefix) {
        DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        String messageTemplate = (String)messageParam.getValue();
        Integer threshold = (Integer)dynamicRule.getParameters().get(0).getValue();
        AtomicInteger total = new AtomicInteger();
        for (Change change : changes) {
            Sql[] sqlStatements = SqlGeneratorFactory.getInstance().generateSql(change, this.database);
            String sql = StringUtil.stripComments((String)SqlUtil.convertSqlArrayToString((Sql[])sqlStatements));
            boolean anyUpdatesFound = this.anyMatchingSql(changeSet, sql, dmlPrefix);
            if (!anyUpdatesFound) {
                return false;
            }
            if (this.database.getConnection() == null) {
                String errorMessage = String.format("Unable to execute check for change set '%s'.  No database connection available.", changeSet);
                this.addFailureRuleIteration(changeSet, errorMessage, (AbstractConfigurableRule)dynamicRule);
                return false;
            }
            if (!this.changeSetIsPending(changeSet)) {
                return false;
            }
            try {
                CommandScope commandScope = new CommandScope(ForecastDMLCommandStep.COMMAND_NAME);
                commandScope.addArgumentValue(ForecastDMLCommandStep.SQL_ARG, (Object)sql);
                commandScope.addArgumentValue(DbUrlConnectionArgumentsCommandStep.DATABASE_ARG, (Object)this.database);
                commandScope.addArgumentValue(ForecastDMLCommandStep.DML_PREFIX_ARG, (Object)dmlPrefix);
                CommandResults results = commandScope.execute();
                results.getResults().forEach((k, v) -> {
                    if (k.startsWith("rowsAffected_")) {
                        int value = (Integer)v;
                        if (value > threshold) {
                            String sqlToReport = k.replace("rowsAffected_", "");
                            sqlToReport = sqlToReport.replace("\n", "\n                    ");
                            this.addFailureRuleIteration(changeSet, this.getFailureMessage(messageTemplate, value, threshold, sqlToReport, changeSet), (AbstractConfigurableRule)dynamicRule);
                            total.set(-1);
                        }
                        if (total.get() >= 0) {
                            total.addAndGet(value);
                        }
                    }
                });
            }
            catch (CommandExecutionException cee) {
                String errorMessage = String.format("Error executing Forecast Update: %s", cee.getMessage());
                this.addFailureRuleIteration(changeSet, errorMessage, (AbstractConfigurableRule)dynamicRule);
            }
        }
        int finalTotal = total.get();
        if (finalTotal > 0 && finalTotal > threshold) {
            String sqlToReport = "multiple rows";
            this.addFailureRuleIteration(changeSet, this.getFailureMessage(messageTemplate, finalTotal, threshold, sqlToReport, changeSet), (AbstractConfigurableRule)dynamicRule);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, false);
    }

    private boolean changeSetIsPending(ChangeSet changeSet) {
        List pendingList = (List)Scope.getCurrentScope().get("pendingChangeSets", List.class);
        if (pendingList == null) {
            return false;
        }
        return pendingList.stream().anyMatch(c -> c.equals((Object)changeSet));
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        return false;
    }

    public static String getEndDelimiter(ChangeSet changeSet) {
        ChangeSetService service = ChangeSetServiceFactory.getInstance().createChangeSetService();
        return service.getEndDelimiter(changeSet);
    }

    private boolean anyMatchingSql(ChangeSet changeSet, String sql, String dmlPrefix) {
        String[] sqlStrings = StringUtil.processMultiLineSQL((String)sql, (boolean)true, (boolean)true, (String)AbstractMaxAffectedRows.getEndDelimiter(changeSet));
        return Arrays.stream(sqlStrings).anyMatch(sqlString -> sqlString.toLowerCase().trim().startsWith(dmlPrefix));
    }

    private String getFailureMessage(String messageTemplate, Integer rowsAffected, Integer threshold, String sql, ChangeSet changeSet) {
        String prefix = messageTemplate.replace("<AFFECTED_ROWS>", "'" + rowsAffected.toString() + "'").replace("<THRESHOLD>", threshold.toString());
        if (sql.contains("multiple rows")) {
            return prefix.replace("The SQL statement is '<STATEMENT>'", "There are multiple SQL statements").replace("'<CHANGESET>", "'" + changeSet.toString());
        }
        return prefix.replace("'<STATEMENT>", "%n'" + sql).replace("'<CHANGESET>", "%n'" + changeSet.toString());
    }
}

