/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.FileEncoder;
import com.datical.liquibase.ext.util.ProStringUtil;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class ChecksFileAccessor
implements FileAccessor {
    @Override
    public FileAccessorDTO loadFileContents(String filename) throws IOException, CommandExecutionException {
        Resource resource = ResourceUtil.getResource(filename);
        if (!resource.exists()) {
            String msg = "Check settings configuration file '" + filename + "' not found.";
            Scope.getCurrentScope().getLog(this.getClass()).info(msg);
            throw new FileNotFoundException(msg);
        }
        Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file located at '" + resource.getUri() + "'.");
        try {
            String contents = StreamUtil.readStreamAsString((InputStream)resource.openInputStream());
            Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file contents read from '" + resource.getUri() + "'.");
            if (StringUtil.isEmpty((String)contents)) {
                throw new CommandExecutionException("The checks settings file '" + resource.getPath() + "' is empty.");
            }
            FileAccessorDTO dto = FileEncoder.decode(contents, resource);
            if (dto.encoded) {
                String extraMessage = "\nThis backup file will work with Liquibase 4.5.0 users who specify it using the --checks-settings-file argument.";
                Resource originalResource = ResourceUtil.getResource(filename);
                Resource backupResource = originalResource.resolveSibling(new File(filename).getName() + ".v4.5");
                dto.warningMessage = ChecksFileAccessor.makeBackup(originalResource, backupResource, contents, extraMessage);
            }
            return dto;
        }
        catch (IOException ioException) {
            throw new CommandExecutionException(String.format("ERROR: The checks settings file specified at '%s' was not found. Please specify a path including the filename in the CLI, by Environment variable, or other standard method. Learn more at https://docs.liquibase.com/policy-checks", filename));
        }
    }

    public static String makeBackup(Resource resource, Resource backupResource, String contents, String extraMessage) {
        return ChecksFileAccessor.makeBackup(resource, backupResource, contents, extraMessage, true);
    }

    public static String makeBackup(Resource resource, Resource backupResource, String contents, String extraMessage, boolean printMessage) {
        try {
            try (OutputStream outputStream = backupResource.openOutputStream(new OpenOptions());){
                outputStream.write(contents.getBytes());
            }
            String message = "The file '" + ProStringUtil.stripUriPrefix(resource.getUri()) + "' has been updated so it can be used by your current version of Liquibase, and to simplify resolving merge conflicts in Source Control. No action is required from you. Your original file was backed up as '" + ProStringUtil.stripUriPrefix(backupResource.getUri()) + "'." + (extraMessage != null ? extraMessage : "");
            if (printMessage) {
                Scope.getCurrentScope().getLog(ChecksFileAccessor.class).warning(message);
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            }
            return message;
        }
        catch (IOException ioe) {
            String message = "Error creating backup file '" + resource.getUri() + "' " + ioe.getMessage();
            Scope.getCurrentScope().getLog(ChecksFileAccessor.class).warning(message, (Throwable)ioe);
            Scope.getCurrentScope().getUI().sendMessage(message);
            return null;
        }
    }

    @Override
    public void writeFileContents(Resource resource, String filename, String contents, boolean errorIfFileAlreadyExists) throws CommandExecutionException, IOException {
        block17: {
            try (OutputStream outputStream = this.createOrOpenResource(resource, filename);){
                outputStream.write((FileEncoder.generateFileHeader() + contents).getBytes((String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
            }
            catch (FileAlreadyExistsException e) {
                if (!errorIfFileAlreadyExists) break block17;
                throw new IOException("The file " + filename + " already exists and thus cannot be created.", e);
            }
        }
        if (resource == null) {
            resource = ResourceUtil.getResource(filename);
        }
        if (!resource.exists()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file resource located at '" + ProStringUtil.stripUriPrefix(resource.getUri()) + "'.");
        } else {
            Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file located at '" + new File(filename).getAbsolutePath() + "'.");
        }
    }

    private OutputStream createOrOpenResource(Resource resource, String path) throws IOException {
        if (resource == null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named '" + path + "' found.");
            Scope.getCurrentScope().getLog(this.getClass()).info("Creating new file: " + path);
            PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            return pathHandlerFactory.createResource(path);
        }
        return resource.openOutputStream(new OpenOptions().setCreateIfNeeded(false));
    }
}

