/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.ChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfigFileInfo;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.AbstractRegexHelperCheck;
import com.datical.liquibase.ext.checks.dynamic.PatternAFollowedByPatternB;
import com.datical.liquibase.ext.checks.dynamic.PatternANotFollowedByPatternB;
import com.datical.liquibase.ext.checks.dynamic.PatternANotPrecededByPatternB;
import com.datical.liquibase.ext.checks.dynamic.PatternAPrecededByPatternB;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksPackageNotFoundException;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import com.datical.liquibase.ext.reports.checks.ChecksRunReportParameters;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.ui.NoEmptyValueInputHandler;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class CheckSettingsConfigHelper {
    public static final String LIQUIBASE_CHECKS_SETTINGS_CONF = "liquibase.checks-settings.conf";
    private String checkSettingsFilename;
    private Boolean autoUpdate;
    private Boolean autoEnableNewChecks;
    private boolean headless;
    private boolean usedDefaultChecksSettingsFilename;
    private final FileAccessor fileAccessor;
    private final ChecksRunReportParameters checksRunReportParameters;

    public CheckSettingsConfigHelper(String fileName, Boolean autoUpdate, Boolean autoEnableNewChecks) {
        this(fileName, autoUpdate, autoEnableNewChecks, null);
    }

    public CheckSettingsConfigHelper(String fileName, Boolean autoUpdate, Boolean autoEnableNewChecks, ChecksRunReportParameters checksRunReportParameters) {
        this.headless = (Boolean)GlobalConfiguration.HEADLESS.getCurrentConfiguredValue().getValue();
        this.fileAccessor = (FileAccessor)Scope.getCurrentScope().get("fileAccessor", (Object)new ChecksFileAccessor());
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            this.usedDefaultChecksSettingsFilename = true;
            this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
        } else {
            this.usedDefaultChecksSettingsFilename = false;
            this.checkSettingsFilename = fileName;
        }
        this.autoUpdate = autoUpdate;
        this.autoEnableNewChecks = autoEnableNewChecks;
        this.checksRunReportParameters = checksRunReportParameters;
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> rules) throws IOException, CommandExecutionException {
        return this.read(rules, null, false, null);
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> rules, String selectedPackages) throws IOException, CommandExecutionException {
        return this.read(rules, selectedPackages, false, null);
    }

    public CheckSettingsConfig read(List<AbstractLiquibaseRule> rules, String selectedPackages, boolean isLoadedFromPackageFile, Set<String> processedFilenames) throws IOException, CommandExecutionException {
        CheckSettingsConfig checkSettingsConfig;
        FileAccessorDTO dto;
        try {
            dto = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
        }
        catch (FileNotFoundException e) {
            if (this.headless || !this.usedDefaultChecksSettingsFilename) {
                throw e;
            }
            if (GlobalConfiguration.SEARCH_PATH.getCurrentValue() != null && ResourceUtil.isAbsolute(this.checkSettingsFilename)) {
                String message = "Unable to locate, read, or update checks-settings file. Invalid paths occur when both search path is set and check-settings.conf file is set with an absolute path.Please re-configure these properties to generate a valid path.";
                Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).severe(message);
                throw new IllegalArgumentException(message);
            }
            String shouldCreateFile = this.promptShouldCreateFile();
            if (shouldCreateFile.equalsIgnoreCase("n")) {
                Scope.getCurrentScope().getUI().sendMessage("No changes have been made to default check configuration, because you chose to not create a liquibase.checks-settings.conf file.");
                return null;
            }
            if (shouldCreateFile.equals("3")) {
                this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
                this.createFile(rules, selectedPackages);
                return null;
            }
            if (shouldCreateFile.equals("2")) {
                this.checkSettingsFilename = (String)Scope.getCurrentScope().getUI().prompt("Please enter a relative or absolute, local or remote path. Do not provide a filename. To use a remote path, such as \"s3://<mybucket>\", please install the correct extension. Learn more about remote path options at http://docs.liquibase.com/s3", null, new NoEmptyValueInputHandler(), String.class);
                this.checkSettingsFilename = this.checkSettingsFilename + "/liquibase.checks-settings.conf";
                return this.createFile(rules, selectedPackages);
            }
            return this.createFile(rules, selectedPackages);
        }
        try {
            checkSettingsConfig = CheckSettingsConfig.fromFileAccessorDTO(dto, selectedPackages, isLoadedFromPackageFile, processedFilenames, this.checksRunReportParameters, this.autoUpdate, this.autoEnableNewChecks);
        }
        catch (Exception e) {
            if (dto.isPackageFile && (e instanceof ChecksPackageNotFoundException || e instanceof UnexpectedLiquibaseException || e instanceof FileNotFoundException)) {
                throw e;
            }
            Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to read the policy checks config file", (Throwable)e);
            throw new CommandExecutionException(CheckSettingsConfigHelper.generateInvalidChecksExceptionMessage(this.checkSettingsFilename), (Throwable)e);
        }
        this.upgradeToNewYamlFormat(dto, checkSettingsConfig);
        this.replaceOldParametersInPatternMatchingRules(dto, checkSettingsConfig);
        List<AbstractConfigurableRule> configRules = checkSettingsConfig.getRules();
        if (!dto.versioned && StringUtil.isEmpty((String)checkSettingsConfig.getVersion()) && !dto.isPackageFile) {
            configRules.forEach(r -> r.setSeverity(SeverityEnum.INFO));
            this.write(checkSettingsConfig);
        }
        if (dto.encoded) {
            this.write(checkSettingsConfig);
        }
        if (StringUtil.isEmpty((String)checkSettingsConfig.getVersion())) {
            checkSettingsConfig.setVersion("1.1");
        }
        boolean doUpdate = this.shouldAutoUpdate();
        if (!this.upToDate(rules, configRules) && !dto.isPackageFile) {
            if (this.autoUpdate == null) {
                String answer = this.promptShouldUpdate();
                if ((answer = answer.toLowerCase()).startsWith("n")) {
                    this.updatePropertiesFile("liquibase.command.autoUpdate", "off");
                    doUpdate = false;
                } else if (answer.startsWith("s")) {
                    doUpdate = false;
                }
            }
            if (doUpdate) {
                Resource originalResource = ResourceUtil.getResource(this.checkSettingsFilename);
                Resource backupResource = CheckSettingsConfigHelper.calcBackupResource(originalResource);
                String backupContents = dto.getOriginalContents();
                ChecksFileAccessor.makeBackup(originalResource, backupResource, backupContents, null, true);
            }
        }
        if (!doUpdate || dto.isPackageFile) {
            return checkSettingsConfig;
        }
        String message = this.createChecksAddedMessage();
        Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
        Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info(message);
        boolean addedMissingRules = this.addMissingRules(rules, checkSettingsConfig, isLoadedFromPackageFile, this.autoEnableNewChecks);
        boolean addedMissingParameters = this.addMissingParameters(rules, checkSettingsConfig);
        boolean setNewBasicRuleValues = this.setNewBasicRuleValues(rules, checkSettingsConfig);
        if (addedMissingRules || addedMissingParameters || setNewBasicRuleValues) {
            this.write(checkSettingsConfig);
        }
        CheckSettingsConfigHelper.sortRulesByPriority(rules, checkSettingsConfig);
        return checkSettingsConfig;
    }

    private String createChecksAddedMessage() {
        String message = Boolean.TRUE.equals(this.autoEnableNewChecks) ? String.format("Additional checks have been added to '%s' and are enabled to run. To prevent auto-enabled new checks on upgrades, set '--auto-enable-new-checks=false'. Learn more at https://docs.liquibase.com/policy-checks", this.checkSettingsFilename) : String.format("Additional checks have been added to '%s' and are disabled. To auto-enable new checks on upgrades, set '--auto-enable-new-checks=true'. Learn more at https://docs.liquibase.com/policy-checks", this.checkSettingsFilename);
        return message;
    }

    private boolean shouldAutoUpdate() {
        return this.autoUpdate == null || this.autoUpdate != false;
    }

    public static String generateInvalidChecksExceptionMessage(String checkSettingsFilename) {
        return "Liquibase cannot read file '" + checkSettingsFilename + "'. The file may be corrupted, an incompatible version, or stored in an inaccessible local or remote location. Check your configurations, permissions, credentials, etc and try again. Learn more at https://docs.liquibase.com/policy-checks";
    }

    private void upgradeToNewYamlFormat(FileAccessorDTO dto, CheckSettingsConfig checkSettingsConfig) {
        try {
            if (dto.hasClassIdentifiers) {
                if (this.shouldAutoUpdate()) {
                    Resource originalResource = dto.resource;
                    Path path = Paths.get(originalResource.getPath(), new String[0]);
                    Resource backupResource = originalResource.resolveSibling(path.getFileName() + ".v4.23");
                    dto.warningMessage = dto.warningMessage == null ? ChecksFileAccessor.makeBackup(originalResource, backupResource, dto.getOriginalContents(), null) : dto.warningMessage + ChecksFileAccessor.makeBackup(originalResource, backupResource, dto.getOriginalContents(), null);
                    this.write(checkSettingsConfig);
                } else {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Not upgrading checks file format to use new yaml format because autoUpdate is not enabled.");
                }
            }
        }
        catch (Exception e) {
            String msg = "A new Liquibase checks-settings file in YAML format is available, but the auto-backup and update failed. The file will be updated in place without a backup.";
            Scope.getCurrentScope().getLog(this.getClass()).warning(msg, (Throwable)e);
            Scope.getCurrentScope().getUI().sendMessage(msg);
        }
    }

    private void replaceOldParametersInPatternMatchingRules(FileAccessorDTO dto, CheckSettingsConfig checkSettingsConfig) {
        ArrayList<String> failedRules = new ArrayList<String>();
        try {
            LinkedHashSet<UUID> ruleIdsToCheck = new LinkedHashSet<UUID>(Arrays.asList(new PatternAFollowedByPatternB().getId(), new PatternANotFollowedByPatternB().getId(), new PatternANotPrecededByPatternB().getId(), new PatternAPrecededByPatternB().getId()));
            LinkedHashSet<DynamicRuleParameterEnum> parametersToCheck = new LinkedHashSet<DynamicRuleParameterEnum>(Arrays.asList(DynamicRuleParameterEnum.PRIMARY_SEARCH_STRING, DynamicRuleParameterEnum.LOOKAHEAD_SEARCH_STRING, DynamicRuleParameterEnum.LOOKBEHIND_SEARCH_STRING, DynamicRuleParameterEnum.LOOKAHEAD_MESSAGE, DynamicRuleParameterEnum.LOOKBEHIND_MESSAGE, DynamicRuleParameterEnum.NEGATIVE_LOOKAHEAD_MESSAGE, DynamicRuleParameterEnum.NEGATIVE_LOOKBEHIND_MESSAGE));
            boolean hasOldParameters = checkSettingsConfig.getRules().stream().anyMatch(rule -> rule instanceof DynamicRule && ruleIdsToCheck.contains(((DynamicRule)rule).getParentRuleId()) && ((DynamicRule)rule).getParameters().stream().anyMatch(param -> parametersToCheck.contains((Object)param.getParameterAsEnum())));
            if (hasOldParameters) {
                if (this.shouldAutoUpdate()) {
                    Resource originalResource = dto.resource;
                    Path path = Paths.get(originalResource.getPath(), new String[0]);
                    Resource backupResource = originalResource.resolveSibling(path.getFileName() + ".v4.28");
                    dto.warningMessage = dto.warningMessage == null ? ChecksFileAccessor.makeBackup(originalResource, backupResource, dto.getOriginalContents(), null) : dto.warningMessage + ChecksFileAccessor.makeBackup(originalResource, backupResource, dto.getOriginalContents(), null);
                    for (AbstractConfigurableRule check : checkSettingsConfig.getRules()) {
                        try {
                            if (!(check instanceof DynamicRule) || !ruleIdsToCheck.contains(((DynamicRule)check).getParentRuleId()) && !ruleIdsToCheck.contains(check.getId())) continue;
                            DynamicRule dynamicRule = (DynamicRule)check;
                            for (DynamicRuleParameterEnum param : parametersToCheck) {
                                DynamicRuleParameter parameter = dynamicRule.getParameter(param);
                                if (parameter == null) continue;
                                dynamicRule.getParameters().remove(parameter);
                                dynamicRule.getParameters().add(this.createReplacementParameter(parameter, check.findParentRule(AbstractChecksCommandStep.listAllRules()), dynamicRule.getShortName()));
                            }
                        }
                        catch (Exception e) {
                            Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to update rule " + check.getShortName(), (Throwable)e);
                            failedRules.add(check.getShortName());
                        }
                    }
                    this.write(checkSettingsConfig);
                } else {
                    Scope.getCurrentScope().getLog(this.getClass()).info("Not replacing deprecated parameters associated with pattern checks because " + ChecksAutoUpdateArgument.CHECKS_AUTO_UPDATE_ARG.getName() + " is not enabled.");
                }
            }
        }
        catch (Exception e) {
            String msg = "ERROR: Liquibase failed to update your checks-settings file for the following checks:" + System.lineSeparator() + "  - " + StringUtils.join(failedRules, (String)(System.lineSeparator() + "  - ")) + System.lineSeparator() + "Please disable these checks and set --auto-update=off to suppress this message, and then report this bug to support@liquibase.com.";
            Scope.getCurrentScope().getLog(this.getClass()).severe(msg, (Throwable)e);
            Scope.getCurrentScope().getUI().sendMessage(msg);
        }
    }

    private DynamicRuleParameter createReplacementParameter(DynamicRuleParameter parameter, Optional<AbstractLiquibaseRule> parentRule, String shortName) {
        DynamicRuleParameterEnum parameterAsEnum = parameter.getParameterAsEnum();
        switch (parameterAsEnum) {
            case PRIMARY_SEARCH_STRING: {
                Scope.getCurrentScope().getLog(this.getClass()).info("Replacing deprecated parameter PRIMARY_SEARCH_STRING with " + (Object)((Object)DynamicRuleParameterEnum.PATTERN_A) + " in rule " + shortName + ", value: " + parameter.getValue());
                return new DynamicRuleParameter(DynamicRuleParameterEnum.PATTERN_A, parameter.getValue());
            }
            case LOOKAHEAD_SEARCH_STRING: 
            case LOOKBEHIND_SEARCH_STRING: {
                Scope.getCurrentScope().getLog(this.getClass()).info("Replacing deprecated parameter " + (Object)((Object)parameterAsEnum) + " with " + (Object)((Object)DynamicRuleParameterEnum.PATTERN_B) + " in rule " + shortName + ", value: " + parameter.getValue());
                return new DynamicRuleParameter(DynamicRuleParameterEnum.PATTERN_B, parameter.getValue());
            }
            case LOOKAHEAD_MESSAGE: 
            case LOOKBEHIND_MESSAGE: 
            case NEGATIVE_LOOKAHEAD_MESSAGE: 
            case NEGATIVE_LOOKBEHIND_MESSAGE: {
                AbstractLiquibaseRule abstractLiquibaseRule;
                String defaultValueForMessage = "Default message not found. Please customize this check and provide a message.";
                if (parentRule.isPresent() && (abstractLiquibaseRule = parentRule.get()) instanceof AbstractRegexHelperCheck) {
                    defaultValueForMessage = ((AbstractRegexHelperCheck)abstractLiquibaseRule).getDefaultValueForMessage();
                }
                Scope.getCurrentScope().getLog(this.getClass()).info("Replacing deprecated parameter " + (Object)((Object)parameterAsEnum) + " with " + (Object)((Object)DynamicRuleParameterEnum.MESSAGE) + " in rule " + shortName + ", value: " + parameter.getValue());
                return new DynamicRuleParameter(DynamicRuleParameterEnum.MESSAGE, defaultValueForMessage);
            }
        }
        return parameter;
    }

    private String promptShouldUpdate() {
        return (String)Scope.getCurrentScope().getUI().prompt(System.lineSeparator() + "New or Upgraded Policy Checks are available." + System.lineSeparator() + "Do you want to auto-backup and update '" + this.checkSettingsFilename + "' with the new checks? (Y/n/s)", (Object)"Y", (input, type) -> {
            if (!(input != null && (input.equalsIgnoreCase("y") || input.equalsIgnoreCase("yes") || input.equalsIgnoreCase("n") || input.equalsIgnoreCase("no") || input.equalsIgnoreCase("s") || input.equalsIgnoreCase("skip")))) {
                throw new IllegalArgumentException();
            }
            return input;
        }, String.class);
    }

    private String promptShouldCreateFile() {
        return (String)Scope.getCurrentScope().getUI().prompt("WARNING: No default checks-settings file detected. Would you like to create and automatically use 'liquibase.checks-settings.conf' ?" + System.lineSeparator() + "[1] Yes, create and use default check-settings file in the Current Working Directory" + System.lineSeparator() + "[2] Yes, create and use default check-settings file at a path I will specify" + System.lineSeparator() + "[3] Just create default check-settings file in the CWD, do not use, and exit command" + System.lineSeparator() + "[n] No, do not create default check-settings file, and exit command" + System.lineSeparator(), (Object)"1", (input, type) -> {
            if (input == null || !input.equalsIgnoreCase("1") && !input.equalsIgnoreCase("2") && !input.equalsIgnoreCase("3") && !input.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return input;
        }, String.class);
    }

    private CheckSettingsConfig createFile(List<AbstractLiquibaseRule> rules, String selectedPackages) throws IOException, CommandExecutionException {
        FileAccessorDTO dto;
        this.write(CheckSettingsConfig.generateDefaultConfigFromRules(rules, null), true);
        if (!(this.fileAccessor instanceof InMemoryChecksFileAccessor)) {
            Scope.getCurrentScope().getUI().sendMessage(this.checkSettingsFilename + " successfully created!");
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info(this.checkSettingsFilename + " successfully created!");
        }
        try {
            dto = this.reloadFileAccessorDTO();
        }
        catch (Exception e1) {
            throw new IOException("Unable to load created defaults file '" + this.checkSettingsFilename + "'", e1);
        }
        return CheckSettingsConfig.fromFileAccessorDTO(dto, selectedPackages, false, null, this.checksRunReportParameters, this.autoUpdate, this.autoEnableNewChecks);
    }

    private FileAccessorDTO reloadFileAccessorDTO() throws Exception {
        AtomicReference atomicDto = new AtomicReference();
        HashMap<String, SearchPathResourceAccessor> scopeValues = new HashMap<String, SearchPathResourceAccessor>();
        scopeValues.put(Scope.Attr.resourceAccessor.name(), new SearchPathResourceAccessor(".", new ResourceAccessor[0]));
        Scope.child(scopeValues, () -> {
            Scope.getCurrentScope().getLog(CheckSettingsConfigHelper.class).info("Reloading new file '" + this.checkSettingsFilename + "'");
            FileAccessorDTO localDto = this.fileAccessor.loadFileContents(this.checkSettingsFilename);
            atomicDto.set(localDto);
        });
        return (FileAccessorDTO)atomicDto.get();
    }

    private boolean addMissingParameters(List<AbstractLiquibaseRule> systemRules, CheckSettingsConfig checkSettingsConfig) {
        boolean addedMissingParameter = false;
        for (AbstractLiquibaseRule systemRule : systemRules) {
            List<AbstractConfigurableRule> matchingConfigurableRules = checkSettingsConfig.getExecutableRulesByRuleId(systemRule.getId());
            for (AbstractConfigurableRule configRule : matchingConfigurableRules) {
                if (!(configRule instanceof DynamicRule)) continue;
                DynamicRule dynamicConfigRule = (DynamicRule)configRule;
                for (RuleParameter<?> systemRuleParameter : systemRule.getParameters()) {
                    try {
                        boolean shouldAddNewParameter;
                        DynamicRuleParameter existingConfigParameter = dynamicConfigRule.getParameter(systemRuleParameter.getParameter());
                        if (existingConfigParameter != null || !(shouldAddNewParameter = systemRuleParameter.shouldPrompt(dynamicConfigRule.getParameters()))) continue;
                        ((DynamicRule)configRule).getParameters().add(new DynamicRuleParameter(systemRuleParameter.getParameter(), systemRuleParameter.getDefaultValue()));
                        addedMissingParameter = true;
                    }
                    catch (Exception e) {
                        Scope.getCurrentScope().getLog(this.getClass()).fine(String.format("Failed to find matching parameter for system rule: %s parameter: %s", new Object[]{systemRule.getShortName(), systemRuleParameter.getParameter()}));
                    }
                }
            }
        }
        return addedMissingParameter;
    }

    private void updatePropertiesFile(String key, String value) throws IOException {
        String defaultsFilePath = (String)LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getCurrentConfiguredValue().getValue();
        File defaultsFile = null;
        if (defaultsFilePath != null) {
            defaultsFile = new File(defaultsFilePath);
        }
        if (defaultsFile == null) {
            return;
        }
        Properties properties = new Properties();
        try (InputStream is2 = Files.newInputStream(Paths.get(defaultsFilePath, new String[0]), new OpenOption[0]);){
            properties.load(is2);
            String existingValue = (String)properties.get(key);
            if (value.equalsIgnoreCase(existingValue)) {
                return;
            }
        }
        catch (IOException is2) {
            // empty catch block
        }
        String stringToWrite = String.format("%n%s=%s%n", key, value);
        String encoding = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(defaultsFile, "rw");){
            randomAccessFile.seek(defaultsFile.length());
            randomAccessFile.write(stringToWrite.getBytes(encoding));
        }
    }

    private boolean upToDate(List<AbstractLiquibaseRule> rules, List<AbstractConfigurableRule> configRules) {
        return rules.stream().allMatch(systemRule -> {
            Optional<AbstractConfigurableRule> configRuleOpt = CheckSettingsConfig.findRuleById(configRules, systemRule.getId());
            if (configRuleOpt.isPresent()) {
                AbstractConfigurableRule configRule = configRuleOpt.get();
                if (configRule instanceof DynamicRule) {
                    return systemRule.getParameters().stream().allMatch(systemRuleParameter -> ((DynamicRule)configRule).getParameter(systemRuleParameter.getParameter()) != null);
                }
                return true;
            }
            return false;
        });
    }

    private static Resource calcBackupResource(Resource originalResource) {
        String simpleName;
        Resource backupResource = null;
        String backupResourceName = null;
        int version = 1;
        Pattern p = Pattern.compile("(.*).backup.([0-9])+$");
        Matcher m = p.matcher(originalResource.getPath());
        if (m.matches()) {
            String existingVersion = m.group(2);
            version = Integer.parseInt(existingVersion) + 1;
            simpleName = CheckSettingsConfigHelper.determineSimpleName(originalResource);
            backupResourceName = simpleName.replaceAll("backup\\." + CheckSettingsConfigHelper.newVersion(Integer.parseInt(existingVersion)), "backup." + CheckSettingsConfigHelper.newVersion(version));
        } else {
            String simpleName2 = CheckSettingsConfigHelper.determineSimpleName(originalResource);
            backupResourceName = simpleName2 + ".backup." + CheckSettingsConfigHelper.newVersion(version);
        }
        backupResource = originalResource.resolveSibling(backupResourceName);
        boolean looking = true;
        while (looking) {
            looking = backupResource.exists();
            if (!looking) continue;
            simpleName = CheckSettingsConfigHelper.determineSimpleName(originalResource);
            backupResourceName = simpleName + ".backup." + CheckSettingsConfigHelper.newVersion(++version);
            backupResource = originalResource.resolveSibling(backupResourceName);
        }
        return backupResource;
    }

    private static String determineSimpleName(Resource originalResource) {
        String workingPath = originalResource.getPath();
        String[] parts = workingPath.replace("\\", "/").split("/");
        String simpleName = null;
        simpleName = parts.length == 1 ? parts[0] : parts[parts.length - 1];
        return simpleName;
    }

    private static File calcBackupFile(File originalFile) {
        File backupFile = null;
        int version = 1;
        Pattern p = Pattern.compile("(.*).backup.([0-9])+$");
        Matcher m = p.matcher(originalFile.getName());
        if (m.matches()) {
            String existingVersion = m.group(2);
            version = Integer.parseInt(existingVersion) + 1;
            backupFile = new File(originalFile.getParentFile(), originalFile.getName().replaceAll("backup\\." + CheckSettingsConfigHelper.newVersion(Integer.parseInt(existingVersion)), "backup." + CheckSettingsConfigHelper.newVersion(version)));
        } else {
            backupFile = new File(originalFile.getParentFile(), originalFile.getName() + ".backup." + CheckSettingsConfigHelper.newVersion(version));
        }
        boolean looking = true;
        while (looking) {
            looking = backupFile.exists();
            if (!looking) continue;
            backupFile = new File(originalFile.getParentFile(), originalFile.getName() + ".backup." + CheckSettingsConfigHelper.newVersion(++version));
        }
        return backupFile;
    }

    private static String newVersion(int version) {
        if (version < 10) {
            return "0" + version;
        }
        return Integer.toString(version);
    }

    public CheckSettingsConfigHelper(FileAccessor fileAccessor) {
        this.fileAccessor = fileAccessor;
        this.checkSettingsFilename = LIQUIBASE_CHECKS_SETTINGS_CONF;
        this.checksRunReportParameters = null;
    }

    public static void sortRulesByPriority(List<AbstractLiquibaseRule> rules, CheckSettingsConfig checkSettingsConfig) {
        ArrayList<AbstractConfigurableRule> orderedRules = new ArrayList<AbstractConfigurableRule>(checkSettingsConfig.getRules().size());
        if (rules != null) {
            for (AbstractLiquibaseRule rule : rules) {
                orderedRules.addAll(checkSettingsConfig.getExecutableRulesByRuleId(rule.getId()));
            }
        }
        checkSettingsConfig.setUnrecognizedRules(checkSettingsConfig.getRules().stream().filter(r -> !orderedRules.contains(r)).collect(Collectors.toList()));
        checkSettingsConfig.setRules(orderedRules);
    }

    private boolean addMissingRules(List<AbstractLiquibaseRule> rules, CheckSettingsConfig config, boolean isLoadedFromPackageFile, Boolean autoEnableNewChecks) {
        boolean ruleInstancesAdded = false;
        if (rules != null) {
            for (AbstractLiquibaseRule rule : rules) {
                AbstractConfigurableRule matchingRule = config.getRuleById(rule.getId());
                if (matchingRule != null) continue;
                AbstractConfigurableRule newRule = AbstractConfigurableRule.fromRuleImplementation(rule, new CheckSettingsConfigFileInfo(isLoadedFromPackageFile, config.getResources().get(0).getPath()));
                if (newRule.isEnabled() && (autoEnableNewChecks == null || !autoEnableNewChecks.booleanValue())) {
                    newRule.setEnabled(false);
                }
                ruleInstancesAdded = config.getRules().add(newRule);
            }
        }
        return ruleInstancesAdded;
    }

    private boolean setNewBasicRuleValues(List<AbstractLiquibaseRule> rules, CheckSettingsConfig config) {
        boolean updateRules = false;
        if (rules != null) {
            for (AbstractLiquibaseRule rule : rules) {
                AbstractConfigurableRule matchingRule = config.getRuleById(rule.getId());
                if (matchingRule == null) continue;
                if (matchingRule.getShortName() == null) {
                    matchingRule.setShortName(rule.getShortName());
                    updateRules = true;
                }
                if (matchingRule.getName() == null) {
                    matchingRule.setName(rule.getName());
                    updateRules = true;
                }
                if (matchingRule.getDescription() != null) continue;
                matchingRule.setDescription(rule.getDescription());
                updateRules = true;
            }
        }
        return updateRules;
    }

    public void write(CheckSettingsConfig csc, boolean errorIfFileAlreadyExists) throws IOException, CommandExecutionException {
        csc.setFileModified(new Date());
        if (csc.getFileCreated() == null) {
            csc.setFileCreated(new Date());
        }
        String yml = csc.toYaml();
        this.fileAccessor.writeFileContents(csc.getResources().get(0), this.checkSettingsFilename, yml, errorIfFileAlreadyExists);
    }

    public void write(CheckSettingsConfig csc) throws IOException, CommandExecutionException {
        this.write(csc, false);
    }
}

