/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;

public abstract class AbstractLiquibaseBasicRule
extends AbstractLiquibaseRule {
    @Override
    public final boolean evaluate(Facts facts) throws Exception {
        List<ChangeSet> changeSets = this.getChangeSetFromFacts(facts);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = this.getSnapshotFromFacts(facts);
        BasicRule configurableRule = (BasicRule)this.getAbstractConfigurableRuleFromFacts(facts);
        boolean result = false;
        if (changeSets == null && lazyDatabaseSnapshot == null) {
            return result;
        }
        if (changeSets != null) {
            for (ChangeSet changeSet : changeSets) {
                boolean thisResult;
                if (changeSet == null || !this.shouldBeEvaluated(changeSet, (AbstractConfigurableRule)configurableRule)) {
                    thisResult = this.putResultSuccessful(changeSet, false, null);
                } else {
                    thisResult = (Boolean)Scope.child(Collections.singletonMap("changeset", changeSet), () -> this.internalEvaluate(changeSet, configurableRule));
                    if (Boolean.TRUE.equals(this.getShouldCheckRollbackFromFacts(facts))) {
                        Scope.child(Collections.singletonMap("changeset", changeSet), () -> this.internalRollbackEvaluate(changeSet, changeSet.getRollback().getChanges(), configurableRule));
                    }
                }
                if (result) continue;
                result = thisResult;
            }
        }
        if (lazyDatabaseSnapshot != null) {
            try {
                DiffResult diffResult = lazyDatabaseSnapshot.createDiffResult();
                Database database = lazyDatabaseSnapshot.getDatabase();
                for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
                    if (database.isLiquibaseObject(databaseObject) || !this.shouldBeEvaluated(databaseObject, (AbstractConfigurableRule)configurableRule)) continue;
                    boolean thisResult = this.internalEvaluate(databaseObject, configurableRule);
                    if (result) continue;
                    result = thisResult;
                }
            }
            catch (CommandExecutionException | DatabaseException | InvalidExampleException e) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to generate diff from database lazyDatabaseSnapshot, and thus failed to run the database checks.", e);
                this.putResultUnsuccessful((DatabaseObject)null, "Failed to generate diff from database lazyDatabaseSnapshot", (AbstractConfigurableRule)configurableRule);
            }
        }
        return result;
    }

    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, BasicRule basicRule) {
        return false;
    }

    public abstract boolean internalEvaluate(ChangeSet var1, BasicRule var2);

    public abstract boolean internalEvaluate(DatabaseObject var1, BasicRule var2);
}

