/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.reports.drift;

import com.datical.liquibase.ext.reports.drift.ReportObject;
import com.datical.liquibase.ext.reports.drift.ReportObjectContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import liquibase.diff.DiffResult;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.DatabaseObjectCollectionComparator;
import liquibase.diff.output.report.DiffToReport;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;

public class TextDriftReport
extends DiffToReport {
    private final DatabaseObjectCollectionComparator comparator = new DatabaseObjectCollectionComparator();
    private final List<ReportObjectContainer> missing = new ArrayList<ReportObjectContainer>();
    private final List<ReportObjectContainer> unexpected = new ArrayList<ReportObjectContainer>();
    private final List<ReportObjectContainer> changed = new ArrayList<ReportObjectContainer>();

    public TextDriftReport(DiffResult diffResult) {
        super(diffResult, null);
        this.missing.addAll(this.setupMissingValues());
        this.unexpected.addAll(this.setupUnexpectedValues());
        this.changed.addAll(this.setupChangedValues());
    }

    public DiffResult getDiffResult() {
        return this.diffResult;
    }

    private TreeSet<Class<? extends DatabaseObject>> setupComparedTypes() {
        TreeSet<Class<? extends DatabaseObject>> types = new TreeSet<Class<? extends DatabaseObject>>(Comparator.comparing(Class::getSimpleName));
        types.addAll(this.diffResult.getCompareControl().getComparedTypes());
        return types;
    }

    private List<ReportObjectContainer> setupMissingValues() {
        TreeSet<Class<? extends DatabaseObject>> types = this.setupComparedTypes();
        ArrayList<ReportObjectContainer> reportValues = new ArrayList<ReportObjectContainer>();
        for (Class<? extends DatabaseObject> type : types) {
            ReportObjectContainer reportValue;
            if (type.equals(Schema.class) && !this.diffResult.getComparisonSnapshot().getDatabase().supportsSchemas() || (reportValue = new ReportObjectContainer(this.getTypeName(type), this.populateDatabaseObjectReportValue(this.diffResult.getMissingObjects(type, (Comparator)this.comparator)))).getResults().isEmpty()) continue;
            reportValues.add(reportValue);
        }
        return reportValues;
    }

    private List<ReportObjectContainer> setupUnexpectedValues() {
        TreeSet<Class<? extends DatabaseObject>> types = this.setupComparedTypes();
        ArrayList<ReportObjectContainer> reportValues = new ArrayList<ReportObjectContainer>();
        for (Class<? extends DatabaseObject> type : types) {
            ReportObjectContainer reportValue;
            if (type.equals(Schema.class) && !this.diffResult.getComparisonSnapshot().getDatabase().supportsSchemas() || (reportValue = new ReportObjectContainer(this.getTypeName(type), this.populateDatabaseObjectReportValue(this.diffResult.getUnexpectedObjects(type, (Comparator)this.comparator)))).getResults().isEmpty()) continue;
            reportValues.add(reportValue);
        }
        return reportValues;
    }

    private List<ReportObjectContainer> setupChangedValues() {
        TreeSet<Class<? extends DatabaseObject>> types = this.setupComparedTypes();
        ArrayList<ReportObjectContainer> reportValues = new ArrayList<ReportObjectContainer>();
        for (Class<? extends DatabaseObject> type : types) {
            ReportObjectContainer reportValue;
            if (type.equals(Schema.class) && !this.diffResult.getComparisonSnapshot().getDatabase().supportsSchemas() || (reportValue = new ReportObjectContainer(this.getTypeName(type), this.populateDatabaseObjectReportValue(this.diffResult.getChangedObjects(type, (Comparator)this.comparator)))).getResults().isEmpty()) continue;
            reportValues.add(reportValue);
        }
        return reportValues;
    }

    private List<ReportObject> populateDatabaseObjectReportValue(Set<? extends DatabaseObject> objects) {
        ArrayList<ReportObject> values = new ArrayList<ReportObject>();
        Schema lastSchema = null;
        if (objects.isEmpty()) {
            return values;
        }
        for (DatabaseObject databaseObject : objects) {
            if (!this.diffResult.getReferenceSnapshot().getSnapshotControl().shouldInclude(databaseObject)) continue;
            if (this.getIncludeSchema() && databaseObject.getSchema() != null && (lastSchema == null || !lastSchema.equals((Object)databaseObject.getSchema()))) {
                lastSchema = databaseObject.getSchema();
                String schemaName = databaseObject.getSchema().getName();
                if (schemaName == null) {
                    schemaName = databaseObject.getSchema().getCatalogName();
                }
                schemaName = this.includeSchemaComparison(schemaName);
                values.add(new ReportObject(databaseObject.getObjectTypeName(), String.format("Schema: %s", schemaName), databaseObject, databaseObject.getContainingObjects()));
            }
            values.add(new ReportObject(databaseObject.getObjectTypeName(), databaseObject.toString(), databaseObject, databaseObject.getContainingObjects()));
        }
        return values;
    }

    private List<ReportObject> populateDatabaseObjectReportValue(Map<? extends DatabaseObject, ObjectDifferences> objects) {
        ArrayList<ReportObject> values = new ArrayList<ReportObject>();
        if (objects.isEmpty()) {
            return values;
        }
        for (Map.Entry<? extends DatabaseObject, ObjectDifferences> object : objects.entrySet()) {
            if (!object.getValue().hasDifferences()) continue;
            for (Difference difference : object.getValue().getDifferences()) {
                String type = object.getKey().getObjectTypeName();
                values.add(new ReportObject(type, String.format("%s: %s", object.getKey(), difference.toString()), object.getKey(), object.getKey().getContainingObjects()));
            }
        }
        return values;
    }

    public String getSimpleTypeName(Class<? extends DatabaseObject> type) {
        return super.getTypeName(type).replace("(s)", "");
    }

    public List<ReportObjectContainer> getMissing() {
        return this.missing;
    }

    public List<ReportObjectContainer> getUnexpected() {
        return this.unexpected;
    }

    public List<ReportObjectContainer> getChanged() {
        return this.changed;
    }
}

