/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import java.util.Collections;
import java.util.List;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.AbstractArgumentCommandStep;

public class ChecksAutoUpdateArgument
extends AbstractArgumentCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checksAutoUpdateArgument"};
    private static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        commandScope.provideDependency(ChecksAutoUpdateArgument.class, commandScope.getArgumentValue(CHECKS_AUTO_UPDATE_ARG));
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(ChecksAutoUpdateArgument.class);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECKS_AUTO_UPDATE_ARG = builder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available, or for file format changes. Options: [on|off]").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String autoUpdateArg = (String)input;
            if (autoUpdateArg.equalsIgnoreCase("on") || autoUpdateArg.equalsIgnoreCase("off")) {
                return autoUpdateArg;
            }
            String messageString = "\nWARNING:  The autoUpdate value '" + autoUpdateArg + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException(messageString);
        }).build();
    }
}

