/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputModel;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputSerializer;
import com.datical.liquibase.ext.checks.output.FormattedChecksReportResultModel;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksResultModel;
import com.datical.liquibase.ext.command.ChecksRunReportGenerator;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksOutput;
import com.datical.liquibase.ext.command.checks.ChecksPackageNotFoundException;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper;
import com.datical.liquibase.ext.command.checks.ChecksRunJsonOutputHelper;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import com.datical.liquibase.ext.command.helpers.ChecksPackagesArgument;
import com.datical.liquibase.ext.parser.ExceptionSwallowingSqlParser;
import com.datical.liquibase.ext.reports.ChecksRunReportParameters;
import com.datical.liquibase.ext.reports.ReportArguments;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.RuleListener;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.ChangesetQualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.DatabaseQualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.stream.Collectors;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.database.core.H2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.exception.MissingRequiredArgumentException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.parser.SqlParserFactory;
import liquibase.plugin.Plugin;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;
import liquibase.util.ValueHandlerUtil;

public class ChecksRunCommandStep
extends AbstractChecksCommandStep {
    private boolean proLicenseValid;
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String[] COMMAND_NAME = new String[]{"checks", "run"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SCOPE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_OUTPUT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> SCHEMAS_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;
    public static final CommandArgumentDefinition<Boolean> VERBOSE_ARG;
    public static final CommandArgumentDefinition<Boolean> CACHE_CHANGELOG_FILE_CONTENTS;
    public static final CommandArgumentDefinition<String> LABELS_ARG;
    public static final CommandArgumentDefinition<String> CONTEXTS_ARG;
    public static final CommandArgumentDefinition<Boolean> CHECK_ROLLBACKS_ARG;
    public static final CommandArgumentDefinition<CheckSettingsConfig> CHECKS_SETTINGS_FILE_DTO;
    public static final CommandArgumentDefinition<String> CHECKS_OUTPUT_ARG;
    public static final CommandArgumentDefinition<Level> SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG;
    public static final CommandArgumentDefinition<Integer> SQL_PARSER_FAIL_SEVERITY;

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(ReportArguments.class, ChecksPackagesArgument.class, ChecksAutoUpdateArgument.class);
    }

    @Override
    public void validate(CommandScope commandScope) throws CommandValidationException {
        String changeLogFile = (String)commandScope.getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        String url = (String)commandScope.getConfiguredValue(URL_ARG).getValue();
        if (changeLogFile == null && url == null) {
            throw new CommandValidationException("changelogFile, url", "one is required for 'checks run'", (Throwable)new MissingRequiredArgumentException("--changelog-file, --url"));
        }
        String checksScope = (String)commandScope.getConfiguredValue(CHECKS_SCOPE_ARG).getValue();
        if (checksScope.toUpperCase().contains(ScopeEnum.CHANGELOG.toString()) && changeLogFile == null) {
            throw new CommandValidationException(CHECKS_SCOPE_ARG.getName(), "you must supply a changelogFile argument for changelog checks", (Throwable)new MissingRequiredArgumentException(CHECKS_SCOPE_ARG.getName()));
        }
        if (checksScope.toUpperCase().contains(ScopeEnum.DATABASE.toString()) && url == null) {
            throw new CommandValidationException(CHECKS_SCOPE_ARG.getName(), "you must supply a URL argument for database checks", (Throwable)new MissingRequiredArgumentException(CHECKS_SCOPE_ARG.getName()));
        }
        String checksOutputArg = (String)commandScope.getArgumentValue(CHECKS_OUTPUT_ARG);
        String format = (String)commandScope.getArgumentValue(CHECKS_OUTPUT_FORMAT_ARG);
        ChecksOutput.parseAndValidateArgumentsString(checksOutputArg, format);
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>(2);
        CommandScope commandScope = resultsBuilder.getCommandScope();
        props.put(CACHE_CHANGELOG_FILE_CONTENTS.getName(), commandScope.getConfiguredValue(CACHE_CHANGELOG_FILE_CONTENTS).getValue());
        if (this.isMavenIntegration(resultsBuilder)) {
            InMemoryChecksFileAccessor fileAccessor = new InMemoryChecksFileAccessor();
            props.put("fileAccessor", fileAccessor);
        }
        ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(ReportArguments.class);
        ChecksRunReportParameters checksRunReportParameters = new ChecksRunReportParameters();
        try {
            Scope.child(props, () -> this.doRun(resultsBuilder, checksRunReportParameters));
        }
        finally {
            new ChecksRunReportGenerator().run(checksRunReportParameters, reportArguments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRun(CommandResultsBuilder resultsBuilder, ChecksRunReportParameters checksRunReportParameters) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence(checksSettingsFile, "checks settings");
        String autoUpdate = (String)commandScope.getDependency(ChecksAutoUpdateArgument.class);
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate, checksRunReportParameters);
        String changeLogFile = (String)commandScope.getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        checksRunReportParameters.setChangelogArgValue(changeLogFile);
        ChecksRunCommandStep.checkFileArgExistence(changeLogFile, "changelog");
        String url = (String)commandScope.getArgumentValue(URL_ARG);
        checksRunReportParameters.setJdbcUrl(url);
        String sanitizedUrl = JdbcConnection.sanitizeUrl((String)url);
        String username = (String)commandScope.getArgumentValue(USERNAME_ARG);
        String password = (String)commandScope.getArgumentValue(PASSWORD_ARG);
        String defaultSchemaName = (String)commandScope.getArgumentValue(DEFAULT_SCHEMA_NAME_ARG);
        String defaultCatalogName = (String)commandScope.getArgumentValue(DEFAULT_CATALOG_NAME_ARG);
        String driver = (String)commandScope.getArgumentValue(DRIVER_ARG);
        String driverPropertiesFile = (String)commandScope.getArgumentValue(DRIVER_PROPERTIES_FILE_ARG);
        String schemas = (String)commandScope.getArgumentValue(SCHEMAS_ARG);
        Level sqlParserExceptionLogAtLevel = (Level)commandScope.getArgumentValue(SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG);
        Integer sqlParserFailSeverity = (Integer)commandScope.getArgumentValue(SQL_PARSER_FAIL_SEVERITY);
        String format = (String)commandScope.getArgumentValue(CHECKS_OUTPUT_FORMAT_ARG);
        String checksOutputArg = (String)commandScope.getArgumentValue(CHECKS_OUTPUT_ARG);
        LinkedHashSet<ChecksOutput> checksOutputs = ChecksOutput.parseAndValidateArgumentsString(checksOutputArg, format);
        SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
        ExceptionSwallowingSqlParser exceptionSwallowingSqlParser = new ExceptionSwallowingSqlParser();
        exceptionSwallowingSqlParser.setPriority(10);
        sqlParserFactory.register((Plugin)exceptionSwallowingSqlParser);
        String packages = (String)commandScope.getDependency(ChecksPackagesArgument.class);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = null;
        Database databaseForChecks = null;
        try {
            SeverityEnum maxSeverityEnum;
            String checksScope = (String)commandScope.getConfiguredValue(CHECKS_SCOPE_ARG).getValue();
            boolean scopeContainsDatabase = checksScope.toUpperCase().contains(ScopeEnum.DATABASE.toString());
            boolean scopeContainsChangelog = checksScope.toUpperCase().contains(ScopeEnum.CHANGELOG.toString());
            if (scopeContainsDatabase) {
                lazyDatabaseSnapshot = new LazyDatabaseSnapshot(url, username, password, defaultSchemaName, defaultCatalogName, schemas, driver, driverPropertiesFile, checksRunReportParameters);
                this.sendMessageToUi("Executing Quality Checks against database " + sanitizedUrl + System.lineSeparator());
                resultsBuilder.addResult("statusCode", (Object)0);
            }
            DatabaseChangeLog databaseChangeLog = null;
            if (changeLogFile != null && scopeContainsChangelog) {
                this.sendMessageToUi("Executing Quality Checks against " + changeLogFile + System.lineSeparator());
                ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
                ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(changeLogFile, resourceAccessor);
                try {
                    databaseChangeLog = parser.parse(changeLogFile, new ChangeLogParameters(), resourceAccessor);
                }
                catch (ChangeLogParseException cpe) {
                    String errorMessage = String.format("%nThe changelog file %s cannot be found or is not a valid changelog: %s%nCorrect this issue and try to run checks again.", changeLogFile, cpe.getMessage());
                    Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe(errorMessage);
                    Scope.getCurrentScope().getUI().sendMessage(errorMessage);
                    sqlParserFactory.unregister((LiquibaseSqlParser)exceptionSwallowingSqlParser);
                    try {
                        if (lazyDatabaseSnapshot != null) {
                            lazyDatabaseSnapshot.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (databaseForChecks != null) {
                            databaseForChecks.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
            }
            String checkNameToRunList = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue();
            List<AbstractLiquibaseRule> instances = ChecksRunCommandStep.listAllRules();
            CheckSettingsConfig config = (CheckSettingsConfig)commandScope.getArgumentValue(CHECKS_SETTINGS_FILE_DTO);
            if (config == null) {
                try {
                    config = helper.read(instances, packages);
                }
                catch (Exception e) {
                    if (e.getCause() instanceof FileAlreadyExistsException || e instanceof ChecksPackageNotFoundException) {
                        throw e;
                    }
                    throw new CommandExecutionException(CheckSettingsConfigHelper.generateInvalidChecksExceptionMessage(checksSettingsFile), (Throwable)e);
                }
            }
            if (config == null) {
                resultsBuilder.addResult("statusCode", (Object)0);
                return;
            }
            checksRunReportParameters.getOperationInfo().setTotalChecks(config.getRules().size());
            List<AbstractConfigurableRule> rulesToRun = ChecksRunCommandStep.determineRulesToRun(config, checkNameToRunList);
            checksRunReportParameters.getOperationInfo().setChecksRun(rulesToRun.size());
            this.printLicensingMessages(instances, rulesToRun, checkNameToRunList, scopeContainsChangelog, scopeContainsDatabase);
            EngineResults<ChangeSet> results = new EngineResults<ChangeSet>(config.getResources());
            if (databaseChangeLog != null) {
                Contexts contexts = new Contexts((String)commandScope.getArgumentValue(CONTEXTS_ARG));
                LabelExpression labelExpression = new LabelExpression((String)commandScope.getArgumentValue(LABELS_ARG));
                ChangeLogIterator cli = new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{new ContextChangeSetFilter(contexts), new LabelChangeSetFilter(labelExpression)});
                ListVisitor visitor = new ListVisitor();
                databaseForChecks = this.getDatabaseForChecks(url, sanitizedUrl, username, password, defaultSchemaName, defaultCatalogName, driver, driverPropertiesFile, checksRunReportParameters);
                cli.run((ChangeSetVisitor)visitor, new RuntimeEnvironment(databaseForChecks, contexts, labelExpression));
                boolean checkRollbacks = (Boolean)commandScope.getArgumentValue(CHECK_ROLLBACKS_ARG);
                List seenChangeSets = visitor.getSeenChangeSets();
                checksRunReportParameters.getOperationInfo().setChangesetsChecked(seenChangeSets.size());
                checksRunReportParameters.getOperationInfo().setTotalChangesets(databaseChangeLog.getChangeSets().size());
                results = this.runChecks(instances, seenChangeSets, databaseForChecks, rulesToRun, checkRollbacks, sqlParserExceptionLogAtLevel, config);
            }
            EngineResults<DatabaseObject> databaseResults = this.runDatabaseChecks(instances, lazyDatabaseSnapshot, rulesToRun, config);
            if (lazyDatabaseSnapshot != null && lazyDatabaseSnapshot.isAttempted()) {
                resultsBuilder.addResult("snapshot", (Object)lazyDatabaseSnapshot.getSnapshot());
            }
            boolean verbose = (Boolean)commandScope.getConfiguredValue(VERBOSE_ARG).getValue();
            String integration = (String)commandScope.getConfiguredValue(CHECKS_INTEGRATION_ARG).getValue();
            if (ChecksRunCommandStep.isJsonOutput(format)) {
                StringBuilder builder = new StringBuilder();
                FormattedChecksOutputModel checksOutputModel = new FormattedChecksOutputModel();
                checksOutputModel.checksRun = new Date().toString();
                Result result = ChecksRunCommandStep.generateJsonModel(checksOutputModel, changeLogFile, results, integration, config, instances, sqlParserFailSeverity, lazyDatabaseSnapshot, databaseResults, url, verbose);
                String output = new FormattedChecksOutputSerializer().serialize((LiquibaseSerializable)checksOutputModel, true);
                output = output.replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
                builder.append(output);
                maxSeverityEnum = result.changelogMaxSeverity.getValue() > result.databaseMaxSeverity.getValue() ? result.changelogMaxSeverity : result.databaseMaxSeverity;
                resultsBuilder.getOutputStream().write(builder.toString().getBytes(StandardCharsets.UTF_8));
            } else {
                maxSeverityEnum = ChecksRunConsoleOutputHelper.outputChecksResults(resultsBuilder, results, databaseResults, lazyDatabaseSnapshot, url, verbose, instances, scopeContainsDatabase, checksOutputs, sqlParserFailSeverity, checksRunReportParameters);
            }
            if (this.proLicenseValid) {
                this.addResultsToMdc(changeLogFile, results, integration, config, instances, sqlParserFailSeverity, lazyDatabaseSnapshot, databaseResults, url);
            }
            if (!ChecksRunCommandStep.isJsonOutput(format)) {
                this.sendMessage(resultsBuilder, config.getUnrecognizedRulesWarningMessage());
            }
            resultsBuilder.getOutputStream().flush();
            int exitCode = maxSeverityEnum.getExitValue();
            checksRunReportParameters.getOperationInfo().setReturnCode(exitCode);
            checksRunReportParameters.getOperationInfo().setOperationOutcome("success");
            if (exitCode != 0) {
                checksRunReportParameters.getOperationInfo().setOperationOutcome("fail");
                resultsBuilder.addResult("statusCode", (Object)exitCode);
                throw resultsBuilder.commandFailed("Checks run command exited with error code of " + exitCode, exitCode, true);
            }
            config.outputWarningMessage();
            resultsBuilder.addResult("statusCode", (Object)0);
        }
        finally {
            sqlParserFactory.unregister((LiquibaseSqlParser)exceptionSwallowingSqlParser);
            try {
                if (lazyDatabaseSnapshot != null) {
                    lazyDatabaseSnapshot.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (databaseForChecks != null) {
                    databaseForChecks.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void addResultsToMdc(String changeLogFile, EngineResults<ChangeSet> results, String integration, CheckSettingsConfig config, List<AbstractLiquibaseRule> instances, Integer sqlParserFailSeverity, LazyDatabaseSnapshot lazyDatabaseSnapshot, EngineResults<DatabaseObject> databaseResults, String url) {
        FormattedChecksOutputModel checksOutputModel = new FormattedChecksOutputModel();
        ChecksRunCommandStep.generateJsonModel(checksOutputModel, changeLogFile, results, integration, config, instances, sqlParserFailSeverity, lazyDatabaseSnapshot, databaseResults, url, true);
        Scope.getCurrentScope().addMdcValue("qualityChecks", (CustomMdcObject)checksOutputModel.checksReport.get(0));
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Generated JSON report");
    }

    private static Result generateJsonModel(FormattedChecksOutputModel checksOutputModel, String changeLogFile, EngineResults<ChangeSet> results, String integration, CheckSettingsConfig config, List<AbstractLiquibaseRule> instances, Integer sqlParserFailSeverity, LazyDatabaseSnapshot lazyDatabaseSnapshot, EngineResults<DatabaseObject> databaseResults, String url, boolean verbose) {
        FormattedChecksReportResultModel checksReportResultModel = new FormattedChecksReportResultModel();
        checksOutputModel.checksReport.add(checksReportResultModel);
        FormattedChangelogChecksResultModel changelogChecksResultModel = null;
        FormattedDatabaseChecksResultModel databaseChecksResultModel = null;
        SeverityEnum changelogMaxSeverity = SeverityEnum.INFO;
        SeverityEnum databaseMaxSeverity = SeverityEnum.INFO;
        if (changeLogFile != null) {
            changelogChecksResultModel = ChecksRunJsonOutputHelper.createChangelogJsonOutput(results.getResults(), results.getExecutedRules(), changeLogFile, integration, config, results.getSkippedBecauseOfLicenceRules(), instances, sqlParserFailSeverity);
            changelogMaxSeverity = changelogChecksResultModel.maxSeverity;
            checksReportResultModel.changelogChecks.add(changelogChecksResultModel);
        }
        if (lazyDatabaseSnapshot != null && lazyDatabaseSnapshot.isAttempted() || !databaseResults.getSkippedBecauseOfLicenceRules().isEmpty()) {
            databaseChecksResultModel = ChecksRunJsonOutputHelper.createDatabaseJsonOutput(databaseResults, url, lazyDatabaseSnapshot, verbose, integration, config, sqlParserFailSeverity);
            databaseMaxSeverity = databaseChecksResultModel.maxSeverity;
            checksReportResultModel.databaseChecks.add(databaseChecksResultModel);
        }
        return new Result(changelogMaxSeverity, databaseMaxSeverity);
    }

    private Database getDatabaseForChecks(String url, String sanitizedUrl, String username, String password, String defaultSchemaName, String defaultCatalogName, String driver, String driverPropertiesFile, ChecksRunReportParameters checksRunReportParameters) {
        H2Database databaseForChecks;
        if (url != null) {
            try {
                databaseForChecks = LazyDatabaseSnapshot.createDatabaseObject(url, username, password, defaultSchemaName, defaultCatalogName, driver, driverPropertiesFile);
                if (databaseForChecks.getConnection() instanceof OfflineConnection) {
                    this.sendMessageToUi("INFO: Snapshot database specified. Checks executed against H2 generated SQL, which may not contain certain objects.");
                    databaseForChecks = new H2Database();
                } else {
                    this.sendMessageToUi("INFO: Checks executed against SQL generated by " + databaseForChecks.getConnection().getDatabaseProductName() + " at " + sanitizedUrl + ".");
                }
                checksRunReportParameters.getDatabaseInfo().setDatabaseType(databaseForChecks.getDatabaseProductName());
                checksRunReportParameters.getDatabaseInfo().setVersion(databaseForChecks.getDatabaseProductVersion());
            }
            catch (Exception e) {
                String msg = "WARNING: Unable to connect to database " + sanitizedUrl + ". Checks executed against H2 generated SQL, which may not contain certain objects.";
                this.sendMessageToUi(msg);
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(msg, (Throwable)e);
                databaseForChecks = new H2Database();
            }
        } else {
            this.sendMessageToUi("INFO: No database specified. Checks executed against H2 generated SQL, which may not contain certain objects.");
            databaseForChecks = new H2Database();
        }
        return databaseForChecks;
    }

    private void printLicensingMessages(List<AbstractLiquibaseRule> instances, List<AbstractConfigurableRule> rulesToRun, String checkNameToRunList, boolean scopeContainsChangelog, boolean scopeContainsDatabase) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        int daysTilExpiration = licenseService.daysTilExpiration();
        this.proLicenseValid = LicenseServiceUtils.isProLicenseValid();
        SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        List checkNamesToRun = rulesToRun.stream().filter(rule -> {
            Optional<AbstractLiquibaseRule> parentRule = rule.findParentRule(instances);
            if (!parentRule.isPresent()) {
                return false;
            }
            if (scopeContainsChangelog && !parentRule.get().getScope().contains((Object)ScopeEnum.CHANGELOG)) {
                return false;
            }
            if (scopeContainsDatabase && !parentRule.get().getScope().contains((Object)ScopeEnum.DATABASE)) {
                return false;
            }
            return parentRule.get().getScope().contains((Object)ScopeEnum.CHANGELOG);
        }).map(rule -> rule.getShortName(instances)).collect(Collectors.toList());
        boolean accidentallySkippedDatabaseChecks = rulesToRun.stream().anyMatch(rule -> rule.findParentRule(instances).isPresent() && rule.findParentRule(instances).get().getScope().contains((Object)ScopeEnum.DATABASE) && !scopeContainsDatabase);
        boolean runAllChecks = StringUtil.isEmpty((String)checkNameToRunList);
        if (daysTilExpiration > 0) {
            if (scopeContainsChangelog && scopeContainsDatabase) {
                if (runAllChecks) {
                    this.sendMessageToUi("Executing all changelog and database checks because a valid license key was found!" + System.lineSeparator());
                } else if (!checkNamesToRun.isEmpty()) {
                    this.sendMessageToUi("Executing specified changelog and database checks: '" + StringUtil.join(checkNamesToRun, (String)"', '") + "'");
                }
            } else if (this.proLicenseValid && scopeContainsChangelog) {
                if (runAllChecks) {
                    this.sendMessageToUi("Executing all changelog checks because a valid license key was found!" + System.lineSeparator());
                } else if (!checkNamesToRun.isEmpty()) {
                    this.sendMessageToUi("Executing specified changelog checks: '" + StringUtil.join(checkNamesToRun, (String)"', '") + "'");
                }
            } else if (scopeContainsDatabase) {
                if (runAllChecks) {
                    this.sendMessageToUi("Executing all database checks because a valid license key was found!" + System.lineSeparator());
                } else if (!checkNamesToRun.isEmpty()) {
                    this.sendMessageToUi("Executing specified database checks: '" + StringUtil.join(checkNamesToRun, (String)"', '") + "'");
                }
            }
            if (accidentallySkippedDatabaseChecks) {
                this.sendMessageToUi("WARNING: No database checks were run. Make sure the checks-scope property includes \"database\" to run database checks. In the CLI set --checks-scope=\"changelog,database\" or set an environment variable LIQUIBASE_COMMAND_CHECKS_SCOPE=database. Learn more at https://docs.liquibase.com/quality-checks" + System.lineSeparator());
            }
            if (daysTilExpiration <= 7) {
                this.sendMessageToUi("WARNING: Liquibase license key will expire on " + dateFormat.format(licenseService.getExpirationDate()) + ". You will lose access access to unlimited changelog and database checks providing quality assurance and compliance.\nContact Support or Sales, or buy online at https://liquibase.com/pricing");
            }
            if (!this.proLicenseValid) {
                this.sendMessageToUi("No valid Liquibase license key detected!" + System.lineSeparator() + "Unlock unlimited checks with Pro license Key." + System.lineSeparator() + "Free trial key at " + "https://liquibase.com/trial" + System.lineSeparator());
            }
        } else {
            this.sendMessageToUi("WARNING: Liquibase license key expired on " + dateFormat.format(licenseService.getExpirationDate()) + ". To regain access to unlimited changelog and database checks providing quality assurance and compliance, contact Support or Sales, or buy online at https://liquibase.com/pricing" + System.lineSeparator());
        }
    }

    public static boolean isJsonOutput(String format) {
        return format.equalsIgnoreCase(CHECKS_RUN_OUTPUT_FORMAT.JSON.name());
    }

    private static boolean validateOutputFormat(String formatString) {
        for (CHECKS_RUN_OUTPUT_FORMAT formatElement : CHECKS_RUN_OUTPUT_FORMAT.values()) {
            if (!formatElement.toString().equalsIgnoreCase(formatString)) continue;
            return true;
        }
        return false;
    }

    private void sendMessageToUi(String message) {
        Scope.getCurrentScope().getUI().sendMessage(message);
    }

    private void sendMessage(CommandResultsBuilder resultsBuilder, String message) throws IOException {
        resultsBuilder.getOutputStream().write(message.getBytes());
    }

    private static boolean validChecksScope(String checksScope) {
        String[] split = checksScope.split(",");
        return Arrays.stream(split).allMatch(sp -> Arrays.stream(ScopeEnum.values()).anyMatch(scopeEnum -> sp.trim().equalsIgnoreCase(scopeEnum.toString())));
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Check the changelog or database for issues");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private EngineResults<ChangeSet> runChecks(List<AbstractLiquibaseRule> instances, List<ChangeSet> changeSets, Database database, List<AbstractConfigurableRule> configurableRules, boolean checkRollbacks, Level sqlParserExceptionLogAtLevel, CheckSettingsConfig config) throws Exception {
        if (configurableRules != null) {
            return (EngineResults)Scope.child(Collections.singletonMap(SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG.getName(), sqlParserExceptionLogAtLevel), () -> this.runCheck(instances, changeSets, database, configurableRules, checkRollbacks, config));
        }
        return new EngineResults<ChangeSet>(config.getResources());
    }

    private EngineResults<DatabaseObject> runDatabaseChecks(List<AbstractLiquibaseRule> instances, LazyDatabaseSnapshot snapshot, List<AbstractConfigurableRule> rulesToRun, CheckSettingsConfig config) {
        if (rulesToRun != null) {
            return this.runDatabaseCheck(instances, snapshot, rulesToRun, config);
        }
        return new EngineResults<DatabaseObject>(config.getResources());
    }

    private EngineResults<DatabaseObject> runDatabaseCheck(List<AbstractLiquibaseRule> instances, LazyDatabaseSnapshot snapshot, List<AbstractConfigurableRule> rulesToRun, CheckSettingsConfig config) {
        Facts facts = new Facts();
        if (snapshot != null) {
            facts.put(FactEnum.DATABASE_SNAPSHOT.toString(), snapshot);
        }
        Rules rules = new Rules(instances.toArray());
        DatabaseQualityChecksRulesEngine engine = new DatabaseQualityChecksRulesEngine(rulesToRun);
        engine.fire(rules, facts);
        Map results = engine.getResults();
        List<RuleCombination> skippedBecauseOfLicenceRules = engine.getSkippedRules();
        LinkedHashMap returnResults = new LinkedHashMap(results.size());
        for (Map.Entry stringListEntry : results.entrySet()) {
            returnResults.put(stringListEntry.getKey(), new LiquibaseQualityCheckResult(stringListEntry.getValue(), null, null, engine.getExecutedRules(), null));
        }
        return new EngineResults<DatabaseObject>(skippedBecauseOfLicenceRules, returnResults, config.getResources());
    }

    private EngineResults<ChangeSet> runCheck(List<AbstractLiquibaseRule> instances, List<ChangeSet> changeSet, Database database, List<AbstractConfigurableRule> configurableRules, boolean checkRollbacks, CheckSettingsConfig config) {
        Facts facts = new Facts();
        facts.put(FactEnum.CHANGESETS.toString(), changeSet);
        facts.put(FactEnum.DATABASE.toString(), database);
        facts.put(FactEnum.CHECK_ROLLBACKS.toString(), checkRollbacks);
        Rules rules = new Rules(instances.toArray());
        ChangesetQualityChecksRulesEngine engine = new ChangesetQualityChecksRulesEngine(configurableRules);
        engine.registerRuleListener(new RuleListener(){

            @Override
            public boolean beforeEvaluate(Rule rule, Facts facts) {
                if (rule instanceof AbstractLiquibaseRule) {
                    List<ChangeSet> changeSetFromFacts = ((AbstractLiquibaseRule)rule).getChangeSetFromFacts(facts);
                    AbstractConfigurableRule configurableRule = ((AbstractLiquibaseRule)rule).getAbstractConfigurableRuleFromFacts(facts);
                    return changeSetFromFacts.stream().anyMatch(changeSet1 -> ((AbstractLiquibaseRule)rule).shouldBeEvaluated((ChangeSet)changeSet1, configurableRule));
                }
                return true;
            }
        });
        engine.fire(rules, facts);
        List<RuleCombination> skippedBecauseOfLicenceRules = engine.getSkippedRules();
        LinkedHashMap compiledResults = new LinkedHashMap(changeSet.size());
        for (Map.Entry changeSetLiquibaseRuleResultEntry : engine.getResults().entrySet()) {
            List<LiquibaseRuleResult> ruleResults = changeSetLiquibaseRuleResultEntry.getValue();
            AtomicBoolean foundRuleWithUnparseableSql = new AtomicBoolean(false);
            List<LiquibaseRuleResult> executedRuleResults = ruleResults.stream().filter(rr -> {
                if (rr.hasSqlParseFailures()) {
                    return !foundRuleWithUnparseableSql.getAndSet(true);
                }
                return true;
            }).collect(Collectors.toList());
            List<LiquibaseRuleResult> rulesSkippedDueToUnparseableSql = ruleResults.stream().filter(LiquibaseRuleResult::hasSqlParseFailures).skip(1L).collect(Collectors.toList());
            List<String> ruleNamesSkippedDueToUnparseableSql = rulesSkippedDueToUnparseableSql.stream().map(rr -> this.getSkippedRuleName(rr.getRule(), rr.getConfigurableRule())).collect(Collectors.toList());
            List<LiquibaseRuleResult> invalidChangelogFileTypeFailures = ruleResults.stream().filter(LiquibaseRuleResult::hasInvalidChangelogFileTypeFailures).filter(liquibaseRuleResult -> {
                String executedRuleShortName = liquibaseRuleResult.getRuleShortName(false);
                Optional<AbstractConfigurableRule> configurableRuleOptional = configurableRules.stream().filter(cr -> cr.getShortName(instances).equals(executedRuleShortName)).findFirst();
                return configurableRuleOptional.map(AbstractConfigurableRule::isEnabled).orElse(false);
            }).collect(Collectors.toList());
            List<RuleCombination> executedRules = engine.getExecutedRules().stream().filter(rule -> !ruleNamesSkippedDueToUnparseableSql.contains(this.getSkippedRuleName((AbstractLiquibaseRule)rule.rule, rule.configurableRule))).collect(Collectors.toList());
            compiledResults.put(changeSetLiquibaseRuleResultEntry.getKey(), new LiquibaseQualityCheckResult(executedRuleResults, rulesSkippedDueToUnparseableSql, ruleNamesSkippedDueToUnparseableSql, executedRules, invalidChangelogFileTypeFailures));
        }
        return new EngineResults<ChangeSet>(skippedBecauseOfLicenceRules, compiledResults, config.getResources());
    }

    private String getSkippedRuleName(AbstractLiquibaseRule rule, AbstractConfigurableRule ruleConfiguration) {
        if (ruleConfiguration instanceof DynamicRule) {
            return ((DynamicRule)ruleConfiguration).getShortName();
        }
        return rule.getShortName() != null ? rule.getShortName() : rule.getName();
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = builder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to a Liquibase changelog file.  One of --changelog-file or --url is required.").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_SCOPE_ARG = builder.argument("checksScope", String.class).defaultValue((Object)ScopeEnum.CHANGELOG.toString().toLowerCase()).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String checksScopeString = (String)input;
            boolean found = ChecksRunCommandStep.validChecksScope(checksScopeString);
            if (!found) {
                String messageString = "\nWARNING:  Check scope value '" + checksScopeString + "' is not valid.  Valid check scope values include: " + StringUtil.join((Object[])ScopeEnum.values(), (String)", ", obj -> obj.toString().toLowerCase());
                throw new IllegalArgumentException(messageString);
            }
            return checksScopeString;
        }).description("The Liquibase component to run checks against, which can be a comma separated list of the following options: '" + StringUtil.join((Object[])ScopeEnum.values(), (String)"', '", (StringUtil.StringUtilFormatter)new StringUtil.ToStringFormatter(true)) + "'").build();
        CHECKS_OUTPUT_FORMAT_ARG = builder.argument("format", String.class).defaultValue((Object)CHECKS_RUN_OUTPUT_FORMAT.TXT.name()).description(ProStringUtil.markWithPro("Option to create JSON output")).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String formatArg = String.valueOf(input);
            boolean found = ChecksRunCommandStep.validateOutputFormat(formatArg);
            if (!found) {
                String messageString = "\nWARNING:  The format value '" + formatArg + "' is not valid.  Valid values include: 'json' or 'txt'";
                throw new IllegalArgumentException(messageString);
            }
            if (formatArg.equalsIgnoreCase("json")) {
                if (!LicenseServiceUtils.isProLicenseValid()) {
                    String warningAboutCommand = "checks run --format=" + formatArg;
                    String messageString = String.format(coreBundle.getString("no.pro.license.found"), warningAboutCommand);
                    throw new IllegalArgumentException(messageString);
                }
                return CHECKS_RUN_OUTPUT_FORMAT.JSON.name();
            }
            return CHECKS_RUN_OUTPUT_FORMAT.TXT.name();
        }).build();
        CHECKS_INTEGRATION_ARG = builder.argument("checksIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing checks run").build();
        CHECK_NAME_ARG = builder.argument("checkName", String.class).description("Comma-separated list of one or more enabled checks to run. Checks to exclude can be prefixed with the ! character. If no checks are specified, all enabled checks will run. Example: --check-name=shortname1,shortname2,!shortname3").build();
        URL_ARG = builder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL.  One of --changelog-file or --url is required.").build();
        SCHEMAS_ARG = builder.argument("schemas", String.class).description("The schemas to check when checks-scope contains 'database'").build();
        DEFAULT_SCHEMA_NAME_ARG = builder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = builder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = builder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = builder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = builder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = builder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        VERBOSE_ARG = builder.argument("verbose", Boolean.class).defaultValue((Object)false).setValueHandler(ValueHandlerUtil::booleanValueHandler).description("Verbose flag with optional values of 'True' or 'False'. The default is 'False'.").build();
        CACHE_CHANGELOG_FILE_CONTENTS = builder.argument("cacheChangelogFileContents", Boolean.class).description("If true, sqlFile change type contents will be cached in memory to improve performance, at the cost of higher memory usage. To reduce memory usage, set this to false.").defaultValue((Object)true).build();
        LABELS_ARG = builder.argument("labelFilter", String.class).addAlias("labels").description("Changeset labels to match").build();
        CONTEXTS_ARG = builder.argument("contextFilter", String.class).addAlias("contexts").description("Changeset contexts to match").build();
        CHECK_ROLLBACKS_ARG = builder.argument("checkRollbacks", Boolean.class).addAlias("checkRollback").defaultValue((Object)false).setValueHandler(ValueHandlerUtil::booleanValueHandler).description("Allow changeset's rollback code to be analyzed for compliance with currently enabled quality checks.").build();
        CHECKS_SETTINGS_FILE_DTO = builder.argument("checksSettingsFileDto", CheckSettingsConfig.class).description("An already loaded CheckSettingsConfig object").hidden().build();
        CHECKS_OUTPUT_ARG = builder.argument("checksOutput", String.class).description("Specify which parts of the checks run output should be shown; options: " + StringUtil.join((Object[])ChecksOutput.values(), (String)", ", Object::toString)).defaultValue((Object)ChecksOutput.all.toString()).build();
        SQL_PARSE_EXCEPTION_LOG_AT_LEVEL_ARG = builder.argument("sqlParserExceptionLogAtLevel", Level.class).description("The log level that SQL parser exceptions should be logged at").defaultValue((Object)Level.FINE).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            return Level.parse(input.toString().toUpperCase());
        }).hidden().build();
        SQL_PARSER_FAIL_SEVERITY = builder.argument("sqlParserFailSeverity", Integer.class).description("The severity that a check which fails due to a SQL parse error will exit with. If not set, use the severity of the configured check. Available values are: " + StringUtil.join((int[])Arrays.stream(SeverityEnum.values()).mapToInt(SeverityEnum::getExitValue).sorted().toArray(), (String)", ")).setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            Integer severity = Integer.valueOf(String.valueOf(input));
            boolean anyMatch = Arrays.stream(SeverityEnum.values()).anyMatch(se -> se.getExitValue() == severity.intValue());
            if (!anyMatch) {
                throw new IllegalArgumentException("The sqlParserFailSeverity must be set to either null (the default value) or one of the allowed values: " + StringUtil.join((int[])Arrays.stream(SeverityEnum.values()).mapToInt(SeverityEnum::getExitValue).sorted().toArray(), (String)", "));
            }
            return severity;
        }).build();
    }

    private static class Result {
        public final SeverityEnum changelogMaxSeverity;
        public final SeverityEnum databaseMaxSeverity;

        public Result(SeverityEnum changelogMaxSeverity, SeverityEnum databaseMaxSeverity) {
            this.changelogMaxSeverity = changelogMaxSeverity;
            this.databaseMaxSeverity = databaseMaxSeverity;
        }
    }

    public static enum CHECKS_RUN_OUTPUT_FORMAT {
        JSON,
        TXT;

    }
}

