/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.InternalRollbackOnErrorCommandStep;
import com.datical.liquibase.ext.command.UpdateReportGenerator;
import com.datical.liquibase.ext.command.helpers.RollbackOnErrorArgument;
import com.datical.liquibase.ext.command.helpers.VisibleReportCommandArguments;
import com.datical.liquibase.ext.reports.ReportArguments;
import java.util.ArrayList;
import java.util.List;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.command.CommandOverride;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.UpdateCountCommandStep;
import liquibase.database.Database;
import liquibase.report.UpdateReportParameters;

@CommandOverride(override=UpdateCountCommandStep.class)
public class ProUpdateCountCommandStep
extends UpdateCountCommandStep {
    public String[][] defineCommandNames() {
        return new String[][]{UpdateCountCommandStep.COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        ArrayList deps = new ArrayList(super.requiredDependencies());
        deps.add(RollbackOnErrorArgument.class);
        deps.add(VisibleReportCommandArguments.class);
        return deps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Boolean rollbackOnError = (Boolean)commandScope.getDependency(RollbackOnErrorArgument.class);
        ReportArguments reportArguments = (ReportArguments)commandScope.getDependency(VisibleReportCommandArguments.class);
        try {
            super.run(resultsBuilder);
        }
        catch (Exception exception) {
            InternalRollbackOnErrorCommandStep.executeCommand((Database)commandScope.getDependency(Database.class), (DefaultChangeExecListener)resultsBuilder.getResult("defaultChangeExecListener"), exception, rollbackOnError, (UpdateReportParameters)resultsBuilder.getResult("updateReport"));
        }
        finally {
            new UpdateReportGenerator().run(resultsBuilder, reportArguments);
        }
    }
}

