/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import liquibase.resource.AbstractResource;
import liquibase.resource.OpenOptions;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;

public class InMemoryChecksFileResourceAccessor
extends SearchPathResourceAccessor {
    private InMemoryChecksFileAccessor accessor;

    public InMemoryChecksFileResourceAccessor(InMemoryChecksFileAccessor accessor) {
        super(new ResourceAccessor[0]);
        this.accessor = accessor;
    }

    public Resource get(String path) throws IOException {
        if (this.accessor.exists(path)) {
            URI uri = null;
            try {
                uri = new URI(path);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new InMemoryChecksFileResource(path, uri, this.accessor);
        }
        return super.get(path);
    }

    private static class InMemoryChecksFileResource
    extends AbstractResource {
        private InMemoryChecksFileAccessor accessor;

        public InMemoryChecksFileResource() {
            super(null, null);
        }

        public InMemoryChecksFileResource(String path, URI uri, InMemoryChecksFileAccessor accessor) {
            super(path, uri);
            this.accessor = accessor;
        }

        public OutputStream openOutputStream(OpenOptions openOptions) throws IOException {
            return new ByteArrayOutputStream();
        }

        public boolean isWritable() {
            return true;
        }

        public InputStream openInputStream() throws IOException {
            return null;
        }

        public boolean exists() {
            return this.accessor.exists(this.getPath());
        }

        public Resource resolve(String other) {
            return null;
        }

        public Resource resolveSibling(String other) {
            URI uri = null;
            try {
                uri = new URI(this.getPath());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return new InMemoryChecksFileResource(this.resolveSiblingPath(other), uri, this.accessor);
        }
    }
}

