/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import liquibase.changelog.ChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;

public class ChangeSetAuthorFilter
implements ChangeSetFilter {
    private final String author;

    public ChangeSetAuthorFilter(String author) {
        this.author = author;
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String changeSetString = changeSet.toString();
        if (this.author.endsWith("*")) {
            String prefix = this.author.substring(0, this.author.length() - 1);
            if (changeSet.getAuthor().startsWith(prefix)) {
                return new ChangeSetFilterResult(true, "Changeset to run is " + changeSetString, this.getClass(), this.getMdcName(), this.getDisplayName());
            }
            return new ChangeSetFilterResult(false, String.format("Changeset '%s' will not execute because author '%s' does not match prefix '%s'", changeSetString, changeSet.getAuthor(), prefix), this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        if (this.author.equalsIgnoreCase(changeSet.getAuthor())) {
            return new ChangeSetFilterResult(true, "Changeset to run is " + changeSetString, this.getClass(), this.getMdcName(), this.getDisplayName());
        }
        return new ChangeSetFilterResult(false, String.format("Changeset '%s' will not execute because author '%s' does not match '%s'", changeSetString, changeSet.getAuthor(), this.author), this.getClass(), this.getMdcName(), this.getDisplayName());
    }
}

