/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression;

import java.util.List;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.AnalyticType;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.Function;
import liquibase.repackaged.net.sf.jsqlparser.expression.KeepExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowDefinition;
import liquibase.repackaged.net.sf.jsqlparser.expression.WindowElement;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;

public class AnalyticExpression
extends ASTNodeAccessImpl
implements Expression {
    private String name;
    private Expression expression;
    private Expression offset;
    private Expression defaultValue;
    private boolean allColumns = false;
    private KeepExpression keep = null;
    private AnalyticType type = AnalyticType.OVER;
    private boolean distinct = false;
    private boolean unique = false;
    private boolean ignoreNulls = false;
    private boolean ignoreNullsOutside = false;
    private Expression filterExpression = null;
    private List<OrderByElement> funcOrderBy = null;
    private String windowName = null;
    private WindowDefinition windowDef = new WindowDefinition();

    public AnalyticExpression() {
    }

    public AnalyticExpression(Function function) {
        this.name = function.getName();
        this.allColumns = function.isAllColumns();
        this.distinct = function.isDistinct();
        this.unique = function.isUnique();
        this.funcOrderBy = function.getOrderByElements();
        ExpressionList expressionList = function.getParameters();
        if (expressionList != null) {
            if (expressionList.getExpressions().size() > 3) {
                throw new IllegalArgumentException("function object not valid to initialize analytic expression");
            }
            this.expression = expressionList.getExpressions().get(0);
            if (expressionList.getExpressions().size() > 1) {
                this.offset = expressionList.getExpressions().get(1);
            }
            if (expressionList.getExpressions().size() > 2) {
                this.defaultValue = expressionList.getExpressions().get(2);
            }
        }
        this.ignoreNulls = function.isIgnoreNulls();
        this.keep = function.getKeep();
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.windowDef.orderBy.getOrderByElements();
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.windowDef.orderBy.setOrderByElements(list);
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keepExpression) {
        this.keep = keepExpression;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.windowDef.partitionBy.getPartitionExpressionList();
    }

    public void setPartitionExpressionList(ExpressionList expressionList) {
        this.setPartitionExpressionList(expressionList, false);
    }

    public void setPartitionExpressionList(ExpressionList expressionList, boolean bl2) {
        this.windowDef.partitionBy.setPartitionExpressionList(expressionList, bl2);
    }

    public boolean isPartitionByBrackets() {
        return this.windowDef.partitionBy.isBrackets();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Expression getOffset() {
        return this.offset;
    }

    public void setOffset(Expression expression) {
        this.offset = expression;
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Expression expression) {
        this.defaultValue = expression;
    }

    public WindowElement getWindowElement() {
        return this.windowDef.windowElement;
    }

    public void setWindowElement(WindowElement windowElement) {
        this.windowDef.windowElement = windowElement;
    }

    public AnalyticType getType() {
        return this.type;
    }

    public void setType(AnalyticType analyticType) {
        this.type = analyticType;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean bl2) {
        this.distinct = bl2;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean bl2) {
        this.unique = bl2;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean bl2) {
        this.ignoreNulls = bl2;
    }

    public boolean isIgnoreNullsOutside() {
        return this.ignoreNullsOutside;
    }

    public void setIgnoreNullsOutside(boolean bl2) {
        this.ignoreNullsOutside = bl2;
    }

    public String getWindowName() {
        return this.windowName;
    }

    public void setWindowName(String string) {
        this.windowName = string;
    }

    public WindowDefinition getWindowDefinition() {
        return this.windowDef;
    }

    public void setWindowDefinition(WindowDefinition windowDefinition) {
        this.windowDef = windowDefinition;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("(");
        if (this.isDistinct()) {
            stringBuilder.append("DISTINCT ");
        }
        if (this.expression != null) {
            stringBuilder.append(this.expression.toString());
            if (this.offset != null) {
                stringBuilder.append(", ").append(this.offset.toString());
                if (this.defaultValue != null) {
                    stringBuilder.append(", ").append(this.defaultValue.toString());
                }
            }
        } else if (this.isAllColumns()) {
            stringBuilder.append("*");
        }
        if (this.isIgnoreNulls()) {
            stringBuilder.append(" IGNORE NULLS");
        }
        if (this.funcOrderBy != null) {
            stringBuilder.append(" ORDER BY ");
            stringBuilder.append(this.funcOrderBy.stream().map(OrderByElement::toString).collect(Collectors.joining(", ")));
        }
        stringBuilder.append(") ");
        if (this.keep != null) {
            stringBuilder.append(this.keep.toString()).append(" ");
        }
        if (this.filterExpression != null) {
            stringBuilder.append("FILTER (WHERE ");
            stringBuilder.append(this.filterExpression.toString());
            stringBuilder.append(")");
            if (this.type != AnalyticType.FILTER_ONLY) {
                stringBuilder.append(" ");
            }
        }
        if (this.isIgnoreNullsOutside()) {
            stringBuilder.append("IGNORE NULLS ");
        }
        switch (this.type) {
            case FILTER_ONLY: {
                return stringBuilder.toString();
            }
            case WITHIN_GROUP: {
                stringBuilder.append("WITHIN GROUP");
                break;
            }
            case WITHIN_GROUP_OVER: {
                stringBuilder.append("WITHIN GROUP (");
                this.windowDef.orderBy.toStringOrderByElements(stringBuilder);
                stringBuilder.append(") OVER (");
                this.windowDef.partitionBy.toStringPartitionBy(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            default: {
                stringBuilder.append("OVER");
            }
        }
        if (this.windowName != null) {
            stringBuilder.append(" ").append(this.windowName);
        } else if (this.type != AnalyticType.WITHIN_GROUP_OVER) {
            stringBuilder.append(" ");
            stringBuilder.append(this.windowDef.toString());
        }
        return stringBuilder.toString();
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean bl2) {
        this.allColumns = bl2;
    }

    public Expression getFilterExpression() {
        return this.filterExpression;
    }

    public void setFilterExpression(Expression expression) {
        this.filterExpression = expression;
    }

    public AnalyticExpression withName(String string) {
        this.setName(string);
        return this;
    }

    public AnalyticExpression withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public AnalyticExpression withOffset(Expression expression) {
        this.setOffset(expression);
        return this;
    }

    public AnalyticExpression withDefaultValue(Expression expression) {
        this.setDefaultValue(expression);
        return this;
    }

    public AnalyticExpression withAllColumns(boolean bl2) {
        this.setAllColumns(bl2);
        return this;
    }

    public AnalyticExpression withKeep(KeepExpression keepExpression) {
        this.setKeep(keepExpression);
        return this;
    }

    public AnalyticExpression withType(AnalyticType analyticType) {
        this.setType(analyticType);
        return this;
    }

    public AnalyticExpression withDistinct(boolean bl2) {
        this.setDistinct(bl2);
        return this;
    }

    public AnalyticExpression withUnique(boolean bl2) {
        this.setUnique(bl2);
        return this;
    }

    public AnalyticExpression withIgnoreNulls(boolean bl2) {
        this.setIgnoreNulls(bl2);
        return this;
    }

    public AnalyticExpression withFilterExpression(Expression expression) {
        this.setFilterExpression(expression);
        return this;
    }

    public AnalyticExpression withWindowElement(WindowElement windowElement) {
        this.setWindowElement(windowElement);
        return this;
    }

    public <E extends Expression> E getExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getExpression()));
    }

    public <E extends Expression> E getOffset(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getOffset()));
    }

    public <E extends Expression> E getDefaultValue(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getDefaultValue()));
    }

    public <E extends Expression> E getFilterExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getFilterExpression()));
    }

    public List<OrderByElement> getFuncOrderBy() {
        return this.funcOrderBy;
    }

    public void setFuncOrderBy(List<OrderByElement> list) {
        this.funcOrderBy = list;
    }
}

