/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import java.util.List;
import java.util.ResourceBundle;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.change.core.SQLFileChange;
import liquibase.changelog.ChangeSet;
import liquibase.exception.ValidationErrors;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.license.LicenseServiceUtils;

public class AbstractNativeToolExecutor
extends JdbcExecutor {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_UNABLE_TO_VALIDATE_CHANGE_SET = coreBundle.getString("unable.to.validate.changeset");
    protected static final String MSG_UNABLE_TO_VALIDATE_LICENSE = coreBundle.getString("no.parameter.pro.license.found");
    protected ChangeSet changeSet;
    private String name;

    public AbstractNativeToolExecutor(String string) {
        this.name = string;
    }

    public ValidationErrors validate(ChangeSet changeSet) {
        if (changeSet.getRunWith() == null || changeSet.getRunWith().isEmpty()) {
            return new ValidationErrors();
        }
        ValidationErrors validationErrors = new ValidationErrors();
        if (!LicenseServiceUtils.isProLicenseValid()) {
            String string = String.format(MSG_UNABLE_TO_VALIDATE_LICENSE, this.getName(), "runWith");
            validationErrors.addError(string);
            return validationErrors;
        }
        for (Change change : changeSet.getChanges()) {
            this.validateChange(changeSet, validationErrors, change, "");
        }
        if (changeSet.getRollback() != null) {
            for (Change change : changeSet.getRollback().getChanges()) {
                this.validateChange(changeSet, validationErrors, change, "rollback");
            }
        }
        this.changeSet = changeSet;
        return validationErrors;
    }

    protected void validateChange(ChangeSet object, ValidationErrors validationErrors, Change change, String string) {
        if (!(change instanceof SQLFileChange) && !(change instanceof RawSQLChange)) {
            object = "In changeset '" + object.getId() + "::" + object.getAuthor() + "' there is an unsupported change type '" + change.toString() + "'";
            object = String.format(MSG_UNABLE_TO_VALIDATE_CHANGE_SET, object, string, this.name);
            validationErrors.addError((String)object);
        }
    }

    public void modifyChangeSet(ChangeSet object) {
        List list = object.getChanges();
        this.modifyChanges(list);
        this.changeSet = object;
        if (object.getRollback() == null) {
            return;
        }
        object = object.getRollback().getChanges();
        this.modifyChanges((List<Change>)object);
    }

    private void modifyChanges(List<Change> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Change)object.next();
            if (!(object2 instanceof AbstractSQLChange)) continue;
            if (!((AbstractSQLChange)object2).isSplitStatementsSet()) {
                ((AbstractSQLChange)object2).setSplitStatements(Boolean.FALSE);
                continue;
            }
            if (!Boolean.TRUE.equals(((AbstractSQLChange)object2).isSplitStatements())) continue;
            String string = "%nThe property 'splitStatements=true' is set for 'runWith' changeset 'author:%s', 'id:%s', 'filepath:%s'%n";
            object2 = object2.getChangeSet();
            object2 = String.format(string, object2.getAuthor(), object2.getId(), object2.getFilePath());
            object2 = (String)object2 + System.lineSeparator() + "Setting splitStatements='true' on changesets deployed by " + this.getName() + " may result in unintended consequences." + System.lineSeparator() + "The default is 'splitStatements=false' for 'runWith' changesets." + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object2)));
            Scope.getCurrentScope().getLog(AbstractNativeToolExecutor.class).warning((String)object2);
        }
    }
}

