/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.logging.structured;

import com.datical.liquibase.ext.util.JsonMinifyUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import liquibase.Scope;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.logging.LogFormat;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcManager;
import liquibase.parser.core.yaml.YamlParser;
import liquibase.serializer.core.yaml.YamlSerializer;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class StructuredLogFormatter
extends Formatter {
    private static final Yaml yaml;
    private static final JsonMinifyUtil minify;
    private static final MdcManager mdcManager;

    @Override
    public String format(LogRecord logRecord) {
        StructuredLogFormatter structuredLogFormatter = this;
        return structuredLogFormatter.jsonifyLogMessage(structuredLogFormatter.buildLogMessageElements(logRecord));
    }

    private Map<String, Object> buildLogMessageElements(LogRecord logRecord) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put("timestamp", Instant.ofEpochMilli(logRecord.getMillis()).toString());
        linkedHashMap.put("level", logRecord.getLevel().getName());
        if (StringUtil.isNotEmpty((String)logRecord.getSourceClassName())) {
            linkedHashMap.put("class", logRecord.getSourceClassName());
        }
        if (StringUtil.isNotEmpty((String)logRecord.getSourceMethodName())) {
            linkedHashMap.put("method", logRecord.getSourceMethodName());
        }
        linkedHashMap.put("thread", String.valueOf(logRecord.getThreadID()));
        Object object = StringUtil.isEmpty((String)logRecord.getMessage()) ? "" : logRecord.getMessage();
        linkedHashMap.put("message", object);
        if (logRecord.getThrown() != null) {
            object = "";
            if (logRecord.getThrown() != null) {
                object = new StringWriter();
                Map.Entry entry = new PrintWriter((Writer)object);
                ((PrintWriter)((Object)entry)).println();
                logRecord.getThrown().printStackTrace((PrintWriter)((Object)entry));
                ((PrintWriter)((Object)entry)).close();
                object = ((StringWriter)object).toString();
            }
            linkedHashMap.put("exception", object);
        }
        if ((object = mdcManager.getAll()) != null) {
            for (Map.Entry entry : object.entrySet()) {
                if (entry.getValue() == null) {
                    linkedHashMap.put((String)entry.getKey(), "");
                    continue;
                }
                linkedHashMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        return linkedHashMap;
    }

    private String jsonifyLogMessage(Map<String, Object> object) {
        object = YamlSerializer.removeClassTypeMarksFromSerializedJson((String)yaml.dumpAs(object, Tag.MAP, DumperOptions.FlowStyle.FLOW)).replace("!!null \"null\"", "\"null\"");
        if (LiquibaseCommandLineConfiguration.LOG_FORMAT.getCurrentValue() == LogFormat.JSON_PRETTY) {
            return object;
        }
        return minify.minify((String)object) + System.lineSeparator();
    }

    static {
        mdcManager = Scope.getCurrentScope().getMdcManager();
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        dumperOptions.setSplitLines(false);
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.FLOW);
        dumperOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.DOUBLE_QUOTED);
        dumperOptions.setWidth(Integer.MAX_VALUE);
        YamlSerializer.LiquibaseRepresenter liquibaseRepresenter = new YamlSerializer.LiquibaseRepresenter(dumperOptions);
        for (CustomMdcObject customMdcObject : Scope.getCurrentScope().getServiceLocator().findInstances(CustomMdcObject.class)) {
            liquibaseRepresenter.addClassTag(customMdcObject.getClass(), Tag.MAP);
        }
        yaml = new Yaml((BaseConstructor)new SafeConstructor(YamlParser.createLoaderOptions()), (Representer)liquibaseRepresenter, dumperOptions, (Resolver)new YamlSerializer.LiquibaseResolver());
        minify = new JsonMinifyUtil();
    }
}

