/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import com.datical.liquibase.ext.checks.config.cli.EnumGetter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StringEnumListGetter<E extends Enum>
extends AbstractCommandLineValueGetter<String> {
    private final Class<E> e;
    private final boolean ignoreCase;

    public StringEnumListGetter(Class<E> clazz, boolean bl2) {
        super(String.class);
        this.e = clazz;
        this.ignoreCase = bl2;
    }

    @Override
    public boolean validate(String string) {
        StringEnumListGetter.split(string, this.e, this.ignoreCase);
        return true;
    }

    @Override
    public String convert(String string) {
        return string;
    }

    public static <T extends Enum<T>> List<T> split(String string2, Class<T> clazz, boolean bl2) {
        return Arrays.stream(string2.split(",")).map(string -> {
            if (bl2) {
                return EnumGetter.getEnumIgnoreCase(string.trim().toUpperCase(), clazz);
            }
            return Enum.valueOf(clazz, string.trim());
        }).collect(Collectors.toList());
    }
}

