/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;

public class UnexpectedSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements UnexpectedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Synonym.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Change[] fixUnexpected(DatabaseObject object, DiffOutputControl diffOutputControl, Database object2, Database database, ChangeGeneratorChain changeGeneratorChain) {
        if (!((Synonym)((Object)(object = (Synonym)((Object)object)))).isPrivate() && !((Boolean)LiquibaseProConfiguration.DROP_PUBLIC_SYNONYMS_KEY.getCurrentValue()).booleanValue()) {
            return null;
        }
        object2 = new DropSynonymChange();
        ((DropSynonymChange)((Object)object2)).setSynonymName(((Synonym)((Object)object)).getName());
        if (!(database instanceof MSSQLDatabase)) {
            ((DropSynonymChange)((Object)object2)).setPrivate(((Synonym)((Object)object)).isPrivate());
        }
        ((DropSynonymChange)((Object)object2)).setObjectType(((Synonym)((Object)object)).getObjectType());
        if (diffOutputControl.getIncludeCatalog()) {
            ((DropSynonymChange)((Object)object2)).setSynonymCatalogName(((Synonym)((Object)object)).getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((DropSynonymChange)((Object)object2)).setSynonymSchemaName(((Synonym)((Object)object)).getSchema().getName());
        }
        return new Change[]{object2};
    }
}

