/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.EnableTriggerStatement;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableTriggerGenerator
extends AbstractSqlGenerator<EnableTriggerStatement> {
    public boolean supports(EnableTriggerStatement enableTriggerStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    public ValidationErrors validate(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkDisallowedField("catalogName", (Object)enableTriggerStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        sqlGeneratorChain.checkRequiredField("triggerName", (Object)enableTriggerStatement.getTriggerName());
        if (database instanceof MSSQLDatabase) {
            if (enableTriggerStatement.getScope() != null && !enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && !enableTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                sqlGeneratorChain.addError("Invalid enableTrigger scope: " + enableTriggerStatement.getScope());
                if (enableTriggerStatement.getTableName() != null && enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                    sqlGeneratorChain.addError("Cannot specify tableName and scope != TABLE");
                }
            }
            if ((enableTriggerStatement.getScope() == null || enableTriggerStatement.getScope().equals("TABLE")) && enableTriggerStatement.getTableName() == null) {
                sqlGeneratorChain.checkRequiredField("tableName", (Object)enableTriggerStatement.getTableName());
            }
        }
        if (database instanceof PostgresDatabase) {
            sqlGeneratorChain.checkRequiredField("tableName", (Object)enableTriggerStatement.getTableName());
        }
        return sqlGeneratorChain;
    }

    public Sql[] generateSql(EnableTriggerStatement enableTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new StringBuilder();
        if (database instanceof OracleDatabase) {
            ((StringBuilder)object).append("ALTER TRIGGER ");
            if (enableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            ((StringBuilder)object).append(database.escapeObjectName(null, enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTriggerName(), Trigger.class)).append(" ");
            ((StringBuilder)object).append("ENABLE");
        } else if (database instanceof PostgresDatabase) {
            ((StringBuilder)object).append("ALTER TABLE ");
            ((StringBuilder)object).append(database.escapeObjectName(null, enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTableName(), Trigger.class)).append(" ");
            ((StringBuilder)object).append(" ENABLE TRIGGER ");
            ((StringBuilder)object).append(enableTriggerStatement.getTriggerName());
        } else {
            ((StringBuilder)object).append("ENABLE TRIGGER ");
            if (enableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            ((StringBuilder)object).append(database.escapeObjectName(null, enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTriggerName(), Trigger.class)).append(" ");
            ((StringBuilder)object).append(" ON ");
            if (enableTriggerStatement.getScope() != null && enableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                ((StringBuilder)object).append("DATABASE");
            } else {
                ((StringBuilder)object).append(database.escapeTableName(enableTriggerStatement.getCatalogName(), enableTriggerStatement.getSchemaName(), enableTriggerStatement.getTableName()));
            }
        }
        enableTriggerStatement = new UnparsedSql(((StringBuilder)object).toString(), new DatabaseObject[0]);
        return new Sql[]{enableTriggerStatement};
    }
}

