/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class CreateFunctionGenerator
extends AbstractSqlGenerator<CreateFunctionStatement> {
    public int getPriority() {
        return 6;
    }

    public ValidationErrors validate(CreateFunctionStatement createFunctionStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkRequiredField("functionName", (Object)createFunctionStatement.getFunctionName());
        sqlGeneratorChain.checkRequiredField("functionBody", (Object)createFunctionStatement.getFunctionBody());
        sqlGeneratorChain.checkDisallowedField("catalogName", (Object)createFunctionStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        return sqlGeneratorChain;
    }

    public Sql[] generateSql(CreateFunctionStatement createFunctionStatement, Database database, SqlGeneratorChain object) {
        object = ";";
        if (database instanceof OracleDatabase) {
            object = "\n/";
        } else if (database instanceof AbstractDb2Database) {
            object = "";
        }
        String string = createFunctionStatement.getSchemaName();
        if (string == null && database instanceof PostgresDatabase) {
            string = database.getDefaultSchemaName();
        }
        string = CreateProcedureGenerator.addSchemaToText((String)CreateProcedureGenerator.removeTrailingDelimiter((String)createFunctionStatement.getFunctionBody(), (String)object), (String)string, (String)"FUNCTION", (Database)database);
        ArrayList<UnparsedSql> arrayList = new ArrayList<UnparsedSql>();
        if (createFunctionStatement.getReplaceIfExists() != null && createFunctionStatement.getReplaceIfExists().booleanValue()) {
            if (database instanceof MSSQLDatabase) {
                String string2 = createFunctionStatement.getFunctionName();
                string2 = createFunctionStatement.getSchemaName() == null ? "dbo.".concat(String.valueOf(string2)) : createFunctionStatement.getSchemaName() + "." + string2;
                StringClauses stringClauses = SqlParser.parse((String)string, (boolean)true, (boolean)true);
                string = SqlParser.parse((String)string, (boolean)true, (boolean)true);
                StringClauses.ClauseIterator clauseIterator = stringClauses.getClauseIterator();
                StringClauses.ClauseIterator clauseIterator2 = string.getClauseIterator();
                Object object2 = "START";
                while (object2 != null && !object2.toString().equalsIgnoreCase("create") && !object2.toString().equalsIgnoreCase("alter") && clauseIterator.hasNext()) {
                    object2 = clauseIterator.nextNonWhitespace();
                    clauseIterator2.nextNonWhitespace();
                }
                clauseIterator.replace((Object)"CREATE");
                clauseIterator2.replace((Object)"ALTER");
                string = "if object_id('" + string2 + "') is null exec ('" + stringClauses.toString().replace("'", "''") + "') else exec ('" + string.toString().replace("'", "''") + "')";
            } else {
                String string3 = database.escapeObjectName(createFunctionStatement.getFunctionName(), Function.class);
                arrayList.add(new UnparsedSql("DROP FUNCTION IF EXISTS ".concat(String.valueOf(string3)), new DatabaseObject[0]));
            }
        }
        arrayList.add(new UnparsedSql(string, (String)object, new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(arrayList, (String)createFunctionStatement.getSchemaName(), (Database)database);
        ArrayList<UnparsedSql> arrayList2 = arrayList;
        return arrayList2.toArray(new Sql[arrayList2.size()]);
    }
}

