/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.AddCheckConstraintStatement;
import com.datical.liquibase.ext.storedlogic.checkconstraint.change.DropCheckConstraintChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="addCheckConstraint", description="Adds a check constrant to an existing column or set of columns.", priority=1, appliesTo={"column"})
public class AddCheckConstraintChange
extends LicenseValidationChange {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String constraintName;
    private String constraintBody;
    private Boolean disabled;
    private Boolean validate;

    @Override
    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase && ((MySQLDatabase)database).isMinimumMySQLVersion("8.0.16") || database instanceof AbstractDb2Database || database instanceof PostgresDatabase) {
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.catalog", since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String string) {
        this.schemaName = string;
    }

    @DatabaseChangeProperty(mustEqualExisting="column.relation", description="Name of the table to create the check constraint on")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    @DatabaseChangeProperty(description="Name of the check constraint")
    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String string) {
        this.constraintName = string;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean bl2) {
        this.disabled = bl2;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getConstraintBody() {
        return this.constraintBody;
    }

    public void setConstraintBody(String string) {
        this.constraintBody = string;
    }

    @DatabaseChangeProperty(description="This is true if the check constraint has 'ENABLE VALIDATE' set, or false if the check constraint has 'ENABLE NOVALIDATE' set.")
    public Boolean getValidate() {
        return this.validate;
    }

    public void setValidate(Boolean bl2) {
        this.validate = bl2;
    }

    public SqlStatement[] generateStatements(Database database) {
        boolean bl2 = false;
        if (this.getDisabled() != null) {
            bl2 = this.getDisabled();
        }
        AddCheckConstraintStatement addCheckConstraintStatement = new AddCheckConstraintStatement(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getConstraintName());
        addCheckConstraintStatement.setConstraintBody(this.getConstraintBody());
        addCheckConstraintStatement.setDisabled(bl2);
        addCheckConstraintStatement.setValidate(this.validate);
        return new SqlStatement[]{addCheckConstraintStatement};
    }

    public String getConfirmationMessage() {
        return "Check constraint added to " + this.getTableName();
    }

    protected Change[] createInverses() {
        DropCheckConstraintChange dropCheckConstraintChange = new DropCheckConstraintChange();
        dropCheckConstraintChange.setSchemaName(this.getSchemaName());
        dropCheckConstraintChange.setTableName(this.getTableName());
        dropCheckConstraintChange.setConstraintName(this.getConstraintName());
        return new Change[]{dropCheckConstraintChange};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public void finishInitialization() {
        if (this.validate != null) {
            return;
        }
        ChangeSet changeSet = this.getChangeSet();
        if (changeSet == null) {
            return;
        }
        if (changeSet.getStoredCheckSum() == null) {
            return;
        }
        this.addValidChecksumForValidateAttIfNeeded(changeSet, Boolean.TRUE);
        this.addValidChecksumForValidateAttIfNeeded(changeSet, null);
    }

    private void addValidChecksumForValidateAttIfNeeded(ChangeSet changeSet, Boolean bl2) {
        changeSet.clearCheckSum();
        this.validate = bl2;
        bl2 = changeSet.generateCheckSum();
        if (changeSet.getStoredCheckSum().equals((Object)bl2)) {
            this.getChangeSet().addValidCheckSum(bl2.toString());
        }
    }
}

