/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.condition;

import com.datical.liquibase.ext.flow.condition.OperatorFactory;
import com.datical.liquibase.ext.flow.condition.operator.ConditionOperator;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.util.StringUtil;

public class Condition {
    private final String leftOperand;
    private final ConditionOperator operator;
    private final String rightOperand;
    private final String rawConditionText;
    private static final OperatorFactory operatorFactory = (OperatorFactory)Scope.getCurrentScope().getSingleton(OperatorFactory.class);

    public Condition(String string, ConditionOperator conditionOperator, String string2, String string3) {
        this.leftOperand = string;
        this.operator = conditionOperator;
        this.rightOperand = string2;
        this.rawConditionText = string3;
    }

    public static Condition fromString(String string, Map<String, Object> object) {
        if (StringUtil.isEmpty((String)string)) {
            return null;
        }
        Object object2 = Scope.getCurrentScope().getServiceLocator().findInstances(ConditionOperator.class);
        if (object2.isEmpty()) {
            throw new RuntimeException("No condition operators found.");
        }
        if (object != null && !object.isEmpty()) {
            string = FlowVariableExpander.expandVariables(Collections.singletonMap("if", string), object).get("if").toString();
        }
        if (((Matcher)(object = Pattern.compile(String.format("(?<leftOperand>.+)\\s*(?<operator>%s)\\s*(?<rightOperand>.+)", object2.stream().map(ConditionOperator::getTextualRepresentation).collect(Collectors.joining("|")))).matcher(string.trim()))).matches()) {
            object2 = ((Matcher)object).group("operator");
            ConditionOperator conditionOperator = operatorFactory.create((String)object2);
            if (conditionOperator == null) {
                throw new IllegalArgumentException("Operator '" + (String)object2 + "' not recognized.");
            }
            return new Condition(((Matcher)object).group("leftOperand").trim(), conditionOperator, ((Matcher)object).group("rightOperand").trim(), string);
        }
        throw new IllegalArgumentException("Condition '" + string + "' cannot be parsed.");
    }

    public boolean evaluate() {
        return this.operator.evaluate(this.leftOperand, this.rightOperand);
    }

    public String getRawConditionText() {
        return this.rawConditionText;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (Condition)object;
        return this.leftOperand.equals(((Condition)object).leftOperand) && this.operator.getClass().equals(((Condition)object).operator.getClass()) && this.rightOperand.equals(((Condition)object).rightOperand);
    }

    public int hashCode() {
        return Objects.hash(this.leftOperand, this.operator, this.rightOperand);
    }
}

