/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.FlowShellCommandChange;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import liquibase.command.CommandResultsBuilder;
import liquibase.util.StringUtil;

public class FlowShellCommandAction
extends Action {
    private String command;
    private List<String> argsList;
    private FlowShellCommandChange commandChange;
    private static final String COMMAND_KEY = "command";

    @Override
    public String getType() {
        return "shell";
    }

    public String toString() {
        return String.format("'%s' %s", this.getType(), this.command);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public List<String> getArgsList() {
        return this.argsList;
    }

    public void setArgsList(List<String> list) {
        this.argsList = list;
    }

    @Override
    public Action fromAction(Map<String, Object> stringArray, Map<String, Object> map) {
        FlowShellCommandAction flowShellCommandAction = new FlowShellCommandAction();
        if (StringUtil.isEmpty((String)(stringArray = (String)stringArray.get(COMMAND_KEY)))) {
            throw new IllegalArgumentException("Empty command found");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(COMMAND_KEY, stringArray);
        stringArray = FlowShellCommandAction.parseToArray((String)FlowVariableExpander.expandVariables(hashMap, map).get(COMMAND_KEY));
        flowShellCommandAction.setCommand(stringArray[0]);
        if (stringArray.length > 1) {
            stringArray = Arrays.copyOfRange(stringArray, 1, stringArray.length);
            flowShellCommandAction.setArgsList(Arrays.asList(stringArray));
        }
        flowShellCommandAction.commandChange = new FlowShellCommandChange();
        return flowShellCommandAction;
    }

    @Override
    public void validate(String string) {
    }

    @Override
    public void execute(CommandResultsBuilder commandResultsBuilder) {
        this.commandChange.setExecutable(this.command);
        this.argsList.forEach(this::fixArgAndAdd);
        this.commandChange.createShellCommandArray();
        try {
            this.commandChange.executeShellCommand();
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void fixArgAndAdd(String object) {
        if (!object.contains("=")) {
            this.commandChange.addArg((String)object);
            return;
        }
        String string = (object = object.split("="))[0].trim();
        if (!string.startsWith("--") && string.startsWith("-")) {
            string = "-".concat(String.valueOf(string));
        }
        object = object[1].trim();
        this.commandChange.addArg(string);
        this.commandChange.addArg((String)object);
    }

    private static String[] parseToArray(String string) {
        String[] stringArray;
        if (string == null || string.isEmpty()) {
            return new String[0];
        }
        int n2 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"' ", true);
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        block4: while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            switch (n2) {
                case 1: {
                    if ("'".equals(stringArray)) {
                        bl2 = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(stringArray)) {
                        bl2 = true;
                        n2 = 0;
                        continue block4;
                    }
                    stringBuilder.append((String)stringArray);
                    continue block4;
                }
            }
            if ("'".equals(stringArray)) {
                n2 = 1;
            } else if ("\"".equals(stringArray)) {
                n2 = 2;
            } else if (" ".equals(stringArray)) {
                if (bl2 || stringBuilder.length() != 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
            } else {
                stringBuilder.append((String)stringArray);
            }
            bl2 = false;
        }
        if (bl2 || stringBuilder.length() != 0) {
            arrayList.add(stringBuilder.toString());
        }
        if (n2 == 1 || n2 == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in ".concat(String.valueOf(string)));
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }
}

