/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksTableColumns;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.util.StringUtil;
import liquibase.util.TableOutput;

public class ChecksShowCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "show"};
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> SHOW_COLUMNS_ARG;

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        if (this.isMavenIntegration(commandResultsBuilder)) {
            InMemoryChecksFileAccessor inMemoryChecksFileAccessor = new InMemoryChecksFileAccessor();
            Scope.child(Collections.singletonMap("fileAccessor", inMemoryChecksFileAccessor), () -> this.doRun(commandResultsBuilder));
            return;
        }
        this.doRun(commandResultsBuilder);
    }

    private void doRun(CommandResultsBuilder commandResultsBuilder) {
        String string = (String)commandResultsBuilder.getCommandScope().getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksShowCommandStep.checkFileArgExistence(string, "checks settings", false);
        String string2 = System.lineSeparator() + "Generating report on current configuration of checks using settings in: " + (StringUtil.isEmpty((String)string) ? "liquibase.checks-settings.conf" : string) + System.lineSeparator();
        Scope.getCurrentScope().getUI().sendMessage(string2);
        ChecksShowCommandStep.writeTableToOutput(commandResultsBuilder, string, true);
        string = "INFO: Customize 'checks show' table with --show-cols flag. Learn more with 'liquibase checks show --help'" + System.lineSeparator();
        Scope.getCurrentScope().getUI().sendMessage(string);
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("List available checks, their configuration options, and current settings");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    public static void writeTableToOutput(CommandResultsBuilder object, String object2, boolean bl2) {
        List<ChecksTableColumns> list = ChecksShowCommandStep.getRequiredColumns(object);
        List<AbstractLiquibaseRule> list2 = ChecksShowCommandStep.listAllRules();
        String string = (String)object.getCommandScope().getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        object2 = new CheckSettingsConfigHelper((String)object2, string).read(list2);
        List<List<String>> list3 = ChecksShowCommandStep.createTableWithData(list2, (CheckSettingsConfig)object2, bl2, list);
        object = ChecksShowCommandStep.createOutputWriter(object);
        TableOutput.formatOutput(list3, ChecksTableColumns.getColumnWidthsList(list), (boolean)true, (Writer)object);
        if (object2 != null) {
            ((CheckSettingsConfig)object2).outputWarningMessage();
        }
    }

    private static List<List<String>> createTableWithData(List<AbstractLiquibaseRule> list, CheckSettingsConfig iterator, boolean bl2, List<ChecksTableColumns> list2) {
        ArrayList<List<String>> arrayList;
        block6: {
            List<String> list3;
            block5: {
                list3 = ChecksTableColumns.getColumnNamesList((Collection<ChecksTableColumns>)list3);
                arrayList = new ArrayList<List<String>>();
                arrayList.add(list3);
                if (iterator == null) break block5;
                for (AbstractConfigurableRule object : ((CheckSettingsConfig)((Object)iterator)).getRules()) {
                    Optional<AbstractLiquibaseRule> object2 = ChecksShowCommandStep.findParentRule(list, object);
                    if (object2.isPresent()) {
                        object2 = object2.get();
                        String string = "<None>";
                        String string2 = ((AbstractLiquibaseRule)((Object)object2)).getShortName();
                        if (object.isConfigurable()) {
                            string = ((DynamicRule)object).prettyPrintParameters();
                            string2 = ((DynamicRule)object).getShortName();
                        }
                        Map<String, String> abstractLiquibaseRule = ChecksShowCommandStep.prepareAllRulePropertiesMap(((AbstractLiquibaseRule)((Object)object2)).getId().toString(), ((AbstractLiquibaseRule)((Object)object2)).getName(), string2, ChecksShowCommandStep.scopesToString(object2.getScope()), StringUtil.join(((AbstractLiquibaseRule)((Object)object2)).getSupportedChangesetFormats(), (String)", "), Boolean.toString(object.isEnabled()), Integer.toString(object.getSeverity().getExitValue()), string, ((AbstractLiquibaseRule)((Object)object2)).getDescription());
                        arrayList.add(ChecksShowCommandStep.getRulePropertiesForRequiredColumns(list3, abstractLiquibaseRule));
                        continue;
                    }
                    Scope.getCurrentScope().getLog(ChecksShowCommandStep.class).fine("Customized rule with ID " + object.getId() + " does not match any rules loaded in the system, and will not be shown.");
                }
                break block6;
            }
            if (!bl2) break block6;
            for (AbstractLiquibaseRule abstractLiquibaseRule : list) {
                Object object = "<None>";
                if (abstractLiquibaseRule.isConfigurable()) {
                    object = abstractLiquibaseRule.prettyPrintParameters();
                }
                object = ChecksShowCommandStep.prepareAllRulePropertiesMap(abstractLiquibaseRule.getId().toString(), abstractLiquibaseRule.getName(), abstractLiquibaseRule.getShortName(), ChecksShowCommandStep.scopesToString(abstractLiquibaseRule.getScope()), StringUtil.join(abstractLiquibaseRule.getSupportedChangesetFormats(), (String)", "), String.valueOf(abstractLiquibaseRule.isEnabledByDefault()), Integer.toString(abstractLiquibaseRule.getSeverity().getExitValue()), (String)object, abstractLiquibaseRule.getDescription());
                arrayList.add(ChecksShowCommandStep.getRulePropertiesForRequiredColumns(list3, (Map<String, String>)object));
            }
        }
        return arrayList;
    }

    private static List<ChecksTableColumns> getRequiredColumns(CommandResultsBuilder object) {
        object = (String)object.getCommandScope().getConfiguredValue(SHOW_COLUMNS_ARG).getValue();
        return Arrays.stream(ChecksTableColumns.values()).filter(arg_0 -> ChecksShowCommandStep.lambda$getRequiredColumns$3((String)object, arg_0)).collect(Collectors.toList());
    }

    private static Optional<AbstractLiquibaseRule> findParentRule(List<AbstractLiquibaseRule> list, AbstractConfigurableRule object) {
        object = ((AbstractConfigurableRule)object).isConfigurable() ? (((DynamicRule)(object = (DynamicRule)object)).isCopy() ? ((DynamicRule)object).getParentRuleId() : ((AbstractConfigurableRule)object).getId()) : ((AbstractConfigurableRule)object).getId();
        return list.stream().filter(arg_0 -> ChecksShowCommandStep.lambda$findParentRule$4((UUID)object, arg_0)).findFirst();
    }

    private static Map<String, String> prepareAllRulePropertiesMap(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put(ChecksTableColumns.ID.getName(), string);
        linkedHashMap.put(ChecksTableColumns.CHECKNAME.getName(), string2);
        linkedHashMap.put(ChecksTableColumns.SHORTNAME.getName(), string3);
        linkedHashMap.put(ChecksTableColumns.SCOPE.getName(), string4);
        linkedHashMap.put(ChecksTableColumns.CHANGESET_TYPE.getName(), string5);
        linkedHashMap.put(ChecksTableColumns.ENABLED.getName(), string6);
        linkedHashMap.put(ChecksTableColumns.SEVERITY.getName(), string7);
        linkedHashMap.put(ChecksTableColumns.CUSTOMIZATION.getName(), string8);
        linkedHashMap.put(ChecksTableColumns.DESCRIPTION.getName(), string9);
        return linkedHashMap;
    }

    private static List<String> getRulePropertiesForRequiredColumns(List<String> list, Map<String, String> map) {
        return list.stream().map(map::get).collect(Collectors.toList());
    }

    private static String scopesToString(List<ScopeEnum> list) {
        return StringUtil.join((Collection)list.stream().map(scopeEnum -> scopeEnum.toString().toLowerCase()).sorted().collect(Collectors.toList()), (String)", ");
    }

    private static Writer createOutputWriter(CommandResultsBuilder object) {
        String string = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        object = object.getOutputStream();
        return new OutputStreamWriter((OutputStream)object, string);
    }

    private static /* synthetic */ boolean lambda$findParentRule$4(UUID uUID, AbstractLiquibaseRule abstractLiquibaseRule) {
        return abstractLiquibaseRule.getId().equals(uUID);
    }

    private static /* synthetic */ boolean lambda$getRequiredColumns$3(String string, ChecksTableColumns checksTableColumns) {
        return string.contains(checksTableColumns.getNameArgumentCase());
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_INTEGRATION_ARG = commandBuilder.argument("checksIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing checks show").build();
        SHOW_COLUMNS_ARG = commandBuilder.argument("showCols", String.class).defaultValue((Object)ChecksTableColumns.DEFAULT_COLUMNS_ARG).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = ((String)object).toLowerCase())).equals("all")) {
                return ChecksTableColumns.EVERY_COLUMN_ARG;
            }
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(((String)object).split(",")));
            if (!Arrays.stream(ChecksTableColumns.values()).map(ChecksTableColumns::getNameArgumentCase).collect(Collectors.toSet()).containsAll(hashSet)) {
                object = "WARNING:  The showCols arguments '" + (String)object + "' are not valid." + System.lineSeparator() + "Valid value is a comma separated list of column names: " + ChecksTableColumns.EVERY_COLUMN_ARG + ".";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description(String.format("Only show the listed columns. Column options: %s. Use commas to separate column names. Use 'all' to select all the columns.", ChecksTableColumns.EVERY_COLUMN_ARG)).build();
    }
}

