/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileHelper;
import java.io.File;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandScope;

public abstract class AbstractFlowCommand
extends AbstractCommandStep {
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
        LiquibaseLabsConfiguration.checkLabsLicenseAndThrowException(commandScope.getCommand().getName());
    }

    FlowFile loadFlowFileContents(String object, String string2, boolean bl2) {
        File file = new File((String)object);
        if (file.exists()) {
            return FlowFileHelper.load(file, bl2);
        }
        if (!file.getName().equals("liquibase.flowfile.yaml") || string2.equalsIgnoreCase("maven")) {
            object = String.format("Specified flow file '%s' does not exist.", object);
            throw new IllegalArgumentException((String)object);
        }
        object = new File(".");
        if (((Boolean)GlobalConfiguration.HEADLESS.getCurrentConfiguredValue().getValue()).booleanValue()) {
            object = String.format("No flow-file detected. Because the 'headless' property is set to TRUE, the flow file will be created automatically in:%n'%s'.%nIt will contain three commands: 'checks run', 'update', 'checks run with database scope'. This file will then be executed.%nLearn more about 'headless' property interactions at https://docs.liquibase.com%n", ((File)object).getCanonicalPath());
            Scope.getCurrentScope().getLog(AbstractFlowCommand.class).info((String)object);
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return FlowFileHelper.load(FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml"), bl2);
        }
        object = (String)Scope.getCurrentScope().getUI().prompt("WARNING: No flow file detected. Would you like to create and automatically use '" + new File(((File)object).getCanonicalPath(), file.getName()).getAbsolutePath() + "' ?" + System.lineSeparator() + "[1] Yes, create and use sample flow file" + System.lineSeparator() + "[2] Just create sample flow file, do not use, and exit comamnd" + System.lineSeparator() + "[3] No, do not create sample file, and exit command." + System.lineSeparator(), (Object)"1", (string, clazz) -> {
            if (string == null || !string.equalsIgnoreCase("1") && !string.equalsIgnoreCase("2") && !string.equalsIgnoreCase("3")) {
                throw new IllegalArgumentException();
            }
            return string;
        }, String.class);
        if (((String)object).equals("3")) {
            object = "No flow-file available. Set the 'flow-file' property with a CLI argument, Environment variable, or other standard method. Learn more at https://docs.liquibase.com";
            Scope.getCurrentScope().getLog(FlowFileHelper.class).warning((String)object);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
            return null;
        }
        if (((String)object).equals("2")) {
            object = FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml");
            object = String.format("Sample 'liquibase.flowfile.yaml' file created at '%s', and ready to use.%nLearn more at https://docs.liquibase.com", ((File)object).getAbsolutePath());
            Scope.getCurrentScope().getLog(FlowFileHelper.class).warning((String)object);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
            return null;
        }
        return FlowFileHelper.load(FlowFileHelper.createDefaultFlowFile("liquibase.flowfile.yaml"), bl2);
    }
}

