/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;

public class CreateSynonymGenerator
extends AbstractSqlGenerator<CreateSynonymStatement> {
    public boolean supports(CreateSynonymStatement createSynonymStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase || database instanceof EnterpriseDBDatabase) && super.supports((SqlStatement)createSynonymStatement, database);
    }

    public ValidationErrors validate(CreateSynonymStatement createSynonymStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkRequiredField("objectName", (Object)createSynonymStatement.getObjectName());
        sqlGeneratorChain.checkRequiredField("synonymName", (Object)createSynonymStatement.getSynonymName());
        if (database instanceof DB2Database) {
            sqlGeneratorChain.checkRequiredField("objectType", (Object)createSynonymStatement.getObjectType());
        }
        if (!(createSynonymStatement.isPrivate() != null && createSynonymStatement.isPrivate().booleanValue() || createSynonymStatement.getSynonymCatalogName() == null && createSynonymStatement.getSynonymSchemaName() == null)) {
            sqlGeneratorChain.addError("Cannot specify schema name for non-private synonyms");
        }
        return sqlGeneratorChain;
    }

    public Warnings warn(CreateSynonymStatement createSynonymStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = super.warn((SqlStatement)createSynonymStatement, database, sqlGeneratorChain);
        if (database instanceof MSSQLDatabase && createSynonymStatement.getReplaceIfExists() != null && createSynonymStatement.getReplaceIfExists().booleanValue()) {
            sqlGeneratorChain.addWarning("Microsoft SQL Server does not support replacing synonyms. To replace a synonym in SQL Server, precede the createSynonym refactoring with a dropSynonym refactoring in your change set.");
        }
        if (database instanceof MSSQLDatabase && createSynonymStatement.isPrivate() != null && !createSynonymStatement.isPrivate().booleanValue()) {
            sqlGeneratorChain.addWarning("MSSQL does not support public synonyms. Creating " + createSynonymStatement.getSynonymName() + " as private");
        }
        return sqlGeneratorChain;
    }

    public Sql[] generateSql(CreateSynonymStatement object, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) {
            object = this.generateSqlForOracle((CreateSynonymStatement)((Object)object), database);
        } else if (database instanceof DB2Database) {
            object = this.generateSqlForDB2((CreateSynonymStatement)((Object)object), database);
        } else if (database instanceof Db2zDatabase) {
            object = this.generateSqlForDB2Zos((CreateSynonymStatement)((Object)object), database);
        } else if (database instanceof MSSQLDatabase) {
            object = this.generateSqlForMSSQL((CreateSynonymStatement)((Object)object), database);
        } else {
            throw new UnexpectedLiquibaseException("Unexpected database type: " + database.getShortName());
        }
        return new Sql[]{new UnparsedSql((String)object, new DatabaseObject[0])};
    }

    protected String generateSqlForOracle(CreateSynonymStatement createSynonymStatement, Database database) {
        String string = createSynonymStatement.isPrivate() == null || createSynonymStatement.isPrivate() == false ? database.escapeObjectName(createSynonymStatement.getSynonymName(), Synonym.class) : database.escapeObjectName(createSynonymStatement.getSynonymCatalogName(), createSynonymStatement.getSynonymSchemaName(), createSynonymStatement.getSynonymName(), Synonym.class);
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        if (createSynonymStatement.getReplaceIfExists() != null && createSynonymStatement.getReplaceIfExists().booleanValue()) {
            stringBuilder.append("OR REPLACE ");
        }
        if (createSynonymStatement.isPrivate() == null || !createSynonymStatement.isPrivate().booleanValue()) {
            stringBuilder.append("PUBLIC ");
        }
        stringBuilder.append("SYNONYM ").append(string).append(" FOR ").append(database.escapeObjectName(createSynonymStatement.getObjectCatalogName(), createSynonymStatement.getObjectSchemaName(), createSynonymStatement.getObjectName(), DatabaseObject.class));
        return stringBuilder.toString();
    }

    protected String generateSqlForMSSQL(CreateSynonymStatement createSynonymStatement, Database database) {
        String string = createSynonymStatement.isPrivate() == null || createSynonymStatement.isPrivate() == false ? database.escapeObjectName(createSynonymStatement.getSynonymName(), Synonym.class) : database.escapeObjectName(createSynonymStatement.getSynonymCatalogName(), createSynonymStatement.getSynonymSchemaName(), createSynonymStatement.getSynonymName(), Synonym.class);
        StringBuilder stringBuilder = new StringBuilder();
        if (createSynonymStatement.getSynonymCatalogName() != null) {
            stringBuilder.append("USE [" + createSynonymStatement.getSynonymCatalogName() + "]\n");
        }
        stringBuilder.append("CREATE SYNONYM ");
        String string2 = database.escapeObjectName(null, createSynonymStatement.getObjectSchemaName(), createSynonymStatement.getObjectName(), DatabaseObject.class);
        if (createSynonymStatement.getObjectCatalogName() != null) {
            string2 = database.escapeObjectName(createSynonymStatement.getObjectCatalogName(), Catalog.class) + "." + string2;
        }
        stringBuilder.append(string).append(" FOR ").append(string2);
        if (createSynonymStatement.getSynonymCatalogName() != null) {
            stringBuilder.append("\nUSE [" + database.getDefaultCatalogName() + "]\n");
        }
        return stringBuilder.toString();
    }

    protected String generateSqlForDB2(CreateSynonymStatement createSynonymStatement, Database database) {
        String string = createSynonymStatement.isPrivate() == null || createSynonymStatement.isPrivate() == false ? database.escapeObjectName(createSynonymStatement.getSynonymName(), Synonym.class) : database.escapeObjectName(createSynonymStatement.getSynonymCatalogName(), createSynonymStatement.getSynonymSchemaName(), createSynonymStatement.getSynonymName(), Synonym.class);
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        if (createSynonymStatement.getReplaceIfExists() != null && createSynonymStatement.getReplaceIfExists().booleanValue()) {
            stringBuilder.append("OR REPLACE ");
        }
        if (createSynonymStatement.isPrivate() == null || !createSynonymStatement.isPrivate().booleanValue()) {
            stringBuilder.append("PUBLIC ");
        }
        stringBuilder.append("ALIAS ").append(string).append(" FOR ").append(createSynonymStatement.getObjectType().toUpperCase()).append(" ").append(database.escapeObjectName(createSynonymStatement.getObjectCatalogName(), createSynonymStatement.getObjectSchemaName(), createSynonymStatement.getObjectName(), DatabaseObject.class));
        return stringBuilder.toString();
    }

    private String generateSqlForDB2Zos(CreateSynonymStatement createSynonymStatement, Database database) {
        String string = createSynonymStatement.isPrivate() == null || createSynonymStatement.isPrivate() == false ? database.escapeObjectName(createSynonymStatement.getSynonymName(), Synonym.class) : database.escapeObjectName(createSynonymStatement.getSynonymCatalogName(), createSynonymStatement.getSynonymSchemaName(), createSynonymStatement.getSynonymName(), Synonym.class);
        StringBuilder stringBuilder = new StringBuilder("CREATE ");
        if (createSynonymStatement.getReplaceIfExists() != null && createSynonymStatement.getReplaceIfExists().booleanValue()) {
            stringBuilder.append("OR REPLACE ");
        }
        if (createSynonymStatement.isPrivate() == null || !createSynonymStatement.isPrivate().booleanValue()) {
            stringBuilder.append("PUBLIC ");
        }
        stringBuilder.append("ALIAS ").append(string).append(" FOR ").append(database.escapeObjectName(createSynonymStatement.getObjectCatalogName(), createSynonymStatement.getObjectSchemaName(), createSynonymStatement.getObjectName(), DatabaseObject.class));
        return stringBuilder.toString();
    }
}

