/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.cdi;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import javax.inject.Singleton;
import liquibase.Scope;
import liquibase.integration.cdi.CDILiquibaseConfig;
import liquibase.integration.cdi.SchemesTreeBuilder;
import liquibase.integration.cdi.annotations.Liquibase;
import liquibase.integration.cdi.annotations.LiquibaseSchema;
import liquibase.logging.Logger;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;

@Singleton
public class SchemesCDIConfigBuilder {
    private static final Logger log = Scope.getCurrentScope().getLog(SchemesCDIConfigBuilder.class);
    private static final String ROOT_PATH = System.getProperty("java.io.tmpdir");
    private static final String SCHEMA_NAME = "/schema.template.xml";
    private static final String TEMPLATE_NAME = "liquibase.cdi.schema.xml";
    private static final String INCLUDE_TPL = "\t<include file=\"%s\"/>%n";
    private static final Long FILE_LOCK_TIMEOUT = 50L;
    private final BeanManager bm;
    private final SchemesTreeBuilder treeBuilder;

    @Inject
    public SchemesCDIConfigBuilder(BeanManager bm, SchemesTreeBuilder treeBuilder) {
        this.bm = bm;
        this.treeBuilder = treeBuilder;
    }

    public ResourceAccessor createResourceAccessor() throws IOException {
        return new DirectoryResourceAccessor(new File(ROOT_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CDILiquibaseConfig createCDILiquibaseConfig() {
        String id = UUID.randomUUID().toString();
        log.fine(String.format("[id = %s] createConfig(). Date: '%s'", id, new Date()));
        InputStream is = SchemesCDIConfigBuilder.class.getResourceAsStream(SCHEMA_NAME);
        CDILiquibaseConfig cDILiquibaseConfig = this.jvmLocked(id, () -> this.createCDILiquibaseConfig(id, is));
        try {
            is.close();
        }
        catch (IOException ioe) {
            log.warning(String.format("[id = %s] IOException during closing an input stream '%s'.", id, ioe.getMessage()), (Throwable)ioe);
        }
        return cDILiquibaseConfig;
        catch (Exception ex) {
            CDILiquibaseConfig cDILiquibaseConfig2;
            try {
                log.warning(String.format("[id = %s] Unable to initialize liquibase where '%s'.", id, ex.getMessage()), (Throwable)ex);
                cDILiquibaseConfig2 = null;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    log.warning(String.format("[id = %s] IOException during closing an input stream '%s'.", id, ioe.getMessage()), (Throwable)ioe);
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException ioe) {
                log.warning(String.format("[id = %s] IOException during closing an input stream '%s'.", id, ioe.getMessage()), (Throwable)ioe);
            }
            return cDILiquibaseConfig2;
        }
    }

    private CDILiquibaseConfig createCDILiquibaseConfig(String id, InputStream is) throws IOException {
        File liquibaseDir = new File(String.format("%s/liquibase/schemes", ROOT_PATH));
        if (!liquibaseDir.exists() && !liquibaseDir.mkdirs()) {
            throw new RuntimeException(String.format("[id = %s] Cannot create [%s] dirs.", id, liquibaseDir));
        }
        log.fine(String.format("[id = %s] Includes directory: [path='%s']", id, liquibaseDir.getAbsolutePath()));
        String path = String.format("%s/%s", ROOT_PATH, TEMPLATE_NAME);
        File output = new File(path);
        if (output.exists()) {
            log.fine(String.format("[id = %s] File [path='%s'] already exists, deleting", id, path));
            if (output.delete()) {
                log.fine(String.format("[id = %s] File [path='%s'] already exists, deleted successfully.", id, path));
            } else {
                log.fine(String.format("[id = %s] File [path='%s'] already exists, failed to delete.", id, path));
            }
        }
        if (!output.createNewFile()) {
            throw new RuntimeException(String.format("[id = %s] Cannot create [%s] file.", id, output));
        }
        log.info(String.format("[id = %s] File %s was created.", id, output));
        log.fine(String.format("[id = %s] Root liquibase file [path='%s'] ready.", id, path));
        long start = System.currentTimeMillis();
        log.info(String.format("[id = %s] Scanning application for liquibase schemes.", id));
        Set beans = this.bm.getBeans(Object.class, new Annotation[]{new AnnotationLiteralDefault()});
        LinkedHashSet<Class> classesSet = new LinkedHashSet<Class>();
        for (Object bean : beans) {
            classesSet.add(bean.getBeanClass());
        }
        LinkedHashSet<LiquibaseSchema> annotationsSet = new LinkedHashSet<LiquibaseSchema>();
        for (Class clazz : classesSet) {
            annotationsSet.add(clazz.getAnnotation(LiquibaseSchema.class));
        }
        ArrayList<LiquibaseSchema> liquibaseSchemaList = new ArrayList<LiquibaseSchema>();
        for (Annotation annotation : annotationsSet) {
            liquibaseSchemaList.add((LiquibaseSchema)annotation);
        }
        List<LiquibaseSchema> list = this.treeBuilder.build(id, liquibaseSchemaList);
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (LiquibaseSchema liquibaseSchema : list) {
            arrayList.add(liquibaseSchema.resource());
        }
        ArrayList<String> schemaPaths = new ArrayList<String>();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            for (String resource : stringArray = (String[])iterator.next()) {
                schemaPaths.add(this.copyToFile(id, liquibaseDir.getAbsolutePath(), resource));
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String schema : schemaPaths) {
            stringBuilder.append(String.format(INCLUDE_TPL, schema)).append("\n");
        }
        long l = System.currentTimeMillis();
        log.info(String.format("[id = %s] Scan complete [took=%s milliseconds].", id, l - start));
        log.fine(String.format("[id = %s] Resolved schemes: %n%s%n", id, stringBuilder));
        log.fine(String.format("[id = %s] Generating root liquibase file...", id));
        String template = StreamUtil.readStreamAsString((InputStream)is);
        String xml = String.format(template, stringBuilder);
        FileUtil.write((String)xml, (File)output);
        log.info(String.format("[id = %s] File %s was written.", id, output));
        log.fine(String.format("[id = %s] Generation complete.", id));
        log.fine(String.format("[id = %s] Root liquibase xml: %n %s %n", id, xml));
        CDILiquibaseConfig config = new CDILiquibaseConfig();
        config.setChangeLog(TEMPLATE_NAME);
        return config;
    }

    synchronized CDILiquibaseConfig jvmLocked(String id, Callable<CDILiquibaseConfig> action) throws Exception {
        return this.fileLocked(id, action);
    }

    CDILiquibaseConfig fileLocked(String id, Callable<CDILiquibaseConfig> action) throws Exception {
        log.info(String.format("[id = %s] JVM lock acquired, acquiring file lock", id));
        String lockPath = String.format("%s/schema.liquibase.lock", ROOT_PATH);
        File lockFile = new File(lockPath);
        if (!lockFile.exists() && lockFile.createNewFile()) {
            log.info(String.format("[id = %s] Created lock file [path='%s'].", id, lockPath));
        }
        log.info(String.format("[id = %s] Trying to acquire the file lock [file='%s']...", id, lockPath));
        CDILiquibaseConfig actionResult = null;
        FileLock lock = null;
        try (FileOutputStream fileStream = new FileOutputStream(lockPath);
             FileChannel fileChannel = fileStream.getChannel();){
            while (null == lock) {
                try {
                    lock = fileChannel.tryLock();
                }
                catch (OverlappingFileLockException e) {
                    log.fine(String.format("[id = %s] Lock already acquired, waiting for the lock...", id));
                }
                if (null != lock) continue;
                log.fine(String.format("[id = %s] Waiting for the lock...", id));
                try {
                    Thread.sleep(FILE_LOCK_TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    log.severe(interruptedException.getMessage(), (Throwable)interruptedException);
                    Thread.currentThread().interrupt();
                }
            }
            log.info(String.format("[id = %s] File lock acquired, running liquibase...", id));
            actionResult = action.call();
            lock.release();
        }
        catch (Exception e) {
            log.warning(e.getMessage(), (Throwable)e);
        }
        return actionResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String copyToFile(String id, String liquibase, String schema) {
        String string;
        log.info(String.format("[id = %s] copyToFile(%s, %s)", id, liquibase, schema));
        InputStream is = null;
        try {
            File file;
            is = this.getClass().getClassLoader().getResourceAsStream(schema);
            log.info(String.format("[id = %s] Transferring schema [resource=%s] to directory [path=%s]...", id, schema, liquibase));
            String path = schema.startsWith("/") ? schema.substring(1) : schema;
            log.fine(String.format("[id = %s] LiquibaseSchema path is [path='%s'].", id, path));
            if (path.contains("/")) {
                String dirPath = String.format("%s/%s", liquibase, path.substring(0, path.lastIndexOf(47)));
                log.fine(String.format("[id = %s] LiquibaseSchema path contains intermediate directories [path='%s'], preparing its...", id, dirPath));
                File file2 = new File(dirPath);
                if (!file2.exists() && file2.mkdirs()) {
                    log.info(String.format("[id = %s] Directories for [path='%s'] file created.", id, file2.getAbsolutePath()));
                }
            }
            if ((file = new File(String.format("%s/%s", liquibase, path))).exists()) {
                log.info(String.format("[id = %s] LiquibaseSchema file [path='%s'] already exists, deleting...", id, file.getAbsolutePath()));
                if (file.delete()) {
                    log.info(String.format("[id = %s] File [path='%s'] deleted.", id, file.getAbsolutePath()));
                }
            }
            if (file.createNewFile()) {
                log.info(String.format("[id = %s] File [path='%s'] created.", id, file.getAbsolutePath()));
            }
            log.fine(String.format("[id = %s] LiquibaseSchema file [path='%s'] is ready, copying data...", id, file.getAbsolutePath()));
            FileUtil.write((String)StreamUtil.readStreamAsString((InputStream)is), (File)file);
            String schemaPath = file.getAbsolutePath().replace(ROOT_PATH, "");
            log.info(String.format("[id = %s] Data copied, schema path is [path='%s'].", id, schemaPath));
            string = schemaPath;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                try {
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                catch (IOException ioe) {
                    log.warning(String.format("IOException during closing an input stream '%s'.", ioe.getMessage()), (Throwable)ioe);
                }
                throw throwable;
            }
        }
        try {
            if (is == null) return string;
            is.close();
            return string;
        }
        catch (IOException ioe) {
            log.warning(String.format("IOException during closing an input stream '%s'.", ioe.getMessage()), (Throwable)ioe);
        }
        return string;
    }

    static class AnnotationLiteralDefault
    extends AnnotationLiteral<Liquibase> {
        private static final long serialVersionUID = -2878951947483191L;

        AnnotationLiteralDefault() {
        }
    }
}

