/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.UnsupportedEncodingException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public final class Strings {
    private static final char[] alphaNumeric = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final SecureRandom secureRandom = new SecureRandom();

    private static String getRandom(SecureRandom secureRandom, int length, int start, int len) {
        if (length == 0) {
            return "";
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length must be non-negative: " + length);
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = alphaNumeric[start + secureRandom.nextInt(len)];
        }
        return new String(array);
    }

    public static String getRandomAlphaNumeric(SecureRandom secureRandom, int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length);
    }

    public static String getRandomAlphaNumeric(int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length);
    }

    public static String getRandomAlpha(SecureRandom secureRandom, int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length - 10);
    }

    public static String getRandomAlpha(int len) {
        return Strings.getRandom(secureRandom, len, 0, alphaNumeric.length - 10);
    }

    public static String getRandomNumeric(SecureRandom secureRandom, int len) {
        return Strings.getRandom(secureRandom, len, alphaNumeric.length - 10, 10);
    }

    public static String getRandomNumeric(int len) {
        return Strings.getRandom(secureRandom, len, alphaNumeric.length - 10, 10);
    }

    private static boolean interpolateShallow(StringBuilder text, Map<String, String> properties, String open, String close) {
        boolean changed = false;
        int start = text.length() - close.length() - 1;
        while ((start = text.lastIndexOf(open, start - 1)) > -1) {
            String key;
            String value;
            int end = text.indexOf(close, start + open.length());
            if (end < start || (value = properties.get(key = text.substring(start + open.length(), end))) == null) continue;
            text.replace(start, end + close.length(), value);
            changed = true;
        }
        return changed;
    }

    private static String interpolateDeep(StringBuilder text, Map<String, String> properties, String prefix, String suffix) {
        int max = properties.size() * properties.size();
        int i = 0;
        while (Strings.interpolateShallow(text, properties, prefix, suffix)) {
            if (i == max) {
                throw new IllegalArgumentException("Loop detected");
            }
            ++i;
        }
        return text.toString();
    }

    public static Map<String, String> interpolate(Map<String, String> properties, String prefix, String suffix) {
        Objects.requireNonNull(properties);
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(suffix);
        StringBuilder builder = null;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            if (builder == null) {
                builder = new StringBuilder(value.length());
            } else {
                builder.setLength(0);
            }
            builder.append(value);
            entry.setValue(Strings.interpolateDeep(builder, properties, prefix, suffix));
        }
        return properties;
    }

    public static String interpolate(String text, Map<String, String> properties, String prefix, String suffix) {
        return Strings.interpolateDeep(new StringBuilder(Objects.requireNonNull(text)), Objects.requireNonNull(properties), Objects.requireNonNull(prefix), Objects.requireNonNull(suffix));
    }

    public static boolean replace(StringBuilder builder, CharSequence target, CharSequence replacement) {
        String targetString = target.toString();
        String replaceString = replacement.toString();
        int j = builder.lastIndexOf(targetString);
        if (j < 0) {
            return false;
        }
        int targetLen = targetString.length();
        int targetLen1 = Math.max(targetLen, 1);
        int newLengthHint = builder.length() - targetLen + replaceString.length();
        if (newLengthHint < 0) {
            throw new OutOfMemoryError();
        }
        do {
            builder.replace(j, j + targetLen1, replaceString);
        } while ((j = builder.lastIndexOf(targetString, j - targetLen1)) > -1);
        return true;
    }

    public static boolean replaceAll(StringBuilder builder, CharSequence target, CharSequence replacement) {
        int i = 0;
        while (Strings.replace(builder, target, replacement)) {
            ++i;
        }
        return i > 0;
    }

    public static boolean startsWith(CharSequence str, CharSequence prefix) {
        if (prefix.length() == 0) {
            return true;
        }
        if (str.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (str.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence str, CharSequence suffix) {
        if (suffix.length() == 0) {
            return true;
        }
        if (str.length() < suffix.length()) {
            return false;
        }
        int offset = str.length() - suffix.length();
        for (int i = suffix.length() - 1; i >= 0; --i) {
            if (str.charAt(offset + i) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static StringBuilder toProperCase(StringBuilder builder) {
        boolean nextUpper = true;
        int len = builder.length();
        for (int i = 0; i < len; ++i) {
            char ch = builder.charAt(i);
            if (Character.isWhitespace(ch)) {
                nextUpper = true;
                continue;
            }
            builder.setCharAt(i, nextUpper ? Character.toUpperCase(ch) : Character.toLowerCase(ch));
            nextUpper = false;
        }
        return builder;
    }

    public static StringBuilder toProperCase(String str) {
        return Strings.toProperCase(new StringBuilder(str));
    }

    public static StringBuilder toLowerCase(StringBuilder builder) {
        for (int i = 0; i < builder.length(); ++i) {
            builder.setCharAt(i, Character.toLowerCase(builder.charAt(i)));
        }
        return builder;
    }

    public static StringBuilder toUpperCase(StringBuilder builder) {
        for (int i = 0; i < builder.length(); ++i) {
            builder.setCharAt(i, Character.toUpperCase(builder.charAt(i)));
        }
        return builder;
    }

    private static StringBuilder changeCase(StringBuilder builder, boolean upper, int beginIndex, int endIndex) {
        if (builder.length() == 0) {
            return builder;
        }
        if (beginIndex < 0) {
            throw new IllegalArgumentException("start index (" + beginIndex + ") must be non-negative");
        }
        if (endIndex < beginIndex) {
            throw new IllegalArgumentException("start index (" + beginIndex + ") > end index (" + endIndex + ")");
        }
        if (builder.length() < beginIndex) {
            throw new IllegalArgumentException("start index (" + beginIndex + ") > string length (" + builder.length() + ")");
        }
        if (beginIndex == endIndex) {
            return builder;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            builder.setCharAt(i, upper ? Character.toUpperCase(builder.charAt(i)) : Character.toLowerCase(builder.charAt(i)));
        }
        return builder;
    }

    public static StringBuilder toLowerCase(StringBuilder builder, int beginIndex, int endIndex) {
        return Strings.changeCase(builder, false, beginIndex, endIndex);
    }

    public static StringBuilder toLowerCase(StringBuilder builder, int beginIndex) {
        return Strings.changeCase(builder, false, beginIndex, builder.length());
    }

    public static StringBuilder toUpperCase(StringBuilder builder, int beginIndex, int endIndex) {
        return Strings.changeCase(builder, true, beginIndex, endIndex);
    }

    public static StringBuilder toUpperCase(StringBuilder builder, int beginIndex) {
        return Strings.changeCase(builder, true, beginIndex, builder.length());
    }

    public static String padLeft(String str, int length) {
        return Strings.pad(str, length, false, ' ', false);
    }

    public static String padLeftAll(String str, int length) {
        return Strings.padAll(str, length, false, ' ', false);
    }

    public static String padLeft(String str, int length, boolean truncate) {
        return Strings.pad(str, length, false, ' ', truncate);
    }

    public static String padLeftAll(String str, int length, boolean truncate) {
        return Strings.padAll(str, length, false, ' ', truncate);
    }

    public static String padLeft(String str, int length, char pad) {
        return Strings.pad(str, length, false, pad, false);
    }

    public static String padLeftAll(String str, int length, char pad) {
        return Strings.padAll(str, length, false, pad, false);
    }

    public static String padLeft(String str, int length, char pad, boolean truncate) {
        return Strings.pad(str, length, false, pad, truncate);
    }

    public static String padLeftAll(String str, int length, char pad, boolean truncate) {
        return Strings.padAll(str, length, false, pad, truncate);
    }

    public static String padRight(String str, int length) {
        return Strings.pad(str, length, true, ' ', false);
    }

    public static String padRightAll(String str, int length) {
        return Strings.padAll(str, length, true, ' ', false);
    }

    public static String padRight(String str, int length, boolean truncate) {
        return Strings.pad(str, length, true, ' ', truncate);
    }

    public static String padRightAll(String str, int length, boolean truncate) {
        return Strings.padAll(str, length, true, ' ', truncate);
    }

    public static String padRight(String str, int length, char pad) {
        return Strings.pad(str, length, true, pad, false);
    }

    public static String padRightAll(String str, int length, char pad) {
        return Strings.padAll(str, length, true, pad, false);
    }

    public static String padRight(String str, int length, char pad, boolean truncate) {
        return Strings.pad(str, length, true, pad, truncate);
    }

    public static String padRightAll(String str, int length, char pad, boolean truncate) {
        return Strings.padAll(str, length, true, pad, truncate);
    }

    private static String padAll(String str, int length, boolean right, char pad, boolean truncate) {
        StringBuilder builder = new StringBuilder();
        String[] lines = str.split("[\n\r]");
        for (int i = 0; i < lines.length; ++i) {
            if (i > 0) {
                builder.append('\n');
            }
            builder.append(Strings.pad(lines[i], length, right, pad, truncate));
        }
        return builder.toString();
    }

    private static String pad(String str, int length, boolean right, char pad, boolean truncate) {
        int len = str.length();
        if (length == len) {
            return str;
        }
        if (length < len) {
            if (truncate) {
                return str.substring(0, length);
            }
            throw new IllegalArgumentException("length (" + length + ") must be greater or equal to string length (" + len + ")");
        }
        char[] chars = new char[length];
        if (right) {
            Arrays.fill(chars, len, length, pad);
            for (int i = 0; i < len; ++i) {
                chars[i] = str.charAt(i);
            }
        } else {
            int offset = length - len;
            Arrays.fill(chars, 0, offset, pad);
            for (int i = 0; i < len; ++i) {
                chars[i + offset] = str.charAt(i);
            }
        }
        return new String(chars);
    }

    static String hex(long value, int digits) {
        String hex;
        boolean negative;
        boolean bl = negative = value < 0L;
        if (negative) {
            value = -value;
        }
        if ((hex = Long.toString(value & (1L << 4 * digits) - 1L, 16)).length() < digits) {
            hex = Strings.padLeft(hex, digits, '0');
        }
        return negative ? "-" + hex : hex;
    }

    public static String toUTF8Literal(char ch) {
        return "\\x" + Strings.hex(ch, 2);
    }

    public static String toUTF8Literal(CharSequence str) {
        int len = str.length();
        StringBuilder builder = new StringBuilder(len * 4);
        for (int i = 0; i < len; ++i) {
            builder.append(Strings.toUTF8Literal(str.charAt(i)));
        }
        return builder.toString();
    }

    public static String getAlpha(int n) {
        String string;
        if (n < 26) {
            string = String.valueOf((char)(97 + n));
        } else {
            int scale = n / 26;
            string = Strings.getAlpha(scale - 1) + (char)(97 + n - scale * 26);
        }
        return string;
    }

    public static String getCommonPrefix(String ... strings) {
        if (strings == null || strings.length == 0) {
            return null;
        }
        if (strings.length == 1) {
            return strings[0];
        }
        for (int i = 0; i < strings[0].length(); ++i) {
            for (int j = 1; j < strings.length; ++j) {
                if (i != strings[j].length() && strings[0].charAt(i) == strings[j].charAt(i)) continue;
                return strings[0].substring(0, i);
            }
        }
        return strings[0];
    }

    public static String getCommonPrefix(Collection<String> strings) {
        if (strings == null || strings.size() == 0) {
            return null;
        }
        Iterator<String> iterator = strings.iterator();
        if (strings.size() == 1) {
            return iterator.next();
        }
        String string0 = iterator.next();
        for (int i = 0; i < string0.length(); ++i) {
            if (i > 0) {
                iterator = strings.iterator();
                iterator.next();
            }
            while (iterator.hasNext()) {
                String next = iterator.next();
                if (i != next.length() && string0.charAt(i) == next.charAt(i)) continue;
                return string0.substring(0, i);
            }
        }
        return string0;
    }

    public static String escapeForJava(String str) {
        return str == null ? null : str.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    public static String printColumns(String ... columns) {
        String[][] strings = new String[columns.length][];
        int maxLines = 0;
        for (int i = 0; i < columns.length; ++i) {
            String[] stringArray = strings[i] = columns[i] == null ? null : columns[i].split("\n");
            if (strings[i] == null || strings[i].length <= maxLines) continue;
            maxLines = strings[i].length;
        }
        int[] widths = new int[columns.length];
        int maxWidth = 0;
        for (int i = 0; i < columns.length; ++i) {
            if (strings[i] != null) {
                for (int j = 0; j < strings[i].length; ++j) {
                    if (strings[i][j].length() <= maxWidth) continue;
                    maxWidth = strings[i][j].length();
                }
            } else if (maxWidth < 4) {
                maxWidth = 4;
            }
            widths[i] = maxWidth + 1;
        }
        StringBuilder builder = new StringBuilder();
        for (int j = 0; j < maxLines; ++j) {
            if (j > 0) {
                builder.append('\n');
            }
            for (int i = 0; i < strings.length; ++i) {
                String line = strings[i] == null ? "null" : (j < strings[i].length ? strings[i][j] : "");
                builder.append(String.format("%-" + widths[i] + "s", line));
            }
        }
        return builder.length() == 0 ? "null" : builder.toString();
    }

    public static String repeat(char ch, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        if (count == 0) {
            return "";
        }
        char[] chars = new char[count];
        Arrays.fill(chars, ch);
        return new String(chars);
    }

    public static String repeat(String str, int count) {
        int n;
        if (count < 0) {
            throw new IllegalArgumentException("count < 0");
        }
        if (count == 0 || str.length() == 0) {
            return "";
        }
        if (count == 1) {
            return str;
        }
        int length = str.length();
        long longSize = (long)length * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + longSize);
        }
        char[] chars = new char[size];
        str.getChars(0, length, chars, 0);
        for (n = length; n < size - n; n <<= 1) {
            System.arraycopy(chars, 0, chars, n, n);
        }
        System.arraycopy(chars, 0, chars, n, size - n);
        return new String(chars);
    }

    public static byte[] getBytes(String str, String charsetName) {
        try {
            return str.getBytes(charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    public static String trim(String str, char ch) {
        if (str == null) {
            return null;
        }
        int i = -1;
        int len = str.length();
        while (++i < len && str.charAt(i) == ch) {
        }
        if (i == len) {
            return "";
        }
        int j = len;
        while (j > i && str.charAt(--j) == ch) {
        }
        return i == 0 && j == len - 1 ? str : str.substring(i, j + 1);
    }

    public static int lastIndexOf(CharSequence str, char ch) {
        return Strings.lastIndexOf0(str, ch, str.length() - 1);
    }

    public static int lastIndexOf(CharSequence str, char ch, int fromIndex) {
        return Strings.lastIndexOf0(str, ch, fromIndex);
    }

    private static int lastIndexOf0(CharSequence str, char ch, int fromIndex) {
        for (int i = Math.min(fromIndex, str.length() - 1); i >= 0; --i) {
            if (str.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfUnEscaped(CharSequence str, char ch, int fromIndex) {
        boolean escaped = false;
        int len = str.length();
        for (int i = Math.max(fromIndex, 0); i < len; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                if (c == '\\' && ch == '\\') {
                    return i;
                }
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfUnEscaped(CharSequence str, char ch) {
        return Strings.indexOfUnEscaped(str, ch, 0);
    }

    public static int lastIndexOfUnEscaped(CharSequence str, char ch) {
        return Strings.lastIndexOfUnEscaped(str, ch, str.length() - 1);
    }

    public static int lastIndexOfUnEscaped(CharSequence str, char ch, int fromIndex) {
        int i;
        do {
            i = Strings.lastIndexOf(str, ch, fromIndex);
            int count = 0;
            for (int j = i - 1; j >= 0 && str.charAt(j) == '\\'; --j) {
                ++count;
            }
            if (count % 2 != 0) continue;
            return i;
        } while ((fromIndex = i - 1) > 0);
        return -1;
    }

    public static int indexOfUnQuoted(CharSequence str, char ch, int fromIndex) {
        boolean escaped = false;
        boolean quoted = false;
        int len = str.length();
        for (int i = Math.max(fromIndex, 0); i < len; ++i) {
            char c = str.charAt(i);
            if (escaped) {
                escaped = false;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == ch && !quoted) {
                return i;
            }
            if (c != '\"') continue;
            quoted = !quoted;
        }
        return -1;
    }

    public static int indexOfUnQuoted(CharSequence str, char ch) {
        return Strings.indexOfUnQuoted(str, ch, 0);
    }

    public static int lastIndexOfUnQuoted(CharSequence str, char ch, int fromIndex) {
        boolean esacped = false;
        boolean quoted = false;
        char n = '\u0000';
        int end = str.length() - 1;
        for (int i = Math.min(fromIndex, end); i >= 0; --i) {
            char c = str.charAt(i);
            if (c == '\\') {
                esacped = true;
            } else if (esacped) {
                esacped = false;
            } else {
                if (n == ch && !quoted) {
                    return i + 1;
                }
                if (n == '\"') {
                    quoted = !quoted;
                }
            }
            n = c;
        }
        return n == ch ? 0 : -1;
    }

    public static int lastIndexOfUnQuoted(CharSequence str, char ch) {
        return Strings.lastIndexOfUnQuoted(str, ch, str.length());
    }

    public static String truncate(String str, int maxLength) {
        if (maxLength < 3) {
            throw new IllegalArgumentException("length must be >= 3: " + maxLength);
        }
        return maxLength == 3 ? "..." : (str.length() > maxLength ? str.substring(0, maxLength - 3).concat("...") : str);
    }

    public static String flipFirstCap(String str) {
        if (str.length() == 0) {
            return str;
        }
        boolean hasLower = false;
        boolean hasUpper = false;
        for (int i = 1; i < str.length(); ++i) {
            hasLower = hasLower || Character.isLowerCase(str.charAt(i));
            boolean bl = hasUpper = hasUpper || Character.isUpperCase(str.charAt(i));
            if (hasLower && hasUpper) break;
        }
        if (hasUpper && !hasLower) {
            return str;
        }
        char ch = str.charAt(0);
        return (Character.isLowerCase(ch) ? Character.toUpperCase(ch) : Character.toLowerCase(ch)) + str.substring(1);
    }

    private static void appendElVar(Map<String, String> variables, StringBuilder builder, StringBuilder var) {
        String name = var.toString();
        String value = variables.get(name);
        if (value != null) {
            builder.append(value);
        } else {
            builder.append('$').append('{').append(name).append('}');
        }
        var.setLength(0);
    }

    private static void appendElNoMatch(StringBuilder builder, StringBuilder var, char close) {
        builder.append('$').append('{');
        if (var.length() > 0) {
            builder.append((CharSequence)var);
            var.setLength(0);
        }
        if (close != '\u0000') {
            builder.append(close);
        }
    }

    public static String derefEL(String s, Map<String, String> variables) {
        if (s.length() < 4) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder var = new StringBuilder();
        boolean escape = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (var.length() > 0) {
                    builder.append('$').append('{').append((CharSequence)var);
                    var.setLength(0);
                }
                if (escape = !escape) continue;
                builder.append(ch);
                continue;
            }
            if (!escape) {
                if (ch == '$') {
                    if (var.length() > 0) {
                        Strings.appendElVar(variables, builder, var);
                    }
                    if (++i == len) {
                        builder.append('$');
                        continue;
                    }
                    ch = s.charAt(i);
                    if (ch != '{') {
                        var.setLength(0);
                        builder.append('$');
                        if (ch == '\\') continue;
                        builder.append(ch);
                        continue;
                    }
                    if (++i == len) {
                        Strings.appendElNoMatch(builder, var, '\u0000');
                        continue;
                    }
                    ch = s.charAt(i);
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '_') {
                        var.append(ch);
                        continue;
                    }
                    Strings.appendElNoMatch(builder, var, ch);
                    continue;
                }
                if (var.length() > 0) {
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_') {
                        var.append(ch);
                        continue;
                    }
                    if (ch != '}') {
                        Strings.appendElNoMatch(builder, var, ch);
                        continue;
                    }
                    Strings.appendElVar(variables, builder, var);
                    if (ch == '}') continue;
                    builder.append(ch);
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (var.length() > 0) {
                Strings.appendElVar(variables, builder, var);
            }
            builder.append(ch);
            escape = false;
        }
        if (var.length() > 0) {
            Strings.appendElNoMatch(builder, var, '\u0000');
        }
        return builder.toString();
    }

    private static void appendEvVar(Map<String, String> variables, StringBuilder builder, StringBuilder var) {
        String variable = variables.get(var.toString());
        if (variable != null) {
            builder.append(variable);
        }
        var.setLength(0);
    }

    public static String derefEV(String s, Map<String, String> variables) throws ParseException {
        if (s.length() < 2) {
            return s;
        }
        StringBuilder builder = new StringBuilder();
        StringBuilder var = new StringBuilder();
        boolean escape = false;
        boolean bracket = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (var.length() > 0) {
                    Strings.appendEvVar(variables, builder, var);
                }
                if (escape = !escape) continue;
                builder.append(ch);
                continue;
            }
            if (!escape) {
                if (ch == '$') {
                    if (var.length() > 0) {
                        Strings.appendEvVar(variables, builder, var);
                    }
                    if (++i == len) {
                        builder.append('$');
                        continue;
                    }
                    ch = s.charAt(i);
                    if (ch == '$') {
                        throw new ParseException("$$: not supported", i);
                    }
                    if (ch == '{') {
                        bracket = true;
                        if (++i == len) {
                            throw new ParseException("${: bad substitution", i);
                        }
                        ch = s.charAt(i);
                    }
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || ch == '_') {
                        var.append(ch);
                        continue;
                    }
                    if (!bracket) {
                        builder.append('$');
                        if (ch == '\\') continue;
                        builder.append(ch);
                        continue;
                    }
                    throw new ParseException("${" + ch + ": bad substitution", i);
                }
                if (var.length() > 0) {
                    if ('a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_') {
                        var.append(ch);
                        continue;
                    }
                    if (bracket && ch != '}') {
                        throw new ParseException("${" + var + ch + ": bad substitution", i);
                    }
                    Strings.appendEvVar(variables, builder, var);
                    if (bracket && ch == '}') continue;
                    builder.append(ch);
                    continue;
                }
                builder.append(ch);
                continue;
            }
            if (var.length() > 0) {
                Strings.appendEvVar(variables, builder, var);
            }
            builder.append(ch);
            escape = false;
        }
        if (var.length() > 0) {
            if (bracket) {
                throw new ParseException("${" + var + ": bad substitution", len);
            }
            Strings.appendEvVar(variables, builder, var);
        }
        return builder.toString();
    }

    public static boolean isWhitespace(CharSequence str) {
        if (str == null) {
            return false;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence builder) {
        if (builder.length() == 0) {
            throw new IllegalArgumentException("Empty string");
        }
        int len = builder.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLowerCase(builder.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(CharSequence builder) {
        if (builder.length() == 0) {
            throw new IllegalArgumentException("Empty string");
        }
        int len = builder.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isUpperCase(builder.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String requireLettersOrDigits(String token) {
        if (token == null) {
            return null;
        }
        for (int i = 0; i < token.length(); ++i) {
            char ch = token.charAt(i);
            if (Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException(token);
        }
        return token;
    }

    public static long hash(CharSequence str) {
        long hash = 0L;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            hash = 31L * hash + (long)str.charAt(i);
        }
        return hash;
    }

    public static StringBuilder indent(String str, int spaces) {
        return Strings.indent(new StringBuilder(str), spaces);
    }

    public static StringBuilder indent(StringBuilder str, int spaces) {
        if (spaces == 0) {
            return str;
        }
        String replacement = "\n" + Strings.repeat(' ', spaces);
        Strings.replace(str, "\n\n", "\u0007\n");
        Strings.replace(str, "\n", replacement);
        Strings.replace(str, "\u0007", "\n");
        return str;
    }

    public static boolean regionMatches(CharSequence str, boolean ignoreCase, int strOffset, CharSequence substr, int substrOffset, int len) {
        if (str instanceof String && substr instanceof String) {
            return ((String)str).regionMatches(ignoreCase, strOffset, (String)substr, substrOffset, len);
        }
        if (substrOffset < 0 || strOffset < 0 || (long)strOffset > (long)str.length() - (long)len || (long)substrOffset > (long)substr.length() - (long)len) {
            return false;
        }
        int i1 = strOffset;
        int i2 = substrOffset;
        while (len-- > 0) {
            char c2;
            char c1 = str.charAt(i1);
            if (c1 != (c2 = substr.charAt(i2))) {
                if (!ignoreCase) {
                    return false;
                }
                if (Character.toUpperCase(c1) != Character.toUpperCase(c2) && Character.toLowerCase(c1) != Character.toLowerCase(c2)) {
                    return false;
                }
            }
            ++i1;
            ++i2;
        }
        return true;
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence substr) {
        return Strings.indexOfIgnoreCase(str, substr, 0);
    }

    public static int indexOfIgnoreCase(CharSequence str, CharSequence substr, int fromIndex) {
        int len;
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex > (len = str.length() - substr.length() + 1)) {
            return -1;
        }
        if (substr.length() == 0) {
            return fromIndex;
        }
        for (int i = fromIndex; i < len; ++i) {
            if (!Strings.regionMatches(str, true, i, substr, 0, substr.length())) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(CharSequence str, CharSequence substr) {
        return Strings.indexOfIgnoreCase(str, substr) > -1;
    }

    private Strings() {
    }
}

