/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class Resources {
    public static void walk(ClassLoader classLoader, String name, ForEachEntry forEachEntry) throws IOException {
        Resources.traverse(classLoader.getResources(name), name, true, forEachEntry);
    }

    public static void list(ClassLoader classLoader, String name, ForEachEntry forEachEntry) throws IOException {
        Resources.traverse(classLoader.getResources(name), name, false, forEachEntry);
    }

    public static void traverse(Enumeration<URL> resources, String name, boolean recursive, ForEachEntry forEachEntry) throws IOException {
        if (!resources.hasMoreElements()) {
            return;
        }
        Reporter reporter = null;
        do {
            URL url;
            if ("file".equals((url = resources.nextElement()).getProtocol())) {
                String decodedUrl;
                try {
                    decodedUrl = URLDecoder.decode(url.getPath(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    decodedUrl = url.getPath();
                }
                File file = new File(decodedUrl);
                Path path = file.toPath();
                if (reporter == null) {
                    reporter = new Reporter(forEachEntry);
                }
                reporter.update(url, new File(decodedUrl.substring(0, decodedUrl.length() - name.length())).toPath());
                if (file.isFile()) {
                    reporter.test(path);
                    continue;
                }
                if (recursive) {
                    Files.walk(path, new FileVisitOption[0]).allMatch(reporter);
                    continue;
                }
                if (name.length() == 0 && !forEachEntry.test(url, "/", true)) {
                    return;
                }
                Files.list(path).allMatch(reporter);
                continue;
            }
            if ("jar".equals(url.getProtocol())) {
                JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
                jarURLConnection.setUseCaches(false);
                try (JarFile jarFile = jarURLConnection.getJarFile();){
                    String rootName = jarURLConnection.getEntryName();
                    if (name.length() == 0) {
                        forEachEntry.test(url, "/", true);
                    }
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        int s;
                        JarEntry entry = enumeration.nextElement();
                        String entryName = entry.getName();
                        int prefix = entryName.startsWith(rootName) ? rootName.length() : (entryName.startsWith(name) ? name.length() : 0);
                        if (prefix == 0 || !recursive && (s = entryName.indexOf(47, prefix + 1)) != -1 && s != entryName.length() - 1) continue;
                        forEachEntry.test(url, entryName, entry.isDirectory());
                    }
                }
            } else {
                throw new UnsupportedOperationException("Unsupported URL protocol: " + url);
            }
        } while (resources.hasMoreElements());
    }

    public static URL getResourceOrFile(String name) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource(name);
        if (resource != null) {
            return resource;
        }
        File file = new File(name);
        if (!file.exists()) {
            return null;
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(name, e);
        }
    }

    public static URL getFileOrResource(String name) {
        File file = new File(name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(name, e);
            }
        }
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    private Resources() {
    }

    private static class Reporter
    implements Predicate<Path> {
        private final ForEachEntry callback;
        private URL url;
        private Path path;

        private Reporter(ForEachEntry callback) {
            this.callback = callback;
        }

        private void update(URL url, Path path) {
            this.url = url;
            this.path = path;
        }

        @Override
        public boolean test(Path entry) {
            boolean isDirectory = entry.toFile().isDirectory();
            String relativePath = this.path.relativize(entry).toString();
            return this.callback.test(this.url, isDirectory ? relativePath + File.separator : relativePath, isDirectory);
        }
    }

    @FunctionalInterface
    public static interface ForEachEntry {
        public boolean test(URL var1, String var2, boolean var3);
    }
}

