/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.function.BiPredicate;

public final class Repeat {
    private static final Algorithm iterative = new Algorithm(){

        @Override
        protected <M, A> M[] simple(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg) {
            super.simple(array, type, predicate, arg);
            ArrayList<M> list = new ArrayList<M>(array.length);
            for (int i = 0; i < array.length; ++i) {
                if (!predicate.test(array[i], arg)) continue;
                list.add(array[i]);
            }
            return list.toArray((Object[])Array.newInstance(type, list.size()));
        }
    };

    public static <M, A> M[] iterative(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg) {
        return iterative.simple(array, type, predicate, arg);
    }

    private Repeat() {
    }

    public static final class Recursive {
        private static final RecursiveAlgorithm recursiveOrdered = new RecursiveAlgorithm(){

            @Override
            protected <M, A> M[] recurse(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg, int index, int depth) {
                M member;
                boolean skip;
                if (index >= array.length) {
                    return (Object[])Array.newInstance(type, depth);
                }
                while ((skip = !predicate.test(member = array[index++], arg)) && index < array.length) {
                }
                M[] result = this.recurse(array, type, predicate, arg, index, skip ? depth : depth + 1);
                if (!skip) {
                    result[depth] = member;
                }
                return result;
            }

            @Override
            protected <C, M, A> M[] recurse(C container, M[] array, Class<M> type, Recurser<C, M, A> recurser, A arg, int index, int depth) {
                M member;
                boolean skip;
                if (index == array.length) {
                    C parent = recurser.next(container);
                    return parent == null ? (Object[])Array.newInstance(type, depth) : this.recurse(parent, recurser.members(parent), type, recurser, arg, 0, depth);
                }
                while ((skip = !recurser.test(member = array[index++], arg)) && index < array.length) {
                }
                M[] result = this.recurse(container, array, type, recurser, arg, index, skip ? depth : depth + 1);
                if (!skip) {
                    result[depth] = member;
                }
                return result;
            }
        };
        private static final RecursiveAlgorithm recursiveInverted = new RecursiveAlgorithm(){

            @Override
            protected <M, A> M[] recurse(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg, int index, int depth) {
                M member;
                boolean skip;
                if (index == array.length) {
                    return (Object[])Array.newInstance(type, depth);
                }
                while ((skip = !predicate.test(member = array[array.length - ++index], arg)) && index < array.length) {
                }
                M[] result = this.recurse(array, type, predicate, arg, index, skip ? depth : depth + 1);
                if (!skip) {
                    result[result.length - 1 - depth] = member;
                }
                return result;
            }

            @Override
            protected <C, M, A> M[] recurse(C container, M[] array, Class<M> type, Recurser<C, M, A> recurser, A arg, int index, int depth) {
                M member;
                boolean skip;
                if (index == array.length) {
                    C parent = recurser.next(container);
                    return parent == null ? (Object[])Array.newInstance(type, depth) : this.recurse(parent, recurser.members(parent), type, recurser, arg, 0, depth);
                }
                while ((skip = !recurser.test(member = array[array.length - ++index], arg)) && index < array.length) {
                }
                M[] result = this.recurse(container, array, type, recurser, arg, index, skip ? depth : depth + 1);
                if (!skip) {
                    result[result.length - 1 - depth] = member;
                }
                return result;
            }
        };

        public static <M, A> M[] ordered(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg) {
            return recursiveOrdered.simple(array, type, predicate, arg);
        }

        public static <C, M, A> M[] ordered(C container, M[] array, Class<M> type, Recurser<C, M, A> recurser, A arg) {
            return recursiveOrdered.contained(container, array, type, recurser, arg);
        }

        public static <M, A> M[] inverted(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg) {
            return recursiveInverted.simple(array, type, predicate, arg);
        }

        public static <C, M, A> M[] inverted(C container, M[] array, Class<M> type, Recurser<C, M, A> recurser, A arg) {
            return recursiveInverted.contained(container, array, type, recurser, arg);
        }

        private Recursive() {
        }

        private static abstract class RecursiveAlgorithm
        extends Algorithm {
            private RecursiveAlgorithm() {
            }

            @Override
            protected <M, A> M[] simple(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg) {
                super.simple(array, type, predicate, arg);
                return this.recurse(array, type, predicate, arg, 0, 0);
            }

            protected <C, M, A> M[] contained(C container, M[] array, Class<M> type, Recurser<C, M, A> recurser, A arg) {
                if (array == null) {
                    return null;
                }
                if (type == null) {
                    throw new IllegalArgumentException("type == null");
                }
                if (recurser == null) {
                    throw new IllegalArgumentException("recurser == null");
                }
                return this.recurse(container, array, type, recurser, arg, 0, 0);
            }

            protected abstract <M, A> M[] recurse(M[] var1, Class<M> var2, BiPredicate<? super M, A> var3, A var4, int var5, int var6);

            protected abstract <C, M, A> M[] recurse(C var1, M[] var2, Class<M> var3, Recurser<C, M, A> var4, A var5, int var6, int var7);
        }
    }

    private static abstract class Algorithm {
        private Algorithm() {
        }

        protected <M, A> M[] simple(M[] array, Class<M> type, BiPredicate<? super M, A> predicate, A arg) {
            if (array == null) {
                return null;
            }
            if (type == null) {
                throw new NullPointerException("type == null");
            }
            if (predicate == null) {
                throw new NullPointerException("predicate == null");
            }
            return null;
        }
    }

    public static interface Recurser<C, M, A>
    extends BiPredicate<M, A> {
        public M[] members(C var1);

        public C next(C var1);
    }
}

