/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.libj.lang.Strings;

public final class Identifiers {
    private static final Pattern unqualifiedJavaIdentifierPattern = Pattern.compile("[a-zA-Z_$][a-zA-Z\\d_$]*");
    private static final Pattern qualifiedJavaIdentifierPattern = Pattern.compile("((" + unqualifiedJavaIdentifierPattern + ")\\.)*" + unqualifiedJavaIdentifierPattern.pattern());
    private static final String[] reservedWords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final char[] discardTokens = new char[]{'!', '\"', '#', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~'};

    public static boolean isValid(String identifier, boolean qualified) {
        return (qualified ? qualifiedJavaIdentifierPattern : unqualifiedJavaIdentifierPattern).matcher(identifier).matches();
    }

    public static boolean isValid(String identifier) {
        return Identifiers.isValid(identifier, true);
    }

    private static void checkPrefix(char prefix) {
        if (prefix != '\u0000' && !Character.isJavaIdentifierStart(prefix)) {
            throw new IllegalArgumentException("Illegal prefix character: " + prefix);
        }
    }

    private static void checkSubstitutes(Map<Character, String> substitutes) {
        if (substitutes != null) {
            for (String substitute : substitutes.values()) {
                for (int i = 0; i < substitute.length(); ++i) {
                    if (Character.isJavaIdentifierPart(substitute.charAt(i))) continue;
                    throw new IllegalArgumentException("Substitution \"" + substitute + "\" contains illegal character: " + substitute.charAt(i));
                }
            }
        }
    }

    private static boolean substitute(StringBuilder builder, boolean start, char ch, char substitute, Map<Character, String> substitutes, Function<? super Character, String> function) {
        if (function != null) {
            String replacement = function.apply(Character.valueOf(ch));
            if (replacement != null) {
                for (int i = 0; i < replacement.length(); ++i) {
                    if (!(start && i == 0 ? !Character.isJavaIdentifierStart(replacement.charAt(i)) : !Character.isJavaIdentifierPart(replacement.charAt(i)))) continue;
                    throw new IllegalArgumentException("Substitution \"" + replacement + "\" contains illegal " + (start ? "start " : "") + "character: '" + replacement.charAt(i) + "'");
                }
                builder.append(replacement);
            }
        } else if (substitutes != null) {
            String replacement = substitutes.get(Character.valueOf(ch));
            if (replacement != null) {
                builder.append(replacement);
            }
        } else if (substitute != '\u0000') {
            builder.append(substitute);
        } else {
            return false;
        }
        return true;
    }

    public static boolean isReservedWord(String word) {
        return Arrays.binarySearch(reservedWords, word) >= 0;
    }

    private static String transformNotReserved(char prefix, char suffix, Map<Character, String> substitutes, Function<Character, String> function, StringBuilder builder) {
        String pre;
        String word = builder.toString();
        if (!Identifiers.isReservedWord(word)) {
            return word;
        }
        if (suffix != '\u0000') {
            return builder.append(suffix).toString();
        }
        if (prefix != '\u0000') {
            return builder.insert(0, prefix).toString();
        }
        String string = substitutes != null ? substitutes.get(null) : (pre = function != null ? function.apply(null) : null);
        if (pre != null) {
            return pre + word;
        }
        throw new IllegalArgumentException("Unable to transform reserved word due to unspecified prefix, suffix, nor 'null' substitution rule: " + word);
    }

    public static String toIdentifier(String string, char prefix, char substitute, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', substitutes, null, Identifiers.toIdentifier0(string, prefix, substitute, substitutes, null));
    }

    public static String toIdentifier(String string, Map<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '\u0000', substitutes, null, Identifiers.toIdentifier0(string, '_', '\u0000', substitutes, null));
    }

    public static String toIdentifier(String string, char prefix, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', substitutes, null, Identifiers.toIdentifier0(string, prefix, '\u0000', substitutes, null));
    }

    public static String toIdentifier(String string, char prefix, Function<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, substitutes, Identifiers.toIdentifier0(string, prefix, '\u0000', null, substitutes));
    }

    public static String toIdentifier(String string, char prefix, char substitute) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, null, Identifiers.toIdentifier0(string, prefix, substitute, null, null));
    }

    public static String toIdentifier(String string, char prefix) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, null, Identifiers.toIdentifier0(string, prefix, '\u0000', null, null));
    }

    public static String toIdentifier(String string, Function<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '\u0000', null, substitutes, Identifiers.toIdentifier0(string, '_', '\u0000', null, substitutes));
    }

    public static String toIdentifier(String string) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '\u0000', null, null, Identifiers.toIdentifier0(string, '_', '\u0000', null, null));
    }

    private static StringBuilder toIdentifier0(String string, char prefix, char substitute, Map<Character, String> substitutes, Function<? super Character, String> function) {
        int i;
        Identifiers.checkPrefix(prefix);
        Identifiers.checkSubstitutes(substitutes);
        StringBuilder builder = new StringBuilder(string.length());
        if (string.length() == 0) {
            return builder;
        }
        char[] chars = string.toCharArray();
        char ch = '\u0000';
        for (i = 0; i < chars.length; ++i) {
            ch = chars[i];
            if (Character.isJavaIdentifierStart(ch)) {
                builder.append(ch);
                break;
            }
            if (Character.isJavaIdentifierPart(ch) && prefix != '\u0000') {
                builder.append(prefix).append(ch);
                break;
            }
            if (Identifiers.substitute(builder, prefix == '\u0000', ch, substitute, substitutes, function)) break;
        }
        if (!(Character.isJavaIdentifierStart(ch) || builder.length() != 0 && Character.isJavaIdentifierStart(builder.charAt(0)))) {
            if (prefix != '\u0000') {
                builder.insert(0, "_");
            } else {
                throw new IllegalArgumentException("Unspecified prefix or substitution for illegal start character: " + ch);
            }
        }
        ++i;
        while (i < chars.length) {
            ch = chars[i];
            if (Character.isJavaIdentifierPart(ch)) {
                builder.append(ch);
            } else {
                Identifiers.substitute(builder, i == 0, ch, substitute, substitutes, function);
            }
            ++i;
        }
        return builder;
    }

    public static String toPackageCase(String string, Function<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '_', null, substitutes, Identifiers.toPackageCase0(string, '_', '_', null, substitutes));
    }

    public static String toPackageCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '_', null, null, Identifiers.toPackageCase0(string, '_', '_', null, null));
    }

    private static StringBuilder toPackageCase0(String string, char prefix, char substitute, Map<Character, String> substitutes, Function<? super Character, String> function) {
        return Strings.toLowerCase(Identifiers.toIdentifier0(string, prefix, substitute, substitutes, function));
    }

    public static String toCamelCase(String string, char prefix, char substitute, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', substitutes, null, Identifiers.toCamelCase0(string, prefix, substitute, substitutes, null));
    }

    public static String toCamelCase(String string, char prefix, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', substitutes, null, Identifiers.toCamelCase0(string, prefix, '\u0000', substitutes, null));
    }

    public static String toCamelCase(String string, char prefix, char substitute) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, null, Identifiers.toCamelCase0(string, prefix, substitute, null, null));
    }

    public static String toCamelCase(String string, char prefix, Function<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, substitutes, Identifiers.toCamelCase0(string, prefix, '\u0000', null, substitutes));
    }

    public static String toCamelCase(String string, char prefix) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, null, Identifiers.toCamelCase0(string, prefix, '\u0000', null, null));
    }

    public static String toCamelCase(String string, Function<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 120;
        return Identifiers.transformNotReserved('x', '\u0000', null, substitutes, Identifiers.toCamelCase0(string, 'x', '\u0000', null, substitutes));
    }

    public static String toCamelCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 120;
        return Identifiers.transformNotReserved('x', '\u0000', null, null, Identifiers.toCamelCase0(string, 'x', '\u0000', null, null));
    }

    public static String toCamelCase(String string, Map<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 120;
        StringBuilder builder = Identifiers.toCamelCase0(string, 'x', '\u0000', substitutes, null);
        return Identifiers.transformNotReserved('x', '\u0000', substitutes, null, builder);
    }

    private static StringBuilder toCamelCase0(String string, char prefix, char substitute, Map<Character, String> substitutes, Function<? super Character, String> function) {
        Identifiers.checkPrefix(prefix);
        Identifiers.checkSubstitutes(substitutes);
        StringBuilder builder = new StringBuilder(string.length());
        if (string.length() == 0) {
            return builder;
        }
        int startUpper = -1;
        char[] chars = string.toCharArray();
        boolean capNext = false;
        for (int i = 0; i < chars.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(chars[i])) {
                if (prefix != '\u0000') {
                    builder.append(prefix);
                } else if (Identifiers.substitute(builder, i == 0, chars[i], substitute, substitutes, function)) {
                    ++i;
                } else {
                    throw new IllegalArgumentException("Unspecified prefix or substitution for illegal start character: " + chars[i]);
                }
            }
            char ch = chars[i];
            if (startUpper == -1 && Character.isUpperCase(ch)) {
                startUpper = i;
            } else if (startUpper != -1 && Character.isLowerCase(ch)) {
                startUpper = -1;
            }
            int index = Arrays.binarySearch(discardTokens, ch);
            if (index >= 0) {
                if (startUpper != -1) {
                    for (int j = startUpper + 1; j < i; ++j) {
                        builder.setCharAt(j, Character.toLowerCase(builder.charAt(j)));
                    }
                    startUpper = -1;
                }
                capNext = i != 0;
                Identifiers.substitute(builder, i == 0, ch, substitute, substitutes, function);
                continue;
            }
            if (capNext) {
                builder.append(Character.toUpperCase(ch));
                capNext = false;
                continue;
            }
            builder.append(ch);
        }
        return builder;
    }

    public static String toInstanceCase(String string, char prefix, char substitute, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', substitutes, null, Identifiers.toInstanceCase0(string, prefix, substitute, substitutes, null));
    }

    public static String toInstanceCase(String string, char prefix, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', substitutes, null, Identifiers.toInstanceCase0(string, prefix, '\u0000', substitutes, null));
    }

    public static String toInstanceCase(String string, char prefix, Function<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, substitutes, Identifiers.toInstanceCase0(string, prefix, '\u0000', null, substitutes));
    }

    public static String toInstanceCase(String string, char prefix, char substitute) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, null, Identifiers.toInstanceCase0(string, prefix, substitute, null, null));
    }

    public static String toInstanceCase(String string, char prefix) {
        return string.length() == 0 ? string : Identifiers.transformNotReserved(prefix, '\u0000', null, null, Identifiers.toInstanceCase0(string, prefix, '\u0000', null, null));
    }

    public static String toInstanceCase(String string, Map<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '\u0000', substitutes, null, Identifiers.toInstanceCase0(string, '_', '\u0000', substitutes, null));
    }

    public static String toInstanceCase(String string, Function<Character, String> substitutes) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '\u0000', null, substitutes, Identifiers.toInstanceCase0(string, '_', '\u0000', null, substitutes));
    }

    public static String toInstanceCase(String string) {
        if (string.length() == 0) {
            return string;
        }
        int prefix = 95;
        return Identifiers.transformNotReserved('_', '\u0000', null, null, Identifiers.toInstanceCase0(string, '_', '\u0000', null, null));
    }

    private static StringBuilder toInstanceCase0(String string, char prefix, char substitute, Map<Character, String> substitutes, Function<? super Character, String> function) {
        int i;
        StringBuilder builder = Identifiers.toCamelCase0(string, prefix, substitute, substitutes, function);
        int len = builder.length();
        if (len == 0) {
            return builder;
        }
        if (len == 1) {
            if (Character.isUpperCase(builder.charAt(0))) {
                builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
            }
            return builder;
        }
        for (i = 0; i < len && Character.isUpperCase(builder.charAt(i)); ++i) {
        }
        if (i == 0) {
            return builder;
        }
        if (i == len) {
            return Strings.toLowerCase(builder);
        }
        if (i == 1) {
            builder.setCharAt(0, Character.toLowerCase(builder.charAt(0)));
            return builder;
        }
        for (int j = 0; j < i - 1; ++j) {
            builder.setCharAt(j, Character.toLowerCase(builder.charAt(j)));
        }
        return builder;
    }

    private static String toClassCase(StringBuilder builder) {
        if (Strings.isUpperCase(builder)) {
            return Strings.toLowerCase(builder, 1, builder.length()).toString();
        }
        if (!Character.isUpperCase(builder.charAt(0))) {
            builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        }
        return builder.toString();
    }

    public static String toClassCase(String string, char prefix, char substitute, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, prefix, substitute, substitutes, null));
    }

    public static String toClassCase(String string, char prefix, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, prefix, '\u0000', substitutes, null));
    }

    public static String toClassCase(String string, char prefix, Function<? super Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, prefix, '\u0000', null, substitutes));
    }

    public static String toClassCase(String string, char prefix, char substitute) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, prefix, substitute, null, null));
    }

    public static String toClassCase(String string, char prefix) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, prefix, '\u0000', null, null));
    }

    public static String toClassCase(String string, Map<Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, 'X', '\u0000', substitutes, null));
    }

    public static String toClassCase(String string, Function<? super Character, String> substitutes) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, 'X', '\u0000', null, substitutes));
    }

    public static String toClassCase(String string) {
        return string.length() == 0 ? string : Identifiers.toClassCase(Identifiers.toCamelCase0(string, 'X', '\u0000', null, null));
    }

    private Identifiers() {
    }
}

