/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.libj.lang.Identifiers;
import org.libj.lang.Repeat;

public final class Classes {
    private static final Repeat.Recurser<Class<?>, Field, Object> declaredFieldRecurser = (member, arg) -> true;
    private static final Repeat.Recurser<Class<?>, Field, Predicate<Field>> declaredFieldWithPredicateRecurser = (member, arg) -> arg.test(member);
    private static final Repeat.Recurser<Class<?>, Field, Class<? extends Annotation>> declaredFieldWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final Repeat.Recurser<Class<?>, Method, Object> declaredMethodRecurser = (member, arg) -> true;
    private static final Repeat.Recurser<Class<?>, Method, Predicate<Method>> declaredMethodWithPredicateRecurser = (member, arg) -> arg.test(member);
    private static final Repeat.Recurser<Class<?>, Method, Class<? extends Annotation>> declaredMethodWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final Repeat.Recurser<Class<?>, Class<?>, Class<? extends Annotation>> classWithAnnotationRecurser = (member, arg) -> member.getAnnotation(arg) != null;
    private static final BiPredicate<Field, Class<? extends Annotation>> declaredFieldWithAnnotationFilter = (m, a) -> m.getAnnotation(a) != null;
    private static final BiPredicate<Method, Class<? extends Annotation>> declaredMethodWithAnnotationFilter = (m, a) -> m.getAnnotation(a) != null;
    private static final BiPredicate<Class<?>, Class<? extends Annotation>> classWithAnnotationFilter = (m, a) -> m.getAnnotation(a) != null;
    private static final IdentityHashMap<Class<?>, Executable> classToExecutable = new IdentityHashMap();

    public static String getDeclaringClassName(String className) {
        char ch;
        if (!Identifiers.isValid(className)) {
            throw new IllegalArgumentException("Not a valid java identifier: " + className);
        }
        int index = className.length() - 1;
        while ((index = className.lastIndexOf(36, index - 1)) > 1 && ((ch = className.charAt(index - 1)) == '.' || ch == '$')) {
        }
        return index <= 0 ? className : className.substring(0, index);
    }

    public static String getRootDeclaringClassName(String className) {
        if (!Identifiers.isValid(className)) {
            throw new IllegalArgumentException("Not a valid java identifier: " + className);
        }
        int limit = className.length() - 1;
        int index = 0;
        while ((index = className.indexOf(36, index + 1)) > 1) {
            char ch = className.charAt(index - 1);
            if (index == limit) {
                return className;
            }
            if (ch == '.' || ch == '$') continue;
            break;
        }
        return index == -1 ? className : className.substring(0, index);
    }

    public static String toCanonicalClassName(String className) {
        if (!Identifiers.isValid(className)) {
            throw new IllegalArgumentException("Not a valid java identifier: " + className);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(className.charAt(0));
        builder.append(className.charAt(1));
        int last = 0;
        for (int i = 2; i < className.length() - 1; ++i) {
            int ch = className.charAt(i);
            builder.append((char)(last != 46 && last != 36 && ch == 36 ? 46 : ch));
            last = ch;
        }
        if (className.length() > 2) {
            builder.append(className.charAt(className.length() - 1));
        }
        return builder.toString();
    }

    public static String getCompoundName(Class<?> cls) {
        String pkg = cls.getPackage().getName();
        return pkg.length() == 0 ? cls.getName() : cls.getName().substring(pkg.length() + 1);
    }

    public static String getCanonicalCompoundName(Class<?> cls) {
        String pkg = cls.getPackage().getName();
        return pkg.length() == 0 ? cls.getCanonicalName() : cls.getCanonicalName().substring(pkg.length() + 1);
    }

    public static Type[] getSuperclassGenericTypes(Class<?> cls) {
        return cls.getGenericSuperclass() instanceof ParameterizedType ? ((ParameterizedType)cls.getGenericSuperclass()).getActualTypeArguments() : null;
    }

    public static Set<Class<?>> getClassHierarchy(Class<?> cls, Predicate<? super Class<?>> forEach) {
        LinkedList queue = new LinkedList();
        LinkedHashSet visited = new LinkedHashSet();
        if (!Classes.visitSuperclass(cls, queue, visited, forEach)) {
            return visited;
        }
        do {
            if (!Classes.visitSuperclass(cls.getSuperclass(), queue, visited, forEach)) {
                return visited;
            }
            for (Class<?> superInterface : cls.getInterfaces()) {
                if (Classes.visitSuperclass(superInterface, queue, visited, forEach)) continue;
                return visited;
            }
        } while ((cls = (Class)queue.poll()) != null);
        return visited;
    }

    private static boolean visitSuperclass(Class<?> cls, Queue<? super Class<?>> queue, Set<? super Class<?>> visited, Predicate<? super Class<?>> forEach) {
        if (cls == null || !visited.add(cls)) {
            return true;
        }
        if (!forEach.test(cls)) {
            return false;
        }
        queue.add(cls);
        return true;
    }

    public static Class<?>[] getGenericClasses(Field field) {
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            return new Class[0];
        }
        Type[] types = ((ParameterizedType)genericType).getActualTypeArguments();
        Class[] classes = new Class[types.length];
        for (int i = 0; i < classes.length; ++i) {
            if (types[i] instanceof Class) {
                classes[i] = (Class)types[i];
                continue;
            }
            if (!(types[i] instanceof ParameterizedType)) continue;
            classes[i] = (Class)((ParameterizedType)types[i]).getRawType();
        }
        return classes;
    }

    private static Field getField(Class<?> cls, String fieldName, boolean declared) {
        Field[] fields;
        for (Field field : fields = declared ? cls.getDeclaredFields() : cls.getFields()) {
            if (!fieldName.equals(field.getName())) continue;
            return field;
        }
        return null;
    }

    public static Field getField(Class<?> cls, String name) {
        return Classes.getField(cls, name, false);
    }

    public static Field getDeclaredField(Class<?> cls, String name) {
        return Classes.getField(cls, name, true);
    }

    public static Field getDeclaredFieldDeep(Class<?> cls, String name) {
        Field field;
        while ((field = Classes.getField(cls, name, true)) == null && (cls = cls.getSuperclass()) != null) {
        }
        return field;
    }

    public static <T> Constructor<T> getConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (!(parameterTypes == null || parameterTypes.length == 0 ? constructor.getParameterCount() == 0 : parameterTypes.length == constructor.getParameterCount() && Arrays.equals(constructor.getParameterTypes(), parameterTypes))) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getCompatibleConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getConstructors()) {
            if (!Classes.isCompatible(constructor.getParameterTypes(), parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> cls, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = cls.getDeclaredConstructors()) {
            if (!(parameterTypes == null || parameterTypes.length == 0 ? constructor.getParameterCount() == 0 : parameterTypes.length == constructor.getParameterCount() && Arrays.equals(constructor.getParameterTypes(), parameterTypes))) continue;
            return constructor;
        }
        return null;
    }

    public static <T> T setAnnotationValue(Annotation annotation, String key, T newValue) {
        Map memberValues;
        InvocationHandler handler = Proxy.getInvocationHandler(annotation);
        Objects.requireNonNull(key);
        Objects.requireNonNull(newValue);
        try {
            Field field = handler.getClass().getDeclaredField("memberValues");
            field.setAccessible(true);
            memberValues = (Map)field.get(handler);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        Object oldValue = memberValues.get(key);
        if (oldValue == null) {
            throw new IllegalArgumentException(key + " is not a valid key");
        }
        if (newValue.getClass() != oldValue.getClass()) {
            throw new IllegalArgumentException(newValue.getClass().getName() + " does not match the required type " + oldValue.getClass().getName());
        }
        memberValues.put(key, newValue);
        return (T)oldValue;
    }

    public static Field[] getDeclaredFieldsDeep(Class<?> cls) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredFields(), Field.class, declaredFieldRecurser, null);
    }

    public static Field[] getDeclaredFieldsDeep(Class<?> cls, Predicate<Field> predicate) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredFields(), Field.class, declaredFieldWithPredicateRecurser, Objects.requireNonNull(predicate));
    }

    public static Field[] getDeclaredFieldsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getDeclaredFields(), Field.class, declaredFieldWithAnnotationFilter, Objects.requireNonNull(annotationType));
    }

    public static Field[] getDeclaredFieldsWithAnnotationDeep(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredFields(), Field.class, declaredFieldWithAnnotationRecurser, Objects.requireNonNull(annotationType));
    }

    public static Method getMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = cls.getMethods()) {
            if (!name.equals(method.getName()) || !(parameterTypes == null || parameterTypes.length == 0 ? method.getParameterCount() == 0 : parameterTypes.length == method.getParameterCount() && Arrays.equals(method.getParameterTypes(), parameterTypes))) continue;
            return method;
        }
        return null;
    }

    private static boolean isCompatible(Class<?>[] parameterTypes, Class<?>[] args) {
        if (parameterTypes.length != args.length) {
            return false;
        }
        int len = parameterTypes.length;
        for (int i = 0; i < len; ++i) {
            if (args[i] == null || Classes.isAssignable(parameterTypes[i], args[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isAssignable(Class<?> target, Class<?> cls) {
        if (target.isPrimitive()) {
            return (cls.isPrimitive() ? target : Classes.toWrapper(target)) == cls;
        }
        return target.isAssignableFrom(cls.isPrimitive() ? Classes.toWrapper(cls) : cls);
    }

    public static Method getCompatibleMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = cls.getMethods()) {
            if (!name.equals(method.getName()) || !Classes.isCompatible(method.getParameterTypes(), parameterTypes)) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method[] methods;
        for (Method method : methods = cls.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || !(parameterTypes == null || parameterTypes.length == 0 ? method.getParameterCount() == 0 : Arrays.equals(method.getParameterTypes(), parameterTypes))) continue;
            return method;
        }
        return null;
    }

    public static Method getDeclaredMethodDeep(Class<?> cls, String name, Class<?> ... parameterTypes) {
        Method method;
        while ((method = Classes.getDeclaredMethod(cls, name, parameterTypes)) == null && (cls = cls.getSuperclass()) != null) {
        }
        return method;
    }

    public static Method[] getDeclaredMethodsDeep(Class<?> cls) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredMethods(), Method.class, declaredMethodRecurser, null);
    }

    public static Method[] getDeclaredMethodsDeep(Class<?> cls, Predicate<Method> predicate) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredMethods(), Method.class, declaredMethodWithPredicateRecurser, Objects.requireNonNull(predicate));
    }

    public static Method[] getDeclaredMethodsWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getDeclaredMethods(), Method.class, declaredMethodWithAnnotationFilter, Objects.requireNonNull(annotationType));
    }

    public static Method[] getDeclaredMethodsWithAnnotationDeep(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredMethods(), Method.class, declaredMethodWithAnnotationRecurser, Objects.requireNonNull(annotationType));
    }

    public static Class<?>[] getDeclaredClassesWithAnnotation(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.ordered(cls.getDeclaredClasses(), Class.class.getClass(), classWithAnnotationFilter, Objects.requireNonNull(annotationType));
    }

    public static Class<?>[] getDeclaredClassesWithAnnotationDeep(Class<?> cls, Class<? extends Annotation> annotationType) {
        return Repeat.Recursive.inverted(cls, cls.getDeclaredClasses(), Class.class.getClass(), classWithAnnotationRecurser, Objects.requireNonNull(annotationType));
    }

    private static void recurse(Class<?> iface, HashSet<Class<?>> set) {
        if (set.contains(iface)) {
            return;
        }
        set.add(iface);
        for (Class<?> extended : iface.getInterfaces()) {
            Classes.recurse(extended, set);
        }
    }

    public static Class<?>[] getAllInterfaces(Class<?> cls) {
        Class<?> parent = cls;
        Class<?>[] ifaces = null;
        HashSet set = null;
        do {
            if ((ifaces = parent.getInterfaces()).length == 0) continue;
            if (set == null) {
                set = new HashSet(4);
            }
            for (Class<?> iface : ifaces) {
                Classes.recurse(iface, set);
            }
        } while ((parent = parent.getSuperclass()) != null);
        return set == null ? ifaces : set.toArray(new Class[set.size()]);
    }

    public static Class<?> getGreatestCommonSuperclass(Class<?> ... classes) {
        if (classes.length == 0) {
            throw new IllegalArgumentException("Number of arguments must be greater than 0");
        }
        if (classes.length == 1) {
            return classes[0];
        }
        Class<?> gcc = Classes.getGreatestCommonSuperclass(classes[0], classes[1]);
        for (int i = 2; i < classes.length && gcc != null; ++i) {
            gcc = Classes.getGreatestCommonSuperclass(gcc, classes[i]);
        }
        return gcc;
    }

    @SafeVarargs
    public static <T> Class<?> getGreatestCommonSuperclass(T ... objects) {
        if (objects.length == 0) {
            throw new IllegalArgumentException("Number of arguments must be greater than 0");
        }
        return Classes.getGreatestCommonSuperclass0(objects);
    }

    public static <T> Class<?> getGreatestCommonSuperclass(Collection<T> objects) {
        if (objects.size() == 0) {
            throw new IllegalArgumentException("Collection size must be greater than 0");
        }
        return Classes.getGreatestCommonSuperclass0(objects.toArray());
    }

    private static Class<?> getGreatestCommonSuperclass(Class<?> c1, Class<?> c2) {
        Class<?> c0 = c2;
        while (true) {
            if (c1.isAssignableFrom(c2)) {
                return c1;
            }
            if ((c2 = c2.getSuperclass()) != null) continue;
            c2 = c0;
            if ((c1 = c1.getSuperclass()) == null) break;
        }
        return null;
    }

    @SafeVarargs
    private static <T> Class<?> getGreatestCommonSuperclass0(T ... objects) {
        if (objects.length == 1) {
            return objects[0].getClass();
        }
        Class<?> gcc = Classes.getGreatestCommonSuperclass(objects[0].getClass(), objects[1].getClass());
        for (int i = 2; i < objects.length && gcc != null; ++i) {
            gcc = Classes.getGreatestCommonSuperclass(gcc, objects[i].getClass());
        }
        return gcc;
    }

    public static Class<?>[] getExecutionStack() {
        Class<?>[] context = new CallingClass().getClassContext();
        Class[] executionStack = new Class[context.length - 3];
        for (int i = 3; i < context.length; ++i) {
            executionStack[i - 3] = context[i];
        }
        return executionStack;
    }

    public static Class<?> toWrapper(Class<?> primitiveType) {
        if (!primitiveType.isPrimitive()) {
            return primitiveType;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        if (primitiveType == Void.TYPE) {
            return Void.class;
        }
        throw new UnsupportedOperationException("Unsupported class type: " + primitiveType.getName());
    }

    public static <T> T newInstance(Class<T> type, Object ... parameters) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Method fromString;
        Executable executable;
        if (type.isPrimitive()) {
            type = Classes.toWrapper(type);
        }
        if ((executable = classToExecutable.get(type)) != null) {
            return (T)(executable instanceof Constructor ? ((Constructor)executable).newInstance(parameters) : ((Method)executable).invoke(null, parameters));
        }
        Class[] parameterTypes = new Class[parameters.length];
        int len = parameters.length;
        for (int i = 0; i < len; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        if (parameterTypes.length == 1 && parameterTypes[0] == String.class && (fromString = Classes.getMethod(type, "fromString", parameterTypes)) != null && Modifier.isStatic(fromString.getModifiers())) {
            classToExecutable.put(type, fromString);
            return (T)fromString.invoke(null, parameters);
        }
        Method valueOf = Classes.getCompatibleMethod(type, "valueOf", parameterTypes);
        if (valueOf != null && Modifier.isStatic(valueOf.getModifiers())) {
            classToExecutable.put(type, valueOf);
            return (T)valueOf.invoke(null, parameters);
        }
        Constructor<T> constructor = Classes.getCompatibleConstructor(type, parameterTypes);
        if (constructor != null) {
            classToExecutable.put(type, constructor);
            return constructor.newInstance(parameters);
        }
        String types = Arrays.stream(parameterTypes).map(p -> p.getName()).collect(Collectors.joining(","));
        StringBuilder message = new StringBuilder();
        message.append(type.getName() + " does not define <init>(" + types + ")");
        if (parameterTypes.length == 1 && parameterTypes[0] == String.class) {
            message.append(", valueOf(" + types + "), or fromString(" + types + ")");
        } else {
            message.append(" or valueOf(" + types + ")");
        }
        throw new IllegalArgumentException(message.toString());
    }

    private Classes() {
    }

    private static class CallingClass
    extends SecurityManager {
        private CallingClass() {
        }

        @Override
        public Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }

    @FunctionalInterface
    private static interface DeclaredClassRecurser<A>
    extends SuperclassRecurser<Class<?>, A> {
        default public Class<?>[] members(Class<?> container) {
            return container.getDeclaredClasses();
        }
    }

    @FunctionalInterface
    private static interface DeclaredMethodRecurser<A>
    extends SuperclassRecurser<Method, A> {
        default public Method[] members(Class<?> container) {
            return container.getDeclaredMethods();
        }
    }

    @FunctionalInterface
    private static interface DeclaredFieldRecurser<A>
    extends SuperclassRecurser<Field, A> {
        default public Field[] members(Class<?> container) {
            return container.getDeclaredFields();
        }
    }

    private static interface SuperclassRecurser<M, A>
    extends Repeat.Recurser<Class<?>, M, A> {
        @Override
        default public Class<?> next(Class<?> container) {
            return container.getSuperclass();
        }
    }
}

