/*
 * Decompiled with CFR 0.152.
 */
package org.libj.lang;

public final class Assertions {
    public static void assertRangeArray(int fromIndex, int toIndex, int length) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > length) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    public static int assertRangeArray(int index, int length) {
        if (index < 0 || length <= index) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        return index;
    }

    public static int assertRange(int index, int length) {
        if (index < 0 || length <= index) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        return index;
    }

    public static void assertRange(int fromIndex, int toIndex, int size) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > size) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
    }

    public static int assertRange(int index, int size, boolean forAdd) {
        if (index < 0 || (forAdd ? size < index : size <= index)) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        return index;
    }

    public static void assertBoundsOffsetCount(int length, int offset, int count, String lengthLabel, String offsetLabel, String countLabel) {
        if (length < 0) {
            throw new IllegalArgumentException(lengthLabel + " = " + length);
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException(offsetLabel + " = " + offset);
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException(countLabel + " = " + count);
        }
        if (length < offset + count) {
            throw new IndexOutOfBoundsException(lengthLabel + " (" + length + ") < " + offsetLabel + " (" + offset + ") + " + countLabel + " (" + count + ")");
        }
    }

    private Assertions() {
    }
}

