/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.threads;

import java.util.List;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ListIteratorContext;
import org.kuali.common.threads.ListIteratorThread;
import org.kuali.common.threads.ThreadHandler;
import org.kuali.common.threads.ThreadHandlerContext;
import org.kuali.common.threads.listener.ProgressNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadHandlerFactory {
    protected int[] getDivideEvenly(int numerator, int denominator) {
        int quotient = numerator / denominator;
        int remainder = numerator % denominator;
        int[] lengths = new int[denominator];
        for (int i = 0; i < denominator; ++i) {
            int length;
            lengths[i] = length = i < remainder ? quotient + 1 : quotient;
        }
        return lengths;
    }

    public <T> ThreadHandler<T> getThreadHandler(ThreadHandlerContext<T> context) {
        List<T> list = context.getList();
        int elements = list.size();
        int max = context.getMax();
        int min = context.getMin();
        int threadCount = this.getThreadCount(max, min, elements, context.getDivisor());
        int[] lengths = this.getDivideEvenly(elements, threadCount);
        ThreadHandler handler = new ThreadHandler();
        handler.setThreadCount(threadCount);
        ProgressNotifier<T> notifier = new ProgressNotifier<T>();
        notifier.setListener(context.getListener());
        notifier.setTotal(list.size());
        handler.setNotifier(notifier);
        ThreadGroup group = new ThreadGroup("List Iterator Threads");
        group.setDaemon(true);
        Thread[] threads = this.getThreads(handler, list, context.getHandler(), lengths);
        handler.setGroup(group);
        handler.setThreads(threads);
        return handler;
    }

    protected <T> Thread[] getThreads(ThreadHandler<T> thandler, List<T> list, ElementHandler<T> ehandler, int[] lengths) {
        Thread[] threads = new Thread[thandler.getThreadCount()];
        int offset = 0;
        for (int i = 0; i < threads.length; ++i) {
            int id = i + 1;
            int length = lengths[i];
            ListIteratorContext<T> context = new ListIteratorContext<T>(id, offset, length, list);
            context.setNotifier(thandler.getNotifier());
            context.setThreadHandler(thandler);
            context.setElementHandler(ehandler);
            ListIteratorThread<T> runnable = new ListIteratorThread<T>(context);
            threads[i] = this.getThread(runnable, id, thandler.getGroup(), thandler);
            offset += length;
        }
        return threads;
    }

    protected <T> Thread getThread(Runnable runnable, int id, ThreadGroup group, Thread.UncaughtExceptionHandler handler) {
        Thread thread = new Thread(group, runnable, "ListIterator-" + id);
        thread.setUncaughtExceptionHandler(handler);
        thread.setDaemon(true);
        return thread;
    }

    protected int getThreadCount(int max, int min, int elements, int divisor) {
        min = min > max ? max : min;
        this.validate(max, min, elements, divisor);
        max = max > elements ? elements : max;
        min = min > elements ? elements : min;
        int threads = divisor > 0 ? elements / divisor : max;
        threads = threads > max ? max : threads;
        threads = threads < min ? min : threads;
        return threads;
    }

    protected void validate(int max, int min, int elements, int divisor) {
        StringBuilder sb = new StringBuilder();
        if (divisor < 0) {
            sb.append(" [divisor must be >= 0] ");
        }
        if (max < 1) {
            sb.append(" [max must be >= 1] ");
        }
        if (min < 0) {
            sb.append(" [min must be >= 0] ");
        }
        if (elements < 0) {
            sb.append(" [elements must be >= 0] ");
        }
        if (min > max) {
            sb.append(" [min must be <= max] ");
        }
        if (sb.length() > 0) {
            throw new IllegalArgumentException(sb.toString());
        }
    }
}

