/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.threads;

import org.kuali.common.threads.ExecutionStatistics;
import org.kuali.common.threads.ThreadHandlerException;
import org.kuali.common.threads.listener.ProgressNotifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadHandler<T>
implements Thread.UncaughtExceptionHandler {
    ThreadGroup group;
    Thread[] threads;
    ThreadHandlerException exception;
    boolean stopThreads;
    int threadCount;
    ProgressNotifier<T> notifier;
    boolean rethrowException = true;
    ExecutionStatistics executionStatistics;

    public ThreadGroup getGroup() {
        return this.group;
    }

    public void setGroup(ThreadGroup group) {
        this.group = group;
    }

    public Thread[] getThreads() {
        return this.threads;
    }

    public void setThreads(Thread[] threads) {
        this.threads = threads;
    }

    public void executeThreads() {
        long start = System.currentTimeMillis();
        this.start();
        this.join();
        long millis = System.currentTimeMillis() - start;
        this.executionStatistics = new ExecutionStatistics();
        this.executionStatistics.setExecutionTime(millis);
        this.executionStatistics.setThreadCount(this.threadCount);
        this.executionStatistics.setIterationCount(this.notifier.getProgress());
        if (this.isThrowException()) {
            throw this.exception;
        }
    }

    protected boolean isThrowException() {
        return this.rethrowException && this.exception != null;
    }

    protected void start() {
        for (Thread thread : this.threads) {
            thread.start();
        }
    }

    protected void join() {
        try {
            for (Thread thread : this.threads) {
                thread.join();
            }
        }
        catch (InterruptedException e) {
            throw new ThreadHandlerException(e);
        }
    }

    @Override
    public synchronized void uncaughtException(Thread t, Throwable e) {
        this.stopThreads = true;
        this.group.interrupt();
        long id = t.getId();
        String name = t.getName();
        this.exception = new ThreadHandlerException("Exception in thread [" + id + ":" + name + "]", e);
    }

    public synchronized boolean isStopThreads() {
        return this.stopThreads;
    }

    public ThreadHandlerException getException() {
        return this.exception;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public ProgressNotifier<T> getNotifier() {
        return this.notifier;
    }

    public void setNotifier(ProgressNotifier<T> notifier) {
        this.notifier = notifier;
    }

    public boolean isRethrowException() {
        return this.rethrowException;
    }

    public void setRethrowException(boolean rethrowException) {
        this.rethrowException = rethrowException;
    }

    public ExecutionStatistics getExecutionStatistics() {
        return this.executionStatistics;
    }
}

