/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.threads;

import java.util.List;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ListIteratorContext;
import org.kuali.common.threads.listener.ProgressEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListIteratorThread<T>
implements Runnable {
    ListIteratorContext<T> context;

    public ListIteratorThread() {
        this(null);
    }

    public ListIteratorThread(ListIteratorContext<T> context) {
        this.context = context;
    }

    @Override
    public void run() {
        int offset = this.context.getOffset();
        int length = this.context.getLength();
        List<T> list = this.context.getList();
        ElementHandler<T> handler = this.context.getElementHandler();
        for (int i = offset; i < offset + length && !this.context.getThreadHandler().isStopThreads(); ++i) {
            T element = list.get(i);
            handler.handleElement(this.context, i, element);
            ProgressEvent<T> event = new ProgressEvent<T>();
            event.setElement(element);
            event.setIndex(i);
            this.context.getNotifier().notify(event);
        }
    }

    public ListIteratorContext<T> getContext() {
        return this.context;
    }

    public void setContext(ListIteratorContext<T> context) {
        this.context = context;
    }
}

