/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.aws.s3;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.kuali.common.aws.s3.Size;

public class SimpleFormatter {
    private static final double SECOND = 1000.0;
    private static final double MINUTE = 60000.0;
    private static final double HOUR = 3600000.0;
    private static final double DAY = 8.64E7;
    private static final double YEAR = 3.1536E10;
    private static final double DECADE = 3.1536E11;
    private static final double CENTURY = 3.1536E12;
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SZ";
    NumberFormat largeSizeFormatter = NumberFormat.getInstance();
    NumberFormat sizeFormatter = NumberFormat.getInstance();
    NumberFormat timeFormatter = NumberFormat.getInstance();
    NumberFormat rateFormatter = NumberFormat.getInstance();
    NumberFormat countFormatter = NumberFormat.getInstance();
    SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SZ");

    public SimpleFormatter() {
        this.sizeFormatter.setGroupingUsed(false);
        this.sizeFormatter.setMaximumFractionDigits(1);
        this.sizeFormatter.setMinimumFractionDigits(1);
        this.largeSizeFormatter.setGroupingUsed(false);
        this.largeSizeFormatter.setMaximumFractionDigits(3);
        this.largeSizeFormatter.setMinimumFractionDigits(3);
        this.timeFormatter.setGroupingUsed(false);
        this.timeFormatter.setMaximumFractionDigits(3);
        this.timeFormatter.setMinimumFractionDigits(3);
        this.rateFormatter.setGroupingUsed(false);
        this.rateFormatter.setMaximumFractionDigits(3);
        this.rateFormatter.setMinimumFractionDigits(3);
        this.countFormatter.setGroupingUsed(true);
        this.countFormatter.setMaximumFractionDigits(0);
        this.countFormatter.setMinimumFractionDigits(0);
    }

    public String getDate(long millis) {
        return this.getDate(new Date(millis));
    }

    public String getDate(Date date) {
        return this.dateFormatter.format(date);
    }

    public String getRate(long millis, long bytes) {
        double seconds = (double)millis / 1000.0;
        double bytesPerSecond = (double)bytes / seconds;
        Size bandwidthLevel = this.getSizeEnum(bytesPerSecond);
        double transferRate = bytesPerSecond / (double)bandwidthLevel.getValue();
        return this.rateFormatter.format(transferRate) + " " + bandwidthLevel.getRateLabel();
    }

    public String getCount(long count) {
        return this.countFormatter.format(count);
    }

    public String getTime(long millis) {
        if ((double)millis < 1000.0) {
            return millis + "ms";
        }
        if ((double)millis < 60000.0) {
            return this.timeFormatter.format((double)millis / 1000.0) + "s";
        }
        if ((double)millis < 3600000.0) {
            return this.timeFormatter.format((double)millis / 60000.0) + "m";
        }
        if ((double)millis < 8.64E7) {
            return this.timeFormatter.format((double)millis / 3600000.0) + " hours";
        }
        if ((double)millis < 3.1536E10) {
            return this.timeFormatter.format((double)millis / 8.64E7) + " days";
        }
        if ((double)millis < 3.1536E11) {
            return this.timeFormatter.format((double)millis / 3.1536E10) + " years";
        }
        if ((double)millis < 3.1536E12) {
            return this.timeFormatter.format((double)millis / 3.1536E11) + " decades";
        }
        return this.timeFormatter.format((double)millis / 3.1536E12) + " centuries";
    }

    public String getSize(long bytes) {
        return this.getSize(bytes, null);
    }

    public String getSize(long bytes, Size size) {
        size = size == null ? this.getSizeEnum(bytes) : size;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFormattedSize(bytes, size));
        if (this.needsSpaceBeforeLabel(size)) {
            sb.append(" ");
        }
        sb.append(size.getSizeLabel());
        return sb.toString();
    }

    protected boolean needsSpaceBeforeLabel(Size size) {
        switch (size) {
            case BYTE: 
            case TB: 
            case PB: 
            case EB: {
                return true;
            }
        }
        return false;
    }

    public String getFormattedSize(long bytes, Size size) {
        switch (size) {
            case BYTE: {
                return bytes + "";
            }
            case KB: 
            case MB: 
            case GB: {
                return this.sizeFormatter.format((double)bytes / (double)size.getValue());
            }
        }
        return this.largeSizeFormatter.format((double)bytes / (double)size.getValue());
    }

    public Size getSizeEnum(double bytes) {
        if (bytes < (double)Size.KB.getValue()) {
            return Size.BYTE;
        }
        if (bytes < (double)Size.MB.getValue()) {
            return Size.KB;
        }
        if (bytes < (double)Size.GB.getValue()) {
            return Size.MB;
        }
        if (bytes < (double)Size.TB.getValue()) {
            return Size.GB;
        }
        if (bytes < (double)Size.PB.getValue()) {
            return Size.TB;
        }
        if (bytes < (double)Size.EB.getValue()) {
            return Size.PB;
        }
        return Size.EB;
    }

    public NumberFormat getLargeSizeFormatter() {
        return this.largeSizeFormatter;
    }

    public void setLargeSizeFormatter(NumberFormat sizeFormatter) {
        this.largeSizeFormatter = sizeFormatter;
    }

    public NumberFormat getTimeFormatter() {
        return this.timeFormatter;
    }

    public void setTimeFormatter(NumberFormat timeFormatter) {
        this.timeFormatter = timeFormatter;
    }

    public NumberFormat getRateFormatter() {
        return this.rateFormatter;
    }

    public void setRateFormatter(NumberFormat rateFormatter) {
        this.rateFormatter = rateFormatter;
    }

    public NumberFormat getSizeFormatter() {
        return this.sizeFormatter;
    }

    public void setSizeFormatter(NumberFormat smallSizeFormatter) {
        this.sizeFormatter = smallSizeFormatter;
    }
}

