/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Locale;
import java.util.ResourceBundle;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONUtil;

public final class JSONReflectionException
extends JSONException {
    private Object offender = null;
    private String field = null;
    private int level;
    private boolean badObject = false;
    private static final long serialVersionUID = 1L;

    JSONReflectionException(Object offender, String field, Exception e, JSONConfig cfg) {
        super(e, cfg);
        this.offender = offender;
        this.field = field;
    }

    JSONReflectionException(int level, JSONConfig cfg) {
        super(cfg);
        this.level = level;
    }

    JSONReflectionException() {
        super(new JSONConfig());
        this.badObject = true;
    }

    JSONReflectionException(Object offender, String field, JSONConfig cfg) {
        super(cfg);
        this.offender = offender;
        this.field = field;
    }

    @Override
    String internalGetMessage(Locale locale) {
        ResourceBundle bundle = JSONUtil.getBundle(locale);
        if (this.offender != null) {
            if (this.getCause() != null) {
                String fmt = bundle.getString("reflectionException");
                return String.format(fmt, this.getClassName(this.offender), this.field, this.getClassName(this.getCause()));
            }
            String fmt = bundle.getString("noSuchField");
            return String.format(fmt, this.getClassName(this.offender), this.field);
        }
        if (this.badObject) {
            return bundle.getString("recursiveReflection");
        }
        String fmt = bundle.getString("badPrivacyLevel");
        return String.format(fmt, this.level);
    }
}

