/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.List;
import org.kopitubruk.util.json.DataStructureLoopException;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.LoopDetectionFailureException;

class DataStructureLoopDetector {
    private JSONConfig cfg;
    private Object propertyValue;
    private List<Object> objStack;
    private int stackIndex;

    DataStructureLoopDetector(JSONConfig cfg, Object propertyValue) {
        this.cfg = cfg;
        this.propertyValue = propertyValue;
        this.objStack = cfg.getObjStack();
        for (Object o : this.objStack) {
            if (o != propertyValue) continue;
            throw new DataStructureLoopException(propertyValue, cfg);
        }
        this.stackIndex = this.objStack.size();
        this.objStack.add(propertyValue);
    }

    void popDataStructureStack() {
        if (this.objStack.size() != this.stackIndex + 1 || this.objStack.get(this.stackIndex) != this.propertyValue) {
            throw new LoopDetectionFailureException(this.stackIndex, this.cfg);
        }
        this.objStack.remove(this.stackIndex);
    }
}

